/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.task;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.tariff.voice.calc.ItemZoneCostCache;
import bitel.billing.server.tariff.voice.calc.ItemZoneTrafficCache;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.modules.voiceip.server.bean.LoginType;
import ru.bitel.bgbilling.modules.voiceip.server.bean.LoginTypeManager;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpLogin;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpLoginManager;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpSession;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpSessionUtils;
import ru.bitel.bgbilling.modules.voiceip.server.mail.MailTaskSessionsRecalculator;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class SessionsRecalculator
extends RunTask {
    private static final boolean debug = false;
    private int moduleId = -1;
    private String _email;
    private Calendar _date1;
    private Calendar _date2;
    private Date _sqlDate1;
    private Date _sqlDate2;
    private long _groups = 0L;
    private String _contractTitle;
    private int _callType = -1;
    private int _destCode = -1;
    private String logSessionTableName;
    private Map<Integer, LoginItem> _logins = new HashMap<Integer, LoginItem>();
    private Map<Integer, TariffTreeSet> contractTreeSets = new HashMap<Integer, TariffTreeSet>();
    private ItemZoneTrafficCache itemZoneTrafficCache = new ItemZoneTrafficCache();
    private ItemZoneCostCache itemZoneCostCache = new ItemZoneCostCache();
    private Connection con;
    private Connection conSlave;
    private SessionUpdater sessionUpdater;
    private final boolean onlyOperatorCost;
    private PreparedStatement psSelectAmounts;

    public SessionsRecalculator(String email, Calendar date1, Calendar date2, int callType, int destCode, int mid, long groups, String contractTitle, boolean onlyOperatorCost) {
        this._email = email;
        this._date1 = date1;
        this._date2 = date2;
        this._callType = callType;
        this._destCode = destCode;
        this.moduleId = mid;
        this._groups = groups;
        this._contractTitle = contractTitle;
        this._sqlDate1 = TimeUtils.convertCalendarToSqlDate((Calendar)this._date1);
        this._sqlDate2 = TimeUtils.convertCalendarToSqlDate((Calendar)this._date2);
        this.onlyOperatorCost = onlyOperatorCost;
    }

    public String getDescription() {
        return "\u041c\u043e\u0434\u0443\u043b\u044c VoiceIP. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0430 \u0441\u0435\u0441\u0441\u0438\u0439. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ". \u0417\u0430 \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.format((Calendar)this._date1, (String)"MM.yyyy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() {
        this.con = this.setup.getDBConnectionFromPool();
        this.conSlave = this.setup.getDBSlaveConnectionFromPool();
        try {
            Map<Integer, LoginType> typeMap = new LoginTypeManager(this.conSlave, this.moduleId).getTypeMap();
            StringBuffer query = new StringBuffer("SELECT * FROM user_login_");
            query.append(this.moduleId);
            boolean wasContractFilter = false;
            if (this._groups > 0L) {
                String cids = new ContractUtils(this.conSlave).getCids(this._groups);
                query.append(" WHERE cid IN ( ");
                query.append(cids);
                query.append(" ) ");
                wasContractFilter = true;
            }
            if (this._contractTitle != null) {
                String q = "SELECT id FROM contract WHERE title=?";
                PreparedStatement ps = this.conSlave.prepareStatement(q);
                ps.setString(1, this._contractTitle);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) {
                    System.err.println("Not found contract " + this._contractTitle);
                    return;
                }
                query.append(" WHERE cid=");
                query.append(rs.getInt(1));
                ps.close();
                wasContractFilter = true;
            }
            LoginType defaultType = new LoginType();
            StringBuffer lids = new StringBuffer();
            VoiceIpLoginManager loginManager = new VoiceIpLoginManager(this.conSlave, this.moduleId);
            ResultSet rs = this.conSlave.createStatement().executeQuery(query.toString());
            while (rs.next()) {
                VoiceIpLogin login = loginManager.getLoginFromResultSet(rs);
                LoginType type = typeMap.get(login.getType());
                if (type == null) {
                    type = defaultType;
                }
                login.importTypeOptions(type);
                LoginItem item = new LoginItem();
                item.login = login;
                this._logins.put(login.getId(), item);
                if (!wasContractFilter) continue;
                if (lids.length() != 0) {
                    lids.append(", ");
                }
                lids.append(rs.getString("id"));
            }
            this.logSessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (java.util.Date)this._date1.getTime(), (int)this.moduleId);
            if (this.onlyOperatorCost) {
                this.getLogger().info("Update only oper_session_cost/oper_round_session_time.");
                this.sessionUpdater = new OperatorSessionUpdater();
            } else {
                this.sessionUpdater = new SessionUpdater();
            }
            HashSet<Integer> cidsForRecalculate = new HashSet<Integer>();
            query = new StringBuffer("SELECT * FROM ");
            query.append(this.logSessionTableName);
            query.append(" WHERE ( ? IS NULL OR TO_DAYS(?)<=TO_DAYS(session_start) ) ");
            query.append(" AND ( ? IS NULL OR TO_DAYS(?)>=TO_DAYS(session_start) ) ");
            if (this._callType > 0) {
                query.append(" AND type=");
                query.append(this._callType);
            }
            if (this._destCode >= 0) {
                query.append(" AND dest_code=");
                query.append(this._destCode);
            }
            if (wasContractFilter) {
                query.append(" AND lid IN ( ");
                query.append(lids);
                query.append(") ");
            }
            PreparedStatement psSelectSessions = this.conSlave.prepareStatement(query.toString());
            psSelectSessions.setDate(1, this._sqlDate1);
            psSelectSessions.setDate(2, this._sqlDate1);
            psSelectSessions.setDate(3, this._sqlDate2);
            psSelectSessions.setDate(4, this._sqlDate2);
            VoiceIpSessionUtils su = new VoiceIpSessionUtils(this.con, this.moduleId);
            BalanceUtils bu = new BalanceUtils(this.con);
            ContractUtils cu = new ContractUtils(this.conSlave);
            ContractManager contrM = new ContractManager(this.conSlave);
            StringBuffer report = new StringBuffer();
            report.append("\u0417\u0430\u043f\u0443\u0441\u043a \u043f\u0435\u0440\u0435\u0441\u0447\u0435\u0442\u0430 => ");
            report.append(TimeUtils.format((Calendar)new GregorianCalendar(), (String)"dd.MM.yyyy HH:mm:ss"));
            report.append("\n");
            System.out.println("Start voip recalc...");
            int count = 0;
            int errorCnt = 0;
            if (ServerUtils.tableExists((Connection)this.con, (String)this.logSessionTableName)) {
                VoiceIpSession.addColumns(this.con, this.logSessionTableName);
                rs = psSelectSessions.executeQuery();
                while (rs.next()) {
                    errorCnt = this.calcSession(this.con, rs, cidsForRecalculate, cu, contrM, report, count, errorCnt);
                    if (++count % 100 != 0) continue;
                    System.out.println("count => " + count);
                }
                rs.close();
            }
            if (!this.onlyOperatorCost) {
                for (Integer cid : cidsForRecalculate) {
                    su.setContractAccountFromSession(this._date1.getTime(), cid);
                    bu.setBalanceFromAccount(cid.intValue(), this._date1);
                }
            }
            bu.close();
            report.append("\n\n\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u0441\u0447\u0435\u0442\u0430 => ");
            report.append(TimeUtils.format((Calendar)new GregorianCalendar(), (String)"dd.MM.yyyy HH:mm:ss"));
            report.append("\n\u0421\u0435\u0441\u0441\u0438\u0439 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e => ");
            report.append(count);
            report.append("\n\u0418\u0437 \u043d\u0438\u0445 \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0445 => ");
            report.append(errorCnt);
            this.getLogger().info("VoiceIP recalculate result:");
            this.getLogger().info(report.toString());
            MailTaskSessionsRecalculator mailData = new MailTaskSessionsRecalculator();
            mailData.setModuleId(this.moduleId);
            mailData.setRecipients(this._email);
            mailData.setSubject("VoiceIP recalculate result");
            mailData.addTextPart("text", report.toString());
            new MailMsg((Preferences)this.setup).sendMessage((MailData)mailData);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)this.con, (Connection)this.conSlave);
        }
    }

    private int calcSession(Connection con, ResultSet rs, Set<Integer> cidsForRecalculate, ContractUtils cu, ContractManager contrM, StringBuffer report, int count, int errorCnt) throws SQLException {
        VoiceIpSession session = new VoiceIpSession();
        session.setLogRecordId(rs.getInt("id"));
        session.setFromNumber(rs.getString("from_number"));
        session.setToNumber(rs.getString("to_number"));
        session.setStartTime(TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp("session_start")));
        session.setSessionTime(rs.getInt("session_time"));
        session.setCallType(rs.getInt("type"));
        session.setServiceId(rs.getInt("sid"));
        session.setOperatorId(rs.getInt("oper_id"));
        session.setMid(this.moduleId);
        session.checkAndCreateTables(con, (DefaultServerSetup)Setup.getSetup());
        session.setItemZoneTrafficCache(this.itemZoneTrafficCache);
        session.setItemZoneCostCache(this.itemZoneCostCache);
        int lid = rs.getInt("lid");
        LoginItem loginItem = this._logins.get(lid);
        if (loginItem != null) {
            VoiceIpLogin login = loginItem.login;
            int cid = login.getContractId();
            Contract contract = contrM.getContractById(cid);
            if (contract != null) {
                int error;
                session.setLogin(login);
                session.setContract(contract);
                if (loginItem.tariff == null) {
                    loginItem.tariff = this.contractTreeSets.get(login.getContractId());
                }
                if (loginItem.tariff == null) {
                    loginItem.tariff = contrM.getRealtimeTariffTreeSet(contract.getId(), this._date1, "voiceip", this.moduleId, true);
                    this.contractTreeSets.put(login.getContractId(), loginItem.tariff);
                }
                contract.setTts(loginItem.tariff);
                if (!loginItem.zoneAmountsInit) {
                    this.initZoneAmounts(loginItem);
                }
                if ((error = session.calculate(con, null)) != 0) {
                    if (error == 1) {
                        report.append("\n\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0430\u0440\u0438\u0444\u044b\u0439 \u043f\u043b\u0430\u043d \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 ");
                        report.append(cu.getContractTitle(cid, true));
                        report.append("; ID => ");
                        report.append(rs.getInt("id"));
                    } else if (error == 2) {
                        report.append("\n\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0446\u0435\u043d\u0430 \u0432 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u043c \u043f\u043b\u0430\u043d\u0435 [");
                        report.append("] \u0414\u043e\u0433\u043e\u0432\u043e\u0440 => ");
                        report.append(cu.getContractTitle(cid, true));
                        report.append(session.toString());
                    }
                    ++errorCnt;
                } else {
                    this.sessionUpdater.updateSession(session);
                    this.itemZoneTrafficCache.addZoneTraffic(Integer.valueOf(login.getId()), Integer.valueOf(session.getZoneCode()), session.getRoundSessionTime(), session.getCallType());
                    this.itemZoneCostCache.addZoneCost(Integer.valueOf(login.getId()), Integer.valueOf(session.getZoneCode()), session.getFakeCost(), session.getCallType());
                    cidsForRecalculate.add(cid);
                }
            } else {
                report.append("\n\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c ");
                report.append(login.getContractId());
            }
        } else if (loginItem == null) {
            report.append("\n\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043b\u043e\u0433\u0438\u043d \u0441 \u043a\u043e\u0434\u043e\u043c ");
            report.append(lid);
            report.append(" ID: ");
            report.append(rs.getInt("id"));
            ++errorCnt;
        }
        return errorCnt;
    }

    private void initZoneAmounts(LoginItem item) {
        if (this._date1.get(5) != 1) {
            try {
                if (this.psSelectAmounts == null) {
                    String query = "SELECT zone, SUM(round_session_time), type, SUM(fake_cost) FROM " + this.logSessionTableName + " WHERE lid=? ";
                    query = query + " AND session_start>='" + TimeUtils.formatSQLDate((java.util.Date)this._date1.getTime()) + "' ";
                    query = query + " GROUP BY zone, type";
                    this.psSelectAmounts = this.con.prepareStatement(query);
                }
                this.psSelectAmounts.setInt(1, item.login.getId());
                ResultSet rs = this.psSelectAmounts.executeQuery();
                while (rs.next()) {
                    this.itemZoneTrafficCache.addZoneTraffic(Integer.valueOf(item.login.getId()), Integer.valueOf(rs.getInt(1)), rs.getInt(2), rs.getInt(3));
                    this.itemZoneCostCache.addZoneCost(Integer.valueOf(item.login.getId()), Integer.valueOf(rs.getInt(1)), rs.getBigDecimal(4), rs.getInt(3));
                }
                rs.close();
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    private static class LoginItem {
        public VoiceIpLogin login;
        public TariffTreeSet tariff;
        public boolean zoneAmountsInit = false;

        private LoginItem() {
        }
    }

    class OperatorSessionUpdater
    extends SessionUpdater {
        public OperatorSessionUpdater() throws SQLException {
            this.init();
        }

        @Override
        protected void init() throws SQLException {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append(SessionsRecalculator.this.logSessionTableName);
            query.append(" SET oper_session_cost=?, oper_round_session_time=? WHERE id=?");
            this._psUpdateSession = SessionsRecalculator.this.con.prepareStatement(query.toString());
        }

        @Override
        public void updateSession(VoiceIpSession session) throws SQLException {
            this._psUpdateSession.setBigDecimal(1, session.getOperSessionCost());
            this._psUpdateSession.setInt(2, session.getOperRoundSessionTime());
            this._psUpdateSession.setInt(3, session.getLogRecordId());
            this._psUpdateSession.executeUpdate();
        }
    }

    class SessionUpdater {
        protected PreparedStatement _psUpdateSession;

        public SessionUpdater() throws SQLException {
            this.init();
        }

        protected void init() throws SQLException {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append(SessionsRecalculator.this.logSessionTableName);
            query.append(" SET session_cost=?, oper_session_cost=?, fake_cost=? ,dest_code=?, min_cost=?, round_session_time=?, oper_round_session_time=?, zone=? WHERE id=?");
            this._psUpdateSession = SessionsRecalculator.this.con.prepareStatement(query.toString());
        }

        public void updateSession(VoiceIpSession session) throws SQLException {
            int index = 1;
            this._psUpdateSession.setBigDecimal(index++, session.getSessionCost());
            this._psUpdateSession.setBigDecimal(index++, session.getOperSessionCost());
            this._psUpdateSession.setBigDecimal(index++, session.getFakeCost());
            this._psUpdateSession.setInt(index++, session.getDestCode());
            this._psUpdateSession.setFloat(index++, session.getMinuteCost());
            this._psUpdateSession.setInt(index++, session.getRoundSessionTime());
            this._psUpdateSession.setInt(index++, session.getOperRoundSessionTime());
            this._psUpdateSession.setInt(index++, session.getZoneCode());
            this._psUpdateSession.setInt(index++, session.getLogRecordId());
            this._psUpdateSession.executeUpdate();
        }
    }
}

