/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.server.utils;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderBase;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;

public class LoaderTextParameterUpdateUtil
extends LoaderBase {
    @Override
    public String execute(String data, String config) throws BGException {
        JSONObject configJsonObject = new JSONObject(config);
        int parameterId = configJsonObject.optInt("parameterId", 0);
        String textFrom = configJsonObject.optString("textFrom");
        String textTo = configJsonObject.optString("textTo");
        String tableName = ContractParameterPrefType.TYPE_TEXT.getTableName();
        try {
            PreparedStatement psUpdate = this.con.prepareStatement("UPDATE " + tableName + " SET val=? WHERE pid=? AND cid=?");
            psUpdate.setInt(2, parameterId);
            int parameterIndex = 1;
            PreparedStatement psSelect = this.con.prepareStatement("SELECT * FROM " + tableName + " WHERE pid=?");
            psSelect.setInt(parameterIndex, parameterId);
            ResultSet resultSet = psSelect.executeQuery();
            while (resultSet.next()) {
                psUpdate.setString(1, resultSet.getString("val").replaceAll(textFrom, textTo));
                psUpdate.setInt(3, resultSet.getInt("cid"));
                psUpdate.executeUpdate();
            }
            resultSet.close();
            psSelect.close();
            psUpdate.close();
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException((Throwable)ex);
        }
        return null;
    }
}

