/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.vlan;

import bitel.billing.server.util.telnet.TelnetSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.modules.ipn.server.GateWorker;
import ru.bitel.bgbilling.modules.ipn.server.UserStatus;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateType;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleType;
import ru.bitel.bgbilling.modules.ipn.server.bean.VlanManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.command.GateCommandUtil;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class CiscoVlanGateWorker
extends GateWorker {
    @Override
    protected void doSync() {
        try {
            String host = this.gate.getHost();
            int port = this.gate.getPort();
            Preferences gateSetup = new Preferences(this.gate.getConfig(), "\r\n");
            String pswdLogin = this.gate.getKeyword();
            String pswdCfg = gateSetup.get("cfg.pswd", null);
            int timeout = gateSetup.getInt("timeout", 0);
            StringBuffer result = new StringBuffer();
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.gate.getId() + " gate: " + host + ":" + port + " pswdLogin: " + pswdLogin + " pswdCfg: " + pswdCfg);
            }
            TelnetSession session = new TelnetSession(host, port);
            session.setTimeout(timeout);
            session.setEndString(":");
            session.connect();
            session.setEndString(">");
            result.append(session.doCommand(pswdLogin));
            result.append(session.doCommand("terminal length 0"));
            result.append(session.doCommand("terminal width 0"));
            session.setEndString(":");
            result.append(session.doCommand("enable"));
            session.setEndString("#");
            result.append(session.doCommand(pswdCfg));
            result.append(session.doCommand("configure terminal"));
            this.log.debug("execute commands");
            this.doCommands(session, result);
            result.append(session.doCommand("exit"));
            session.doCommandAsync("exit");
            if (this.log.isDebugEnabled()) {
                this.log.debug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                this.log.debug((CharSequence)result);
                this.log.debug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
            this.log.debug("ok");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void doCommands(TelnetSession session, StringBuffer result) throws Exception {
        for (UserStatus status : this.statusList) {
            this.log.debug("status_cycle ");
            VlanManager manager = new VlanManager(this.mid, this.con);
            int gateId = this.gate.getId();
            int vid = manager.getVlan(gateId, status.contractId);
            this.log.debug("vid == " + vid);
            List<String> rules = null;
            rules = status.status == 0 ? this.getOpenRules(status, vid) : (status.status == 3 ? this.getRemoveRules(status, vid) : this.getCloseRules(status, vid));
            if (vid <= 0) continue;
            for (String rule : rules) {
                result.append(session.doCommand(rule));
            }
        }
    }

    private List<String> getOpenRules(UserStatus status, int vid) {
        return this.getRules(status, "\\[OPEN\\](.*)\\[/OPEN\\]", vid);
    }

    private List<String> getCloseRules(UserStatus status, int vid) {
        return this.getRules(status, "\\[CLOSE\\](.*)\\[/CLOSE\\]", vid);
    }

    private List<String> getRemoveRules(UserStatus status, int vid) {
        return this.getRules(status, "\\[REMOVE\\](.*)\\[/REMOVE\\]", vid);
    }

    private List<String> getRules(UserStatus status, String template, int vid) {
        Pattern pattern;
        Matcher m;
        String rule = this.getRuleText(status);
        if (status.ruleType != null) {
            rule = CiscoVlanGateWorker.generateRule(rule, this.gateType, status.ruleType, vid);
        }
        if ((m = (pattern = Pattern.compile(template, 32)).matcher(rule)).find()) {
            rule = m.group(1);
        }
        rule.replaceAll("\r", "");
        String[] parts = rule.split("\n");
        ArrayList<String> result = new ArrayList<String>();
        for (String part : parts) {
            if (Utils.isEmptyString((String)part)) continue;
            result.add(part);
        }
        return result;
    }

    protected String getRuleText(UserStatus status) {
        String rule = status.rule.getRuleText();
        return rule;
    }

    public static String generateRule(String addresses, GateType gateType, RuleType ruleType, int vid) {
        String ruleText = GateCommandUtil.getRule(gateType, ruleType);
        HashMap<String, String> replacements = new HashMap<String, String>();
        if (vid > 0) {
            replacements.put("\\{VID\\}", String.valueOf(vid));
        }
        return GateCommandUtil.generateRule(ruleText, addresses, replacements, ruleType);
    }
}

