/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.tv.access.om.OrderManagerSet;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ContainerContext;
import ru.bitel.bgbilling.kernel.container.managed.ManagedBeanInfo;
import ru.bitel.bgbilling.kernel.container.managed.ManagedBeanInfoManager;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.resource.ResourceManager;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDevice;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDeviceType;
import ru.bitel.bgbilling.modules.tv.common.om.OrderManager;
import ru.bitel.bgbilling.modules.tv.common.om.OrderManagerAdapter;
import ru.bitel.bgbilling.modules.tv.server.TvUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Child;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;
import ru.bitel.oss.systems.inventory.resource.common.dm.DeviceManager;

public class TvDeviceRuntime
implements Child<TvDeviceRuntime> {
    private static final Logger logger = LogManager.getLogger();
    final Semaphore semaphore = new Semaphore(1);
    public final Integer tvDeviceId;
    public final TvDevice tvDevice;
    public final TvDeviceType tvDeviceType;
    public final ParameterMap config;
    public OrderManagerSet saInstances;
    public DeviceManager deviceManager;
    public ManagedBeanInfo<Object> deviceManagerInfo;
    public final TvDeviceRuntime parent;
    public final Set<Integer> descendantIds;
    volatile Map<String, TvDeviceRuntime> descendantMap;
    private final boolean loadSaInstances;

    TvDeviceRuntime(Setup setup, int moduleId, TvDevice tvDevice, TvDeviceType tvDeviceType, TvDeviceRuntime parent, Set<Integer> descendantIds, ParameterMap config, ManagedBeanInfoManager<Object> beanInfoManager, boolean loadScript) throws BGException {
        this.tvDeviceId = tvDevice.getId();
        this.tvDevice = tvDevice;
        this.tvDeviceType = tvDeviceType;
        this.loadSaInstances = loadScript;
        this.parent = parent;
        this.descendantIds = descendantIds;
        this.config = config;
        this.reloadScripts(setup, moduleId, tvDevice, tvDeviceType, beanInfoManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadScripts(Setup setup, int moduleId, TvDevice tvDevice, TvDeviceType tvDeviceType, ManagedBeanInfoManager<Object> beanInfoManager) {
        DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
        if (this.loadSaInstances) {
            Object deviceManager = null;
            if (tvDeviceType != null) {
                try {
                    String deviceManagerClass = tvDeviceType.getDeviceManagerClass();
                    if (Utils.notBlankString((String)deviceManagerClass) && !deviceManagerClass.trim().equals("---")) {
                        deviceManager = (DeviceManager)dynamicClassManager.newInstance(DeviceManager.class, deviceManagerClass);
                        deviceManager.init(setup, moduleId, (Device)tvDevice, (DeviceType)tvDeviceType, this.config);
                    }
                }
                catch (Exception ex) {
                    deviceManager = null;
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            this.deviceManager = deviceManager;
            if (this.deviceManager != null) {
                this.deviceManagerInfo = beanInfoManager.getManagedBeanInfo(deviceManager.getClass());
            }
            logger.info("Reload OrderManager classes for device: " + tvDevice);
            ArrayList<OrderManagerSet.OrderManagerHolder> saInstanceList = new ArrayList<OrderManagerSet.OrderManagerHolder>();
            ServerContext ctx = new ServerContext(setup, moduleId, 0);
            ctx.init();
            try {
                ResourceManager rm = new ResourceManager();
                GregorianCalendar utilCalendar = new GregorianCalendar();
                TvDeviceRuntime deviceRuntime = this;
                while (deviceRuntime != null) {
                    try {
                        String saHandlerClass = deviceRuntime.tvDeviceType.getSaHandlerClass();
                        if (Utils.notBlankString((String)saHandlerClass) && !saHandlerClass.trim().equals("---")) {
                            OrderManager saInstance = (OrderManager)dynamicClassManager.newInstance(OrderManager.class, saHandlerClass);
                            rm.inject((ContainerContext)ctx, (Object)saInstance, moduleId);
                            saInstance.init(ctx, moduleId, deviceRuntime.tvDevice, deviceRuntime.tvDeviceType, deviceRuntime.config);
                            saInstanceList.add(new OrderManagerSet.OrderManagerHolder(deviceRuntime.tvDeviceId, saInstance, TvUtils.dateFrom(deviceRuntime.tvDevice.getDateFrom(), utilCalendar), TvUtils.dateTo(deviceRuntime.tvDevice.getDateTo(), utilCalendar), !deviceRuntime.tvDevice.isOrderManagerDisabled()));
                        }
                    }
                    catch (Throwable t) {
                        logger.error(t.getMessage(), t);
                    }
                    deviceRuntime = deviceRuntime.parent;
                }
                ctx.commit();
            }
            catch (Exception ex) {
                saInstanceList.clear();
                saInstanceList.add(new OrderManagerSet.OrderManagerHolder(0, (OrderManager)new OrderManagerAdapter(){

                    public Object connect(ServerContext ctx) {
                        return false;
                    }
                }, 0L, 0L, true));
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                ctx.destroy();
            }
            Collections.reverse(saInstanceList);
            this.saInstances = new OrderManagerSet(saInstanceList.toArray(new OrderManagerSet.OrderManagerHolder[saInstanceList.size()]));
        } else {
            this.saInstances = new OrderManagerSet(new OrderManagerSet.OrderManagerHolder[0]);
        }
    }

    public TvDeviceRuntime getParent() {
        return this.parent;
    }

    public void saInstancesDestroy() {
        this.saInstances.destroy();
        this.saInstances = null;
    }

    public TvDeviceRuntime getParent(Set<Integer> accountingRootDeviceIds) {
        if (accountingRootDeviceIds.contains(this.tvDeviceId)) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getParent(accountingRootDeviceIds);
        }
        return null;
    }
}

