<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="layout.xsl"/>

<xsl:template name="title">
<xsl:choose>
	<xsl:when test="data/@action = 'ShowLoginsBalance'">Наработка по логинам</xsl:when>
	<xsl:when test="data/@action = 'ShowSessions'">Просмотр сессий</xsl:when>
	<xsl:when test="data/@action = 'ChangeLoginPassword'">Смена пароля на логины</xsl:when>
	<xsl:when test="data/@action = 'DispatchSession'">Рассылка сессий</xsl:when>
	<xsl:when test="data/@action = 'DispatchAmount'">Рассылка наработки по логинам</xsl:when>
	<xsl:when test="data/@action = 'DispatchDirect'">Рассылка отчета по направлениям</xsl:when>
	<xsl:when test="data/@action = 'ShowPeriods'">Учетные периоды</xsl:when>
	<xsl:when test="data/@action = 'DynDnsChange'">Управление динамическим ДНС</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template match="/data">
<xsl:choose>
	<xsl:when test="@action = 'ShowLoginsBalance'">
		<xsl:call-template name="ShowLoginsBalance"/>
	</xsl:when>
	<xsl:when test="@action = 'ShowSessions'">
	 	<xsl:call-template name="ShowSessions"/>
	</xsl:when>
	<xsl:when test="@action = 'ChangeLoginPassword'">
	 	<xsl:call-template name="ChangeLoginPassword"/>
	</xsl:when>	
	<xsl:when test="@action = 'DispatchSession'">
	 	<xsl:call-template name="DispatchSession"/>
	</xsl:when>
	<xsl:when test="@action = 'DispatchAmount'">
	 	<xsl:call-template name="DispatchAmount"/>
	</xsl:when>
	<xsl:when test="@action = 'DispatchDirect'">
	 	<xsl:call-template name="DispatchDirect"/>
	</xsl:when>
	<xsl:when test="@action = 'ShowPeriods'">
	 	<xsl:call-template name="ShowPeriods"/>
	</xsl:when>
	<xsl:when test="@action = 'DynDnsChange'">
	 	<xsl:call-template name="DynDnsChange"/>
	</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template name="DynDnsChange">
	<form method="post" action="{$WEBEXECUTER}">
		<xsl:call-template name="action"/>
		<xsl:call-template name="error"	/>

		<xsl:if test="@status = 'ok'"><div class="alert alert-primary">Изменение сохранено!</div></xsl:if>
		<input type="hidden" name="save" value="save"/>
		<div class="report">
			<table cellspacing="1">
			<thead>
				<tr>
    				<td nowrap="1">логин:</td>
    				<td>состояние динамического ДНС</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="logins/item">
				<tr>
					<td><xsl:value-of select="@title"/></td>	
					<td>
						<select class="gradbtn ">
							<xsl:attribute name="name">dns_<xsl:value-of select="@id"/></xsl:attribute>
							<option value="0">
								<xsl:if test="@dns='0'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
              					Выключен
          					</option>
          					<option value="1">
          						<xsl:if test="@dns='1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
              					Цифровой логин
          					</option>
          					<option value="2">
          						<xsl:if test="@dns='2'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
              					Логин входа
          					</option>
						</select>
					</td>		
				</tr>
				</xsl:for-each>
				<tr>
					<td colspan="3">
						<xsl:call-template name="submit">
							<xsl:with-param name="title" select="'Сменить'"/>
							<xsl:with-param name="align" select="'right'"/>
						</xsl:call-template>
					</td>
				</tr>
			</tbody>
			</table>
			<br/>
			<div>История переключений</div>
			<br/>
			<table cellspacing="1" >
				<thead>
					<tr>
	    				<td nowrap="1">логин</td>
				    	<td>состояние динамического ДНС</td>
    					<td>дата</td>
    					<td>пользователь</td>
					</tr>
				</thead>
				<tbody>
					<xsl:for-each select="dnslogs/item">
						<tr>
							<td><xsl:value-of select="@login"/></td>	
							<td>
								<xsl:if test="@value=0">Выключен</xsl:if>
					          	<xsl:if test="@value=1">Цифровой логин</xsl:if>
					          	<xsl:if test="@value=2">Логин входа</xsl:if>
    	                  	</td>
							<td><xsl:value-of select="@date"/></td>
							<td><xsl:value-of select="@user"/></td>
						</tr>
					</xsl:for-each>
				</tbody>
			</table>
		</div>
	</form>
</xsl:template>


<!-- смена пароля на логины -->
<xsl:template name="ChangeLoginPassword">
	<form method='post' action='{$WEBEXECUTER}'>
		<xsl:call-template name="action"/>
		<xsl:call-template name="error"	/>

		<xsl:if test="@status = 'ok'"><div class="alert alert-primary">Пароль изменен!</div></xsl:if>

		<div class="report">
			<table cellspacing="1">
			<tbody>
				<tr>
    				<td nowrap="1">Логин:</td>
	    			<td>
     					<select class="gradbtn" name="login">
        					<xsl:call-template name="logins_list"/>
        				</select>
        			</td>
				</tr>  
    			<tr>
    				<td nowrap="1">Старый пароль:</td>
					<td><input type="password" name='old_pswd' maxlength='15'/></td>
				</tr>
    			<tr>
        			<td nowrap="1">Новый пароль:</td>
					<td><input type="password" name='pswd1' maxlength='15'/></td>
				</tr>
				<tr>
					<td nowrap="1">Повторите пароль:</td>
					<td><input type="password" name='pswd2' maxlength='15'/></td>
				</tr>
			</tbody>
			<tfoot>
				<tr>
					<td colspan='2'>
						<xsl:call-template name="submit"><xsl:with-param name="title" select="'Сменить'"/></xsl:call-template>
					</td>
				</tr>
			</tfoot>
			</table>
		</div>
	</form>
</xsl:template>


<!--
вынесено из лаяута и разделено на два темплаейта, в диалапе и в voicei использовалось
TODO убрать условия сравнения модулей, чтобы сократить в 2 раза
-->
<xsl:template name="sessionFilter">
	<xsl:param name="login_title"/>
	<xsl:variable name="module" select="/data/@module"/>
	<table class="filter">
		<tr>
			<td>
				<xsl:choose>
					<xsl:when test="$login_title"><xsl:value-of select="$login_title"/></xsl:when>
					<xsl:when test="$module!='voice'">Логин:</xsl:when>
					<xsl:when test="$module='voice'">Телефон:</xsl:when>
				</xsl:choose>
			</td>
			<td>
				<select class="gradbtn " name="login">
					<xsl:call-template name="logins_list"/>
				</select>
			</td>
			<xsl:if test="$module!='voiceip'">
			<td>Ед. измерения </td>
			<td>
				<select class="gradbtn " name='unit'>
					<xsl:call-template name="unit_list"/>
				</select>
			</td>
			</xsl:if>
			<td>Месяц:</td>
			<td>
				<select class="gradbtn " name='month'>
					<xsl:call-template name="month_list"/>
				</select>
			</td>
			<td>Год:</td>
			<td>
				<select class="gradbtn " name='year'>
					<xsl:call-template name="year_list"/>
				</select>
			</td>
			<td nowrap="nowrap">Числа месяца:</td>
			<td>c</td>
			<td><input type="text" name="day_from" size="4" value="{date/@day_from}"/></td>
			<td>по</td>
			<td><input type="text" name="day_to" size="4" value="{date/@day_to}"/></td>
			<xsl:if test="$module!='voiceip' and $module!='voice'">
			<td>
				<xsl:call-template name="submit">
					<xsl:with-param name="title" select="'Вывести'"/>
				</xsl:call-template>
			</td>
			</xsl:if>
		</tr>
	</table>
	
	<xsl:if test="$module='voiceip'">
		<table class="filter">
			<tr>
				<td>Тип звонка:</td>
				<td><input type="radio" name="direct" value="0" checked="1" ></input></td>
				<td>все</td>
				<td><input type="radio" name="direct" value="1">
					<xsl:if test="sessions/@direct='1'"><xsl:attribute name="checked">1</xsl:attribute></xsl:if></input></td>
				<td>исходящие</td>
				<td><input type="radio" name="direct" value="2" >
					<xsl:if test="sessions/@direct='2'"><xsl:attribute name="checked">1</xsl:attribute></xsl:if></input></td>
				<td>входящие</td>
				<td>
					<input type="checkbox" name="nofree">
					<xsl:if test="sessions/@nofree"><xsl:attribute name="checked">1</xsl:attribute></xsl:if></input>
				</td>
				<td>только платные</td>
				
				<td>
					<xsl:call-template name="submit">
						<xsl:with-param name="title" select="'Вывести'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>	
	</xsl:if>
</xsl:template>



<!-- сессии логина -->
<xsl:template name="ShowSessions">
		
	<form method="get" action='{$WEBEXECUTER}' name="sessions" id="sessionsForm">
		<input type="hidden" name="pageIndex" value="{sessions/@pageIndex}" />
		<input type="hidden" name="pageSize" value="{sessions/@pageSize}" />
		<xsl:variable name="module" select="/data/@module"/>
		<xsl:call-template name="action"/>
		<xsl:call-template name="sessionFilter"/>
	</form>
	
	<xsl:call-template name="AddReportReferences"/>

	<form method="post" action='{$WEBEXECUTER}'>	
		<table cellspacing="1" class="table800">
			<thead>
				<tr>
					<td>Логин</td>
					<td>Время входа</td>
					<td>Время выхода</td>
					<td>Длительность<br/> сеанса, мин.:сек.</td>
					<td>Сумма, руб.</td>
					<td>C номера/На номер</td>
					<xsl:for-each select="sessions/traffic_title"><td><xsl:value-of select="@title"/></td>
					</xsl:for-each>
					<td>&#x0A;</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="sessions/row">
				<tr>
					<td><xsl:value-of select="@login"/></td>	
					<td><xsl:value-of select="@f0"/></td>
					<td><xsl:value-of select="@f1"/></td>
					<td><xsl:value-of select="@f2"/></td>
					<td><xsl:value-of select="@f3"/></td>
					<td><xsl:value-of select="@f4"/></td>
					<xsl:for-each select="traffic"><td><xsl:value-of select="."/></td>
					</xsl:for-each>
					<td><input type="radio" name="session_id" value="{@id}" style="margin:0px; padding:0px;"/></td>
				</tr>
				</xsl:for-each>
			</tbody>
			<tfoot>
			   <tr>
					<td colspan="3">Итого сессий:&#160;<xsl:value-of select="sessions/@count_amount"/></td>	
					<td><xsl:value-of select="sessions/@time_amount"/></td>	
					<td><xsl:value-of select="sessions/@money_amount"/></td>
					<td>&#160;</td>
					<xsl:for-each select="sessions/traffic"><td><xsl:value-of select="."/></td>
					</xsl:for-each>
					<td>&#x0A;</td>
				</tr>
			</tfoot>               
		</table>
		
		<br/>		
	
		<xsl:call-template name="action"/>
		<input type="hidden" name="createDetail" id="createDetailId" value="1"/>
		<div style="display:none">			
			<xsl:call-template name="sessionFilter"/>
		</div>
		<input id="idPageIndex" value="{sessions/@pageIndex}" name="pageIndex" type="hidden"/>		
		<xsl:choose>
			<xsl:when test="not(sessions/row)"></xsl:when>
			<xsl:when test="createDetail/@created='1'">
				<table cellspacing="0" class="filter">
					<tr>
						<td>Отправка детализации поставлена в очередь.</td>
					</tr>
				</table>
			</xsl:when>
			<xsl:otherwise>	
				<table cellspacing="0" class="filter" >
				<tr>
					<td>
						Выслать детализацию для выбранной сессии на email:
						<input type="text" name="mail" size="30"></input>
					</td>
					<td>
						<xsl:call-template name="submit">
							<xsl:with-param name="title">Выслать</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>	
	</form>
</xsl:template>

<!-- наработка по логинам -->
<xsl:template name="ShowLoginsBalance">
	<form method='post' action='{$WEBEXECUTER}#idDivReport' name="sessions">
	<xsl:variable name="module" select="/data/@module"/>
	<xsl:call-template name="action"/>
	<input type="hidden" name="pageIndex" value="1"/>
	<table style="border-spacing: 15px; border-collapse: separate;">
		<tr>
			<td valign="middle"><div class="filter" style="float: none">Ед. измерения:<br/><select class="gradbtn" style="width: 100%;" name='unit'><xsl:call-template name="unit_list"/></select></div></td>
			<xsl:call-template name="periodFilter"/>
		</tr>
	</table>
	
	<div class="report" >
		<table cellspacing='1' class="table800">
		<thead>
			<tr>
				<td>Логин</td>
		        <td>Количество сессий</td>
		        <td>Время</td>
		        <td>Стоимость</td>
		        <xsl:for-each select="amounts/traffic_title"><td><xsl:value-of select="@title"/></td></xsl:for-each>
			</tr>
		</thead>
		<tbody>
			<xsl:for-each select="amounts/row">
			<tr>
				<td><xsl:value-of select="@f0"/></td>
				<td><xsl:value-of select="@f1"/></td>
				<td><xsl:value-of select="@f2"/></td>
				<td><xsl:value-of select="@f3"/></td>
				<xsl:choose>
					<xsl:when test="count(traffic) &gt; 0"><xsl:for-each select="traffic"><td><xsl:value-of select="."/></td></xsl:for-each></xsl:when>
					<xsl:otherwise><xsl:for-each select="../traffic"><td>0</td></xsl:for-each></xsl:otherwise>
				</xsl:choose>
			</tr>
			</xsl:for-each>
		</tbody>
		<tfoot>
			<tr>
				<td>Итого:</td>
				<td><xsl:value-of select="amounts/@count_amount"/></td>
				<td><xsl:value-of select="amounts/@time_amount"/></td>
				<td><xsl:value-of select="amounts/@money_amount"/></td>
				<xsl:if test="$module='dialup'"><xsl:for-each select="amounts/traffic"><td><xsl:value-of select="."/></td></xsl:for-each></xsl:if>
			</tr>
		</tfoot>
		</table>
	</div>
	</form>
</xsl:template>

<!-- свойства рассылки наработки по логинам -->
<xsl:template name="DispatchAmount">
<form action="{$WEBEXECUTER}" method="post">
	<xsl:call-template name="action"/>
	<input type="hidden" name="id"><xsl:attribute name="value"><xsl:value-of select="dispatch/@id"/></xsl:attribute></input>
	<input type="hidden" name="type"><xsl:attribute name="value"><xsl:value-of select="dispatch/@type"/></xsl:attribute></input>
	<input type="hidden" name="command" value="save"/>
			
	<div class="report">
		<table cellspacing='1' class="table800">
		<thead>
		  <tr>
		  	<td>Поле</td>
		  	<td>Данные</td>
		  	<td>Комментарий</td>
		  </tr>
		</thead>
		<tbody>
		  <tr>
			<td>Название:</td>
			<td>
				<input type="text" name="title" size="32">
					<xsl:attribute name="value"><xsl:value-of select="dispatch/@title"/></xsl:attribute>
				</input>
			</td>
			<td>
				<em class="comment">Название вашей рассылки, например 'Наработка
				по логинам DialUP '. Это название будет указано в теле письма.</em>
			</td>
		  </tr>
		  
		  <tr>	
			<td>Адреса:</td>
			<td>
				<textarea name="mails" rows="4" cols="25">
					<xsl:for-each select="dispatch/mail">
						<xsl:value-of select="@value"/>
						<xsl:if test="position() != last()">
							<xsl:value-of select="'	
							'"/>
						</xsl:if>
					</xsl:for-each>
				</textarea>
			</td>
			<td><em class="comment">
				Перечень адресов на которые будут приходить данная рассылка.
				Каждый адрес с новой строки.</em>
			</td>
  		  </tr>
  		  
  		  <tr>			
			<td>Статус:</td>
			<td>
				<select name="status">
					<option value="0">неактивна</option>
					<option value="1"><xsl:if test="dispatch/@status='1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>активна</option>
				</select>
			</td>
			<td><em class="comment">Рассылка приходит только если ее статус активен.</em></td>
		 </tr>
		 <tr>	
			<td nowrap="1">Дни недели ( 1-7 ):</td>
			<td>
				<input type="text" name="dw">
					<xsl:attribute name="value"><xsl:value-of select="dispatch/@dw"/></xsl:attribute>
				</input>
			</td>
			<td><em class="comment">
				Дни недели, например 1 - 7 ( каждый день ), 1, 2 ( понедельник, вторник )
				в которые вам будет высылаться рассылка.</em>
			</td>
		 </tr>
		</tbody>
		<tfoot>
		  <tr>
			<td colspan="3">	
			<xsl:call-template name="okCancel">
				<xsl:with-param name="title1" select="'Сохранить'"/>
				<xsl:with-param name="onclick2">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=Subscription&#38;mid=contract&#38;module=contract' );</xsl:with-param>
			</xsl:call-template>
			</td>
		  </tr>	
		</tfoot>
		</table>
	</div>			
</form>		
</xsl:template>


<!-- свойства рассылки сессий логина -->
<xsl:template name="DispatchSession">
<form action="{$WEBEXECUTER}" method="post">
<xsl:call-template name="action"/>
<input type="hidden" name="id"><xsl:attribute name="value"><xsl:value-of select="dispatch/@id"/></xsl:attribute></input>
<input type="hidden" name="type"><xsl:attribute name="value"><xsl:value-of select="dispatch/@type"/></xsl:attribute></input>
<input type="hidden" name="command" value="save"/>
		
		
<div class="report">
		<table cellspacing='1' class="table800">
		<thead>
		  <tr>
		  	<td>Поле</td>
		  	<td>Данные</td>
		  	<td>Комментарий</td>
		  </tr>
		 </thead>
		 <tbody>
		  <tr>
			<td>Название:</td>
			<td>
				<input type="text" name="title" size="32">
					<xsl:attribute name="value"><xsl:value-of select="dispatch/@title"/></xsl:attribute>
				</input>
			</td>
			<td><em class="comment">
				Название вашей рассылки, например 'Сессии логина test'.	
				Это название будет указано в теле письма.</em>
			</td>
		  </tr>
		  		  
		  <tr>
			<td>Логин:</td>
			<td>
				<select name="lid">
					<xsl:for-each select="/data/logins/item">
          				<option>
              				<xsl:if test="/data/dispatch/@lid=@id"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
              				<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
              				<xsl:value-of select="@title"/>
          				</option>
      				</xsl:for-each>	
				</select>
			</td>
			<td>
				<em class="comment">Логин, сессии которого будут высылаться.</em>
			</td>
		  </tr>
		  
		  <tr>	
			<td>Адреса:</td>
			<td>
				<textarea name="mails" rows="4" cols="25">
					<xsl:for-each select="dispatch/mail">
						<xsl:value-of select="@value"/>
						<xsl:if test="position() != last()">
							<xsl:value-of select="'	
							'"/>
						</xsl:if>
					</xsl:for-each>
				</textarea>
			</td>
			<td>			
				<em class="comment">Перечень адресов на которые будут приходить
				данная рассылка. Каждый адрес с новой строки.</em>
			</td>
  		  </tr>
  		  
  		  <tr>			
			<td>Статус:</td>
			<td>
				<select name="status">
					<option value="0">неактивна</option>
					<option value="1"><xsl:if test="dispatch/@status='1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>активна</option>
				</select>
			</td>
			<td><em class="comment">Рассылка приходит только если ее статус активен.</em></td>
		 </tr>
		 <tr>	
			<td nowrap="1">Дни недели ( 1-7 ):</td>
			<td>
				<input type="text" name="dw">
					<xsl:attribute name="value"><xsl:value-of select="dispatch/@dw"/></xsl:attribute>
				</input>
			</td>
			<td>
				<em class="comment">Дни недели, например 1 - 7 ( каждый день ),
				1, 2 ( понедельник, вторник ) в которые вам будет высылаться рассылка.</em>
			</td>
		 </tr>	
		</tbody>
		<tfoot>	  
		  <tr>
			<td colspan="3">
			<xsl:call-template name="okCancel">
				<xsl:with-param name="title1" select="'Сохранить'"/>
				<xsl:with-param name="onclick2">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=Subscription&#38;mid=contract&#38;module=contract' );</xsl:with-param>
			</xsl:call-template>
			</td>
		  </tr>
		</tfoot>		
		</table>
</div>		
</form>		
</xsl:template>

<!-- свойства рассылки отчета по направлениям -->
<xsl:template name="DispatchDirect">
<form action="{$WEBEXECUTER}" method="post">
<xsl:call-template name="action"/>
<input type="hidden" name="id"><xsl:attribute name="value"><xsl:value-of select="dispatch/@id"/></xsl:attribute></input>
<input type="hidden" name="type"><xsl:attribute name="value"><xsl:value-of select="dispatch/@type"/></xsl:attribute></input>
<input type="hidden" name="command" value="save"/>


<div class="report">
		<table cellspacing='1' class="table800">
		<thead>
		  <tr>
		  	<td>Поле</td>
		  	<td>Данные</td>
		  	<td>Комментарий</td>
		  </tr>
		 </thead>
		 <tbody>
		  <tr>
			<td>Название:</td>
			<td>
				<input type="text" name="title" size="32">
					<xsl:attribute name="value"><xsl:value-of select="dispatch/@title"/></xsl:attribute>
				</input>
			</td>
			<td>
				<em class="comment">Название вашей рассылки, например 'Отчет по
				направлениям звонков с телефона 11111'.	Это название будет
				указано в теле письма.</em>
			</td>
		  </tr>
		  		  
		  <tr>
			<td>
				<xsl:if test="/data/@module = 'voiceip'">Логин:</xsl:if>
				<xsl:if test="/data/@module = 'voice'">Телефон:</xsl:if>			
			</td>
			<td>
				<select name="lid">
					<xsl:for-each select="/data/logins/item">
          				<option>
              				<xsl:if test="/data/dispatch/@lid=@id"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
              				<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
              				<xsl:value-of select="@title"/>
          				</option>
      				</xsl:for-each>	
				</select>
			</td>
			<td>
				<em class="comment">Логин ( телефон ), сессии которого будут высылаться.</em>
			</td>
		  </tr>
		  
		  <tr>	
			<td>Адреса:</td>
			<td>
				<textarea name="mails" rows="4" cols="25">
					<xsl:for-each select="dispatch/mail">
						<xsl:value-of select="@value"/>
						<xsl:if test="position() != last()">
							<xsl:value-of select="'	
							'"/>
						</xsl:if>
					</xsl:for-each>
				</textarea>
			</td>
			<td>			
				<em class="comment">Перечень адресов на которые будут приходить
				данная рассылка. Каждый адрес с новой строки.</em>
			</td>
  		  </tr>
  		  
  		  <tr>			
			<td>Статус:</td>
			<td>
				<select name="status">
					<option value="0">неактивна</option>
					<option value="1"><xsl:if test="dispatch/@status='1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>активна</option>
				</select>
			</td>
			<td><em class="comment">Рассылка приходит только если ее статус активен.</em></td>
		 </tr>
		 <tr>	
			<td nowrap="1">Дни недели ( 1-7 ):</td>
			<td>
				<input type="text" name="dw">
					<xsl:attribute name="value"><xsl:value-of select="dispatch/@dw"/></xsl:attribute>
				</input>
			</td>
			<td><em class="comment">
				Дни недели, например 1 - 7 ( каждый день ), 1, 2 ( понедельник, вторник )
				в которые вам будет высылаться рассылка.</em>
			</td>
		 </tr>		  
		</tbody>
		<tfoot>
		  <tr>
			<td colspan="3">
			<xsl:call-template name="okCancel">
				<xsl:with-param name="title1" select="'Сохранить'"/>
				<xsl:with-param name="onclick2">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=Subscription&#38;mid=contract&#38;module=contract' );</xsl:with-param>
			</xsl:call-template>			
			</td>
		  </tr>
		</tfoot>		
		</table>
</div>			
</form>		
</xsl:template>


<!-- периоды логина -->
<xsl:template name="ShowPeriods" >
	<div class="report" >
		<table cellspacing='1' class="table800">
		<thead>
			<tr>
				<td>Начало</td>
				<td>Окончание</td>
			</tr>
		</thead>
		<tbody>
			<xsl:for-each select="periods/row">
			<tr>
				<td><xsl:value-of select="@start"/></td>	
				<td><xsl:value-of select="@end"/></td>
			</tr>
			</xsl:for-each>
		</tbody>
		</table>
	</div>
</xsl:template>


<xsl:template name="AddReportReferences">
	<div>
		Отчет в виде:
		<a title="CSV" href="{$WEBEXECUTER}?module=dialup&amp;mid={/data/@mid}&amp;action=ShowSessions&amp;login={/data/logins/@id}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;unit={/data/unit/@unit}&amp;file=1&amp;output=csv">CSV</a>,
		<a title="HTML" href="{$WEBEXECUTER}?module=dialup&amp;mid={/data/@mid}&amp;action=ShowSessions&amp;login={/data/logins/@id}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;unit={/data/unit/@unit}&amp;file=1&amp;output=html">HTML</a>,
		<a title="CSV/ZIP" href="{$WEBEXECUTER}?module=dialup&amp;mid={/data/@mid}&amp;action=ShowSessions&amp;login={/data/logins/@id}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;unit={/data/unit/@unit}&amp;file=1&amp;output=csv&amp;zip=1">CSV/ZIP</a>,
		<a title="HTML/ZIP" href="{$WEBEXECUTER}?module=dialup&amp;mid={/data/@mid}&amp;action=ShowSessions&amp;login={/data/logins/@id}&amp;month={/data/date/@month}&amp;year={/data/date/@year}&amp;day_from={/data/date/@day_from}&amp;day_to={/data/date/@day_to}&amp;unit={/data/unit/@unit}&amp;file=1&amp;output=html&amp;zip=1">HTML/ZIP</a> (После изменения фильтра сначала нажмите "Применить")
	</div>
</xsl:template>

</xsl:stylesheet>
