/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;

public class DealerDao
extends AbstractDao<Dealer> {
    public DealerDao(Connection con, int moduleId) {
        super(con, moduleId, "card_dealer");
    }

    public void update(Dealer dealer) throws BGException, SQLException {
        super.update((Object)dealer);
    }

    protected Dealer getFromRS(ResultSet rs) throws SQLException, BGException {
        Dealer result = new Dealer();
        result.setDate1(TimeUtils.convertDateToCalendar((Date)rs.getDate("date1")));
        result.setDate2(TimeUtils.convertDateToCalendar((Date)rs.getDate("date2")));
        result.setParams(rs.getInt("params"));
        result.setFindmodes(rs.getLong("findmodes"));
        result.setAllowcontracts(rs.getLong("allowcontracts"));
        result.setAllowcontractsMode(rs.getInt("allowcontracts_mode"));
        result.setId(rs.getInt("id"));
        result.setIp(rs.getString("ip"));
        result.setPt(rs.getString("pt"));
        result.setTitle(rs.getString("title"));
        result.setType(rs.getInt("type"));
        result.setContractId(rs.getInt("cid"));
        result.setCardPercent(rs.getFloat("card_percent"));
        result.setPayPercent(rs.getFloat("pay_percent"));
        result.setCardContract(rs.getString("card_contract"));
        result.setPayContract(rs.getString("pay_contract"));
        result.setCanselTime(rs.getInt("cansel_time"));
        result.setLogin(rs.getString("login"));
        result.setPassword(rs.getString("pswd"));
        result.setError(rs.getInt("error"));
        result.setComment(rs.getString("comment"));
        result.setStatRequest(rs.getInt("st_request"));
        result.setStatFinded(rs.getInt("st_finded"));
        result.setStatPayed(rs.getInt("st_payed"));
        result.setPayComissionType(rs.getInt("pay_comission_type"));
        result.setContractId(rs.getInt("contract_id"));
        return result;
    }

    protected void updateImpl(Dealer dealer) throws BGException, SQLException {
        if (dealer.getId() == -1) {
            String query = "INSERT INTO card_dealer_" + this.moduleId + " SET type=?, title=?, date1=?, date2=?, login=?, pswd=?, pt=?, comment=?, params=?, cansel_time=?, card_percent=?, pay_percent=?, card_contract=?, pay_contract=?, pay_comission_type=?, contract_id=?, findmodes=?, allowcontracts=?, allowcontracts_mode=?";
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            int index = 1;
            ps.setInt(index++, dealer.getType());
            ps.setString(index++, dealer.getTitle());
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)dealer.getDate1()));
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)dealer.getDate2()));
            ps.setString(index++, dealer.getLogin());
            ps.setString(index++, dealer.getPassword());
            ps.setString(index++, dealer.getPt());
            ps.setString(index++, dealer.getComment());
            ps.setInt(index++, dealer.getParams());
            ps.setInt(index++, dealer.getCanselTime());
            ps.setFloat(index++, dealer.getCardPercent());
            ps.setFloat(index++, dealer.getPayPercent());
            ps.setString(index++, dealer.getCardContract());
            ps.setString(index++, dealer.getPayContract());
            ps.setInt(index++, dealer.getPayComissionType());
            ps.setInt(index++, dealer.getContractId());
            ps.setLong(index++, dealer.getFindmodes());
            ps.setLong(index++, dealer.getAllowcontracts());
            ps.setInt(index++, dealer.getAllowcontractsMode());
            ps.executeUpdate();
            int id = ServerUtils.lastInsertId((PreparedStatement)ps);
            dealer.setId(id);
            ps.close();
        } else {
            int index = 1;
            StringBuilder queryBuf = new StringBuilder("UPDATE ").append(this.tableName);
            queryBuf.append(" SET type=?, title=?, date1=?, date2=?, login=?, ");
            if (dealer.getPassword() != null) {
                queryBuf.append(" pswd=?,");
            }
            queryBuf.append("pt=?, comment=?, ip=?, params=?, cansel_time=?, card_percent=?, pay_percent=?, card_contract=?, pay_contract=?, pay_comission_type=?, contract_id=?, findmodes=?, allowcontracts=?, allowcontracts_mode=?");
            if (dealer.getError() == -1) {
                queryBuf.append(", error=0");
            }
            if (dealer.getStatRequest() == -1) {
                queryBuf.append(", st_request=0, st_finded=0, st_payed=0");
            }
            queryBuf.append(" WHERE id=?");
            PreparedStatement ps = this.con.prepareStatement(queryBuf.toString());
            ps.setInt(index++, dealer.getType());
            ps.setString(index++, dealer.getTitle());
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)dealer.getDate1()));
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)dealer.getDate2()));
            ps.setString(index++, dealer.getLogin());
            if (dealer.getPassword() != null) {
                ps.setString(index++, dealer.getPassword().trim().length() > 0 ? dealer.getPassword() : null);
            }
            ps.setString(index++, dealer.getPt());
            ps.setString(index++, dealer.getComment());
            ps.setString(index++, dealer.getIp());
            ps.setInt(index++, dealer.getParams());
            ps.setInt(index++, dealer.getCanselTime());
            ps.setFloat(index++, dealer.getCardPercent());
            ps.setFloat(index++, dealer.getPayPercent());
            ps.setString(index++, dealer.getCardContract());
            ps.setString(index++, dealer.getPayContract());
            ps.setInt(index++, dealer.getPayComissionType());
            ps.setInt(index++, dealer.getContractId());
            ps.setLong(index++, dealer.getFindmodes());
            ps.setLong(index++, dealer.getAllowcontracts());
            ps.setInt(index++, dealer.getAllowcontractsMode());
            ps.setInt(index++, dealer.getId());
            ps.executeUpdate();
            ps.close();
        }
    }

    public List<Dealer> list(int type) throws BGException {
        return super.list("type&?>0", "title", new Object[]{type});
    }

    public Dealer get(int id) throws BGException {
        Dealer dealer = null;
        try {
            dealer = (Dealer)super.getImpl(id);
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return dealer;
    }
}

