/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.PaymentManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentDeletedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.RequestProcessException;
import ru.bitel.bgbilling.modules.mps.server.bean.BGMacrosFormat;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.FindContract;
import ru.bitel.bgbilling.modules.mps.server.bean.FindContractUtils;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.ProcessRegister;
import ru.bitel.bgbilling.modules.mps.server.events.MPSBeforeResponseEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public abstract class MPSTransactionManager
extends BGLogger {
    public static final String REQUEST_ATTRIBUTE_PATH_INFO = "ru.bitel.bgbilling.modules.mps.server.bean.MPSTransactionManager.PATH_INFO";
    public static final String REQUEST_ATTRIBUTE_PARAMETERS = "ru.bitel.bgbilling.modules.mps.server.bean.MPSTransactionManager.PARAMETERS";
    public static final int MPS_FROMGATEWAY = -1;
    public static final int MPS_CYBERPLAT = 1;
    public static final int MPS_OSMP = 2;
    public static final int ACTION_CHECK = 1;
    public static final int ACTION_PAY = 2;
    public static final int ACTION_STATUS = 3;
    public static final int ACTION_CANCEL = 4;
    public static final int ACTION_CHANGE = 5;
    public static final int ACTION_PAY_ON_CHECK = 10;
    public static final int ERROR_MPS_SERVER = -1;
    public static final int ERROR_MPS_REQUEST = 2;
    public static final int ERROR_MPS_CONTRACT_NOTFOUND = 3;
    public static final int ERROR_MPS_PAY_EXIST = 4;
    public static final int ERROR_MPS_PAY_NOTEXIST = 5;
    public static final int ERROR_MPS_DATE = 6;
    public static final int ERROR_MPS_SUM_TOOSMALLORBIG = 8;
    public static final int ERROR_MPS_ISOFF = 9;
    public static final int ERROR_MPS_HASH = 10;
    public static final int ERROR_MPS_EDIT_NOT_SUPPORTED = 11;
    public static final int ERROR_MPS_TYPE = 12;
    public static final int ERROR_MPS_NUMBER_PATTERN = 13;
    public static final int ERROR_MPS_TRANSACTION_ID_FIELD = 15;
    public static final int ERROR_MPS_DATE_FIELD = 16;
    public static final int ERROR_MPS_OUT_OF_MONEY = 20;
    public static final int ERROR_MPS_DATA = 21;
    public static final int ERROR_MPS_SUM_SMALL = 22;
    public static final int ERROR_MPS_SUM_BIG = 23;
    public static final String KEY_RESPONSE_PARAMETERS = "response_parameters";
    private static final String DEFAULT_ENCODING = "utf-8";
    protected static final Pattern pNumber = Pattern.compile("\\$NUMBER");
    protected static final Pattern p1 = Pattern.compile("\\$1");
    protected static final Pattern p2 = Pattern.compile("\\$2");
    protected static final Pattern p3 = Pattern.compile("\\$3");
    private String encoding = null;
    private static final EnumMap<Conf.Protocol, MPSTransactionManager> managerMap = new EnumMap(Conf.Protocol.class);
    private static final Object createTableMutex = new Object();
    private static Map<String, String> updatedTables = new ConcurrentHashMap<String, String>();
    private static final String TABLE_FIELDS = "id int(11) NOT NULL, mps_id varchar(10) NOT NULL, cid int(11) NOT NULL default '0', summ decimal(12,2) NOT NULL default '0.00' ,time timestamp NOT NULL default '0000-00-00 00:00:00', local_time timestamp NOT NULL default '0000-00-00 00:00:00', status int(11) NOT NULL default '0', trans_id varchar(64) NOT NULL DEFAULT '0', pid int(11) default NULL, type INT NOT NULL DEFAULT 0, rawNumber VARCHAR(20) NOT NULL DEFAULT '', ";
    protected final DocumentBuilder documentBuilder;
    private static final Pattern patternContract = Pattern.compile("\\$CONTRACT");
    private static final Pattern patternComment = Pattern.compile("\\$COMMENT");

    protected final bitel.billing.server.contract.bean.Contract findContract(Connection con, int moduleId, Conf.MPSSystem system, String number, int type) throws MPSException {
        bitel.billing.server.contract.bean.Contract result = null;
        if (system.multiSearch) {
            for (int i = 0; i < system.searchTypes.length && (result = bitel.billing.server.contract.bean.Contract.getContractFromNew((Contract)this.findContractImpl(con, moduleId, system, number, i))) == null; ++i) {
            }
        } else {
            result = bitel.billing.server.contract.bean.Contract.getContractFromNew((Contract)this.findContractImpl(con, moduleId, system, number, type));
        }
        return result;
    }

    private final Contract findContractImpl(Connection con, int moduleId, Conf.MPSSystem system, String number, int type) throws MPSException {
        Conf.SearchType mode;
        int result = 0;
        if (type < 0) {
            type = 0;
        }
        Conf.SearchType searchType = mode = type < system.searchTypes.length ? system.searchTypes[type] : Conf.SearchType.none;
        if (mode != null && mode != Conf.SearchType.none) {
            Pattern pattern = system.searchTypePattern[type];
            if (pattern != null) {
                Matcher m = pattern.matcher(number);
                if (m.find()) {
                    number = system.searchTypeReplace[type];
                    switch (m.groupCount()) {
                        case 3: {
                            number = p3.matcher(number).replaceAll(m.group(3));
                        }
                        case 2: {
                            number = p2.matcher(number).replaceAll(m.group(2));
                        }
                        case 1: {
                            number = p1.matcher(number).replaceAll(m.group(1));
                            break;
                        }
                        case 0: {
                            number = p1.matcher(number).replaceAll(m.group());
                        }
                    }
                }
            } else {
                String replace = system.searchTypeReplace[type];
                if (replace != null) {
                    number = pNumber.matcher(replace).replaceAll(number);
                }
            }
            try {
                switch (mode) {
                    case mps_login: {
                        result = FindContractUtils.findContractByMPSLogin(con, moduleId, number);
                        break;
                    }
                    case contract: {
                        result = FindContractUtils.findContractByTitle(con, number);
                        break;
                    }
                    case login: {
                        result = FindContractUtils.findContractByLogin(con, system.searchTypeMids[type], number);
                        break;
                    }
                    case phone: {
                        result = FindContractUtils.findContractByPhone(con, system.searchTypeMids[type], number);
                        break;
                    }
                    case voice: {
                        result = FindContractUtils.findContractByVoice(con, system.searchTypeMids[type], number);
                        break;
                    }
                    case email: {
                        result = FindContractUtils.findContractByEmail(con, number);
                        break;
                    }
                    case parameter: {
                        result = FindContractUtils.findContractByParameter(con, system.searchTypePids[type], number);
                        break;
                    }
                    case inet_login: {
                        result = FindContractUtils.findContractByInetLogin(con, system.searchTypeMids[type], number);
                        break;
                    }
                    case custom: {
                        Exception ex = null;
                        try {
                            result = DynamicClassManager.getInstance().loadClass(system.searchTypeCustom[type]).asSubclass(FindContract.class).getConstructor(new Class[0]).newInstance(new Object[0]).doSearch(con, number);
                        }
                        catch (Exception exDynamic) {
                            ex = exDynamic;
                        }
                        if (ex != null) {
                            try {
                                result = Class.forName(system.searchTypeCustom[type]).asSubclass(FindContract.class).getConstructor(new Class[0]).newInstance(new Object[0]).doSearch(con, number);
                            }
                            catch (Exception exStandart) {
                                ex = exStandart;
                            }
                        }
                        if (ex == null) break;
                        this.getLogger().error(ex.getMessage(), (Throwable)ex);
                        break;
                    }
                    case none: {
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new MPSException(3, e.getMessage());
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("result = " + result);
            }
            if (result > 0) {
                Contract contract = null;
                try (ContractDao contractDao = new ContractDao(con, 0);){
                    contract = (Contract)contractDao.get(result);
                }
                catch (BGException e) {
                    this.getLogger().error("error get contract id=" + result, (Throwable)e);
                    throw new MPSException(3, e.getMessage());
                }
                Pattern reg = system.allowContractPattern[type];
                long mask = system.allowContractGroups[type];
                boolean allowClosed = system.allowClosedPayment[type];
                if (!allowClosed && !TimeUtils.dateInRange((Date)new Date(), (Date)contract.getDateFrom(), (Date)contract.getDateTo())) {
                    return null;
                }
                if (!(reg != null && !reg.matcher(contract.getTitle()).matches() || mask >= 0L && (mask & contract.getGroups()) <= 0L)) {
                    return contract;
                }
            }
        }
        return null;
    }

    protected final String getContractTitle(HashMap<Integer, String> contractTitles, PreparedStatement getContractTitlePS, int contractId) {
        String result = contractTitles.get(contractId);
        if (result == null) {
            try {
                getContractTitlePS.setInt(1, contractId);
                ResultSet rs = getContractTitlePS.executeQuery();
                if (rs.next()) {
                    result = rs.getString(1);
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            if (result == null) {
                result = "\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d";
            }
            contractTitles.put(contractId, result);
        }
        return result;
    }

    private static MPSTransactionManager getMPSTransactionManager(Conf.Protocol protocol) {
        MPSTransactionManager mpsTransactionManager = managerMap.get((Object)protocol);
        if (mpsTransactionManager == null) {
            try {
                mpsTransactionManager = (MPSTransactionManager)((Object)protocol.getTransactionManagerClass().getConstructor(new Class[0]).newInstance(new Object[0]));
                managerMap.put(protocol, mpsTransactionManager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mpsTransactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] processRequest(HttpServletRequest request, HttpServletResponse response, Setup setup, Connection con, int moduleId, String mpsId, AtomicReference<Conf.MPSSystem> mpsSystem) throws RequestProcessException {
        MPSTransactionManager result;
        Conf.MPSSystem system;
        Conf conf;
        Logger logger;
        block22: {
            String userName;
            block24: {
                String userPswd;
                block23: {
                    boolean f4;
                    boolean f3;
                    block25: {
                        block21: {
                            logger = LoggerFactory.getLogger(MPSTransactionManager.class);
                            conf = (Conf)setup.getConfig(moduleId, Conf.class);
                            String _mpsId = (String)request.getSession().getAttribute("bitel.billing.server.mps.mpsId");
                            if (_mpsId == null) break block21;
                            mpsId = _mpsId;
                            if (!conf.mpsSystems.containsKey(mpsId)) {
                                throw new RequestProcessException("auth", "Payment system not found with [mpsId=" + _mpsId + "]");
                            }
                            system = conf.mpsSystems.get(mpsId);
                            result = MPSTransactionManager.getMPSTransactionManager(system.protocol);
                            result.setEncoding(system.responseEncoding);
                            break block22;
                        }
                        result = null;
                        system = null;
                        userName = (String)request.getAttribute("userName");
                        userPswd = (String)request.getAttribute("userPswd");
                        logger.debug("userName = {}; userPswd = {}; mpsId = {}", new Object[]{userName, userPswd, mpsId});
                        if (mpsId == null) break block23;
                        logger.debug("conf.mpsSystems.size() = {}", (Object)conf.mpsSystems.size());
                        if (!conf.mpsSystems.containsKey(mpsId)) break block24;
                        system = conf.mpsSystems.get(mpsId);
                        logger.debug("system = {}", (Object)system.toString());
                        if (!system.mode) {
                            throw new RequestProcessException("auth", "Payment system \"" + system.protocol + "\" is OFF!");
                        }
                        boolean f1 = system.protocol.isAuthBySign();
                        boolean f2 = system.extNoBaseAuth;
                        f3 = Utils.notBlankString((String)system.login) ? system.login.equals(userName) : false;
                        boolean bl = f4 = Utils.notBlankString((String)system.password) ? system.password.equals(userPswd) : false;
                        if (!f1 && !f2 && (!f3 || !f4)) break block25;
                        result = MPSTransactionManager.getMPSTransactionManager(system.protocol);
                        if (result != null) {
                            result.setEncoding(system.responseEncoding);
                        }
                        logger.debug("Select MPSTransactionManager = {}", (Object)result);
                        if (!system.protocol.isAuthBySign() || system.certificateNeed) break block24;
                        HttpSession session = request.getSession();
                        session.setAttribute("bitel.billing.server.mps.mpsId", (Object)mpsId);
                        break block24;
                    }
                    if (!logger.isDebugEnabled()) break block24;
                    logger.debug("ERROR for system.protocol.name() = {}; mpsId = {}", (Object)system.protocol.name(), (Object)mpsId);
                    logger.debug("system.protocol.isAuthBySign() = " + system.protocol.isAuthBySign());
                    logger.debug("system.extNoBaseAuth = " + system.extNoBaseAuth);
                    if (!system.extNoBaseAuth) {
                        logger.debug("system.login.equals( userName ) = " + f3 + "; system.login = `" + system.login + "` [length=" + (system.login != null ? system.login.length() : 0) + "]; userName = `" + userName + "` [length=" + (userName != null ? userName.length() : 0) + "]");
                        logger.debug("system.password.equals( userPswd ) = " + f4 + "; system.password = `" + system.password + "` [length=" + (system.password != null ? system.password.length() : 0) + "]; userPswd = `" + userPswd + "` [length=" + (userPswd != null ? userPswd.length() : 0) + "]");
                    }
                    break block24;
                }
                for (String key : conf.mpsSystems.keySet()) {
                    system = conf.mpsSystems.get(key);
                    if (system == null || system.login == null || system.password == null || !system.login.equals(userName) || !system.password.equals(userPswd)) continue;
                    result = MPSTransactionManager.getMPSTransactionManager(system.protocol);
                    break;
                }
            }
            if (result == null) {
                throw new RequestProcessException("auth", "Payment system not found with [login=" + userName + "]");
            }
            logger.debug("system.certificateNeed = {}", (Object)system.certificateNeed);
            if (system.certificateNeed) {
                logger.debug("request.isSecure() = {}", (Object)request.isSecure());
                if (!request.isSecure()) throw new RequestProcessException("auth", "\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e SSL-\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435");
                X509Certificate[] certs = (X509Certificate[])request.getAttribute("jakarta.servlet.request.X509Certificate");
                logger.debug("certs = {}", (Object)certs.toString());
                if (certs == null || certs.length <= 0) throw new RequestProcessException("auth", "\u0414\u043b\u044f \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0439 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442");
                logger.debug("certs.length = {}", (Object)certs.length);
                X509Certificate cert = certs[0];
                logger.debug("certs[0] = {}", (Object)cert.toString());
                try {
                    Date date = new Date();
                    if (logger.isDebugEnabled()) {
                        logger.debug("cert.getNotBefore() = {}", (Object)cert.getNotBefore());
                        logger.debug("cert.getNotAfter() = {}", (Object)cert.getNotAfter());
                        logger.debug("cert.checkValidity( {} )", (Object)date);
                    }
                    cert.checkValidity(date);
                }
                catch (CertificateExpiredException e) {
                    logger.debug(e.getMessage());
                    throw new RequestProcessException("auth", "\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0439 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d");
                }
                catch (CertificateNotYetValidException e) {
                    logger.debug(e.getMessage());
                    throw new RequestProcessException("auth", "\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0439 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0435\u0449\u0435 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0435\u043d");
                }
                boolean certOk = true;
                try {
                    certOk = system.publicKey.equals(cert.getPublicKey());
                }
                catch (Exception e) {
                    certOk = false;
                    StringBuilder str = new StringBuilder("MPSPaymentManager getInstance. \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f(\u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u044f) \u043e\u0442\u043a\u0440\u044b\u0442\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430 \u0443 \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430 \u0441\u043b\u0443\u0436\u0431\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447.");
                    str.append("\n\u041a\u043b\u044e\u0447 \u0438\u0437 \u043a\u043e\u043d\u0444\u0438\u0433\u0430 = ").append(system.publicKey != null ? (Object)system.publicKey.getEncoded() : "null");
                    str.append("\n\u041a\u043b\u044e\u0447 \u0438\u0437 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430(\u0437\u0430\u043f\u0440\u043e\u0441\u0430) = ").append(cert != null ? (Object)cert.getPublicKey().getEncoded() : "null");
                    logger.error(str.toString());
                    e.printStackTrace();
                }
                if (!certOk) {
                    throw new RequestProcessException("auth", "\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0439 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u043c");
                }
                request.getSession().setAttribute("bitel.billing.server.mps.mpsId", (Object)mpsId);
            }
        }
        mpsSystem.set(system);
        MPSTransactionManager mPSTransactionManager = result;
        synchronized (mPSTransactionManager) {
            byte[] resultByte = null;
            ServerContext context = null;
            ThreadContext parentContext = null;
            try {
                context = new ServerContext(setup, ConnectionSet.newInstance((DefaultServerSetup)setup, (Connection)con, (boolean)con.getAutoCommit()), moduleId, 0);
                parentContext = ServerContext.push((ThreadContext)context);
                resultByte = result.processRequest(con, moduleId, mpsId, conf, system, request, response);
                context.commit();
            }
            catch (Exception ex) {
                try {
                    logger.error("error while processException", (Throwable)ex);
                    throw new RequestProcessException("auth", ex.getMessage());
                }
                catch (Throwable throwable) {
                    ServerContext.pop(context, parentContext);
                    throw throwable;
                }
            }
            ServerContext.pop((ThreadContext)context, (ThreadContext)parentContext);
            return resultByte;
        }
    }

    public static MPSTransactionManager getInstance(String mpsId, Setup setup, int moduleId) {
        Conf conf = (Conf)setup.getConfig(moduleId, Conf.class);
        MPSTransactionManager mpsTransactionManager = null;
        if (mpsId == null || "0".equals(mpsId)) {
            mpsTransactionManager = MPSTransactionManager.getBaseTransactionManager();
        } else if (conf.mpsSystems.containsKey(mpsId)) {
            mpsTransactionManager = MPSTransactionManager.getMPSTransactionManager(conf.mpsSystems.get((Object)mpsId).protocol);
        }
        return mpsTransactionManager;
    }

    protected abstract byte[] processRequest(Connection var1, int var2, String var3, Conf var4, Conf.MPSSystem var5, HttpServletRequest var6, HttpServletResponse var7) throws Exception;

    protected abstract MPSRequest parseRequest(Connection var1, int var2, String var3, Conf.MPSSystem var4, HttpServletRequest var5) throws Exception;

    protected abstract void processError(MPSException var1, MPSResponse var2);

    protected void checkValid(Conf.MPSSystem system, MPSRequest mpsRequest, Connection con) throws MPSException {
        if (mpsRequest.getAction() <= 0) {
            throw new MPSException(2);
        }
        this.preProcess(system, mpsRequest, con);
    }

    protected void preProcess(Conf.MPSSystem system, MPSRequest mpsRequest, Connection con) throws MPSException {
        if (system.cid > 0 && mpsRequest.getAction() == 1 && system.accountServiceId > 0) {
            try (ContractDao contractDao = new ContractDao(con, 0);){
                Contract contract = (Contract)contractDao.get(system.cid);
                if (contract != null && contract.getBalanceMode() == 1 && system.protocol.isCanBlockPayment()) {
                    BalanceUtils balanceUtils = new BalanceUtils(con);
                    BigDecimal sum = balanceUtils.getBalance(LocalDate.now(), system.cid);
                    balanceUtils.close();
                    if (sum.subtract(contract.getBalanceLimit()).compareTo(mpsRequest.getSum()) < 0) {
                        throw new MPSException(20, "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432");
                    }
                }
            }
            catch (BGException e) {
                e.printStackTrace();
            }
        }
        if (system.extPayOnCheck && mpsRequest.getAction() == 1 && !system.protocol.isNeedPrepare()) {
            mpsRequest.setAction(10);
            if (mpsRequest.getTime() == null) {
                mpsRequest.setTime(new Date());
            }
        }
    }

    protected void onPayment(Conf.MPSSystem system, Payment payment) {
    }

    protected final void checkTime(MPSRequest mpsRequest) throws MPSException {
        int div;
        if (mpsRequest.getAction() == 2 && (div = mpsRequest.getSystem().payTime) > 0) {
            long now = new GregorianCalendar().getTimeInMillis() / 60000L;
            long time = mpsRequest.getTime().getTime() / 60000L + (long)mpsRequest.getSystem().timeOffset;
            if (Math.abs(time - now) > (long)div) {
                throw new MPSException(6, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f/\u0434\u0430\u0442\u0430. \u041f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043e\u043a \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0433\u043e");
            }
        }
    }

    protected BigInteger parseBigInteger(String value) {
        try {
            return new BigInteger(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getTable(Connection con, int moduleId, Date time) throws SQLException {
        String tableName = ServerUtils.getModuleMonthTableName((String)"mps_payment", (Date)time, (int)moduleId);
        if (!ServerUtils.tableExists((Connection)con, (String)tableName)) {
            Object object = createTableMutex;
            synchronized (object) {
                if (!ServerUtils.tableExists((Connection)con, (String)tableName)) {
                    String query = "CREATE TABLE " + tableName + " ( id int(11) NOT NULL, mps_id varchar(10) NOT NULL, cid int(11) NOT NULL default '0', summ decimal(12,2) NOT NULL default '0.00' ,time timestamp NOT NULL default '0000-00-00 00:00:00', local_time timestamp NOT NULL default '0000-00-00 00:00:00', status int(11) NOT NULL default '0', trans_id varchar(64) NOT NULL DEFAULT '0', pid int(11) default NULL, type INT NOT NULL DEFAULT 0, rawNumber VARCHAR(20) NOT NULL DEFAULT '', PRIMARY KEY (id),KEY `trans_id` (`trans_id`),KEY cid (cid), KEY time (time) )";
                    Statement st = con.createStatement();
                    st.execute(query);
                    st.close();
                    ServerUtils.checkAndCreatePeriodicTableName((Connection)con, (String)tableName, (String)query);
                }
                updatedTables.put(tableName, tableName);
            }
        }
        if (!updatedTables.containsKey(tableName)) {
            Object object = createTableMutex;
            synchronized (object) {
                String query = "ALTER TABLE " + tableName + " CHANGE trans_id trans_id VARCHAR(64) NOT NULL DEFAULT '0'";
                Statement st = con.createStatement();
                st.execute(query);
                st.close();
                updatedTables.put(tableName, tableName);
            }
        }
        return tableName;
    }

    protected final void createTemporaryTable(Connection con, String tableName) throws SQLException {
        Statement st = con.createStatement();
        st.executeUpdate("DROP TEMPORARY TABLE IF EXISTS `" + tableName + "`");
        st.close();
        String query = "CREATE TEMPORARY TABLE " + tableName + " ( tb varchar(25) NOT NULL DEFAULT '', id int(11) NOT NULL, mps_id varchar(10) NOT NULL, cid int(11) NOT NULL default '0', summ decimal(12,2) NOT NULL default '0.00' ,time timestamp NOT NULL default '0000-00-00 00:00:00', local_time timestamp NOT NULL default '0000-00-00 00:00:00', status int(11) NOT NULL default '0', trans_id varchar(64) NOT NULL DEFAULT '0', pid int(11) default NULL, type INT NOT NULL DEFAULT 0, rawNumber VARCHAR(20) NOT NULL DEFAULT '', PRIMARY KEY (tb, id), KEY `trans_id` (`trans_id`), KEY cid (cid),  KEY time (time) )";
        st = con.createStatement();
        st.execute(query);
        st.close();
    }

    public final Transaction addTransaction(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, int contractId, Date time, BigDecimal sum, String transId, String rawNumber, int type, String paymentComment) throws Exception {
        return this.addTransaction(-1, con, moduleId, mpsId, system, contractId, time, sum, transId, rawNumber, type, paymentComment);
    }

    public final Transaction addTransaction(int id, Connection con, int moduleId, String mpsId, Conf.MPSSystem system, int contractId, Date time, BigDecimal sum, String transId, String rawNumber, int type, String paymentComment) throws Exception {
        return this.addTransaction(id, con, moduleId, mpsId, system, contractId, time, null, sum, transId, rawNumber, type, paymentComment);
    }

    public Transaction addTransaction(int id, Connection con, int moduleId, String mpsId, Conf.MPSSystem system, int contractId, Date time, BigDecimal scriptSum, BigDecimal sum, String transId, String rawNumber, int type, String paymentComment) throws Exception {
        if (contractId <= 0 || system.paymentType <= 0) {
            if (system.paymentType <= 0) {
                this.getLogger().error("MPS: \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d mps.x.pid!");
                throw new MPSException(9);
            }
            return null;
        }
        Date now = new Date();
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contractId)).setTime(TimeUtils.clear_MILLISECOND((Date)time)).setLocalTime(TimeUtils.clear_MILLISECOND((Date)now)).setSum(sum)).setTransId(transId).setStatus(TransactionStatus.PAYMENT_PAYED.getCode())).build();
        Payment payment = new Payment();
        payment.setContractId(contractId);
        payment.setSum(system.storeOriginalSum ? scriptSum : sum);
        payment.setDate(system.extPaymentSystemTime ? time : now);
        payment.setComment(paymentComment + " " + transId + " : " + TimeUtils.format((Date)time, (String)"dd.MM.yyyy HH:mm:ss"));
        payment.setUserId(0);
        payment.setTypeId(system.paymentType);
        if (id <= 0) {
            try (PreparedStatement addPaymentIdPS = con.prepareStatement("UPDATE mps_payment_seq_" + moduleId + " SET id=LAST_INSERT_ID(id+1)", 1);){
                addPaymentIdPS.executeUpdate();
                id = ServerUtils.lastInsertId((PreparedStatement)addPaymentIdPS);
            }
            if (id < 0) {
                try (Statement st = con.createStatement();){
                    st.execute("INSERT INTO mps_payment_seq_" + moduleId + " SET id=1");
                }
                id = 1;
            }
        }
        String table = this.getTable(con, moduleId, time);
        String query = "INSERT INTO " + table + " SET id=?, mps_id=?, cid=?, pid=?, time=?, local_time=?, summ=?, trans_id=?, status=?, rawNumber=?, type=?";
        try (ContractDao contractDao = new ContractDao(con, 0);
             PreparedStatement addTransactionPS = con.prepareStatement(query);){
            new PaymentDao(con).update((Object)payment);
            transaction.setPaymentId(payment.getId());
            transaction.setId(id);
            addTransactionPS.setInt(1, id);
            addTransactionPS.setString(2, mpsId);
            addTransactionPS.setInt(3, contractId);
            addTransactionPS.setInt(4, transaction.getPaymentId());
            addTransactionPS.setTimestamp(5, TimeUtils.convertDateToTimestamp((Date)transaction.getTime()));
            addTransactionPS.setTimestamp(6, TimeUtils.convertDateToTimestamp((Date)transaction.getLocalTime()));
            addTransactionPS.setBigDecimal(7, sum);
            addTransactionPS.setString(8, transId);
            addTransactionPS.setString(9, TransactionStatus.PAYMENT_PAYED.getCode());
            addTransactionPS.setString(10, rawNumber);
            addTransactionPS.setInt(11, type);
            addTransactionPS.executeUpdate();
            this.systemAccountAdd(con, system, time, sum);
            Contract contract = (Contract)contractDao.get(payment.getContractId());
            try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                balanceUtils.updateBalance(payment.getDate(), contract);
            }
            EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contractId, 3, payment.getSum()));
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return transaction;
    }

    protected final Transaction prepareTransaction(Connection con, int moduleId, String mpsId, int contractId, Date time, BigDecimal sum, long transId, String rawNumber, int type) throws Exception {
        return this.prepareTransaction(con, moduleId, mpsId, contractId, time, sum, String.valueOf(transId), rawNumber, type);
    }

    protected final Transaction prepareTransaction(Connection con, int moduleId, String mpsId, int cid, Date time, BigDecimal sum, BigInteger transId, String rawNumber, int type) throws Exception {
        return this.prepareTransaction(con, moduleId, mpsId, cid, time, sum, String.valueOf(transId), rawNumber, type);
    }

    protected final Transaction prepareTransaction(Connection con, int moduleId, String mpsId, int cid, Date time, BigDecimal sum, String transId, String rawNumber, int type) throws Exception {
        if (cid <= 0) {
            return null;
        }
        Date now = new Date();
        Transaction result = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(cid)).setTime(time).setLocalTime(now).setSum(sum)).setTransId(transId).setStatus(TransactionStatus.PAYMENT_NOT_PAYED.getCode())).setPaymentId(0)).build();
        String table = this.getTable(con, moduleId, time);
        try {
            PreparedStatement addPaymentIdPS = con.prepareStatement("UPDATE mps_payment_seq_" + moduleId + " SET id=LAST_INSERT_ID(id+1)", 1);
            addPaymentIdPS.executeUpdate();
            int id = ServerUtils.lastInsertId((PreparedStatement)addPaymentIdPS);
            addPaymentIdPS.close();
            if (id < 0) {
                Statement st = con.createStatement();
                st.executeUpdate("INSERT INTO mps_payment_seq_" + moduleId + " SET id=1");
                st.close();
                id = 1;
            }
            result.setId(id);
            PreparedStatement addPaymentPS = con.prepareStatement("INSERT INTO " + table + " SET id=?, mps_id=?, cid=?, pid=?, time=?, local_time=?, summ=?, trans_id=?, status=?, rawNumber=?, type=?", 1);
            addPaymentPS.setInt(1, id);
            addPaymentPS.setString(2, mpsId);
            addPaymentPS.setInt(3, cid);
            addPaymentPS.setInt(4, result.getPaymentId());
            addPaymentPS.setTimestamp(5, TimeUtils.convertDateToTimestamp((Date)time));
            addPaymentPS.setTimestamp(6, TimeUtils.convertDateToTimestamp((Date)now));
            addPaymentPS.setBigDecimal(7, sum);
            addPaymentPS.setString(8, transId);
            addPaymentPS.setInt(9, Utils.parseInt((String)TransactionStatus.PAYMENT_NOT_PAYED.getCode()));
            addPaymentPS.setString(10, rawNumber);
            addPaymentPS.setInt(11, type);
            addPaymentPS.executeUpdate();
            addPaymentPS.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw ex;
        }
        return result;
    }

    protected final Transaction executePreparedTransaction(Connection con, int mid, Conf.MPSSystem system, Transaction result, String paymentComment) throws Exception {
        return this.executePreparedTransaction(con, mid, system, result, paymentComment, BigDecimal.ZERO);
    }

    protected final Transaction executePreparedTransaction(Connection con, int mid, Conf.MPSSystem system, Transaction result, String paymentComment, BigDecimal sum) throws BGException {
        return this.executePreparedTransaction(con, mid, system, result, paymentComment, null, sum);
    }

    protected final Transaction executePreparedTransaction(Connection con, int mid, Conf.MPSSystem system, Transaction result, String paymentComment, BigDecimal scriptSum, BigDecimal sum) throws BGException {
        if (result.getContractId() <= 0 || system.paymentType <= 0) {
            if (system.paymentType <= 0) {
                this.getLogger().error("MPS: \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d mps.x.pid!");
                throw new MPSException(9);
            }
            return null;
        }
        Date now = new Date();
        result.setLocalTime(now);
        result.setStatus(TransactionStatus.PAYMENT_PAYED.getCode());
        Payment payment = new Payment();
        payment.setContractId(result.getContractId());
        payment.setSum(system.storeOriginalSum ? scriptSum : (sum != null && sum.compareTo(BigDecimal.ZERO) > 0 ? sum : result.getSum()));
        payment.setDate(now);
        payment.setComment(paymentComment + " " + result.getTransId() + " : " + TimeUtils.format((Date)result.getTime(), (String)"dd.MM.yyyy HH:mm:ss"));
        payment.setUserId(0);
        payment.setTypeId(system.paymentType);
        try {
            PaymentDao paymentDao = new PaymentDao(con);
            paymentDao.update((Object)payment);
            result.setPaymentId(payment.getId());
            try {
                String table = this.getTable(con, mid, result.getTime());
                String query = sum != null && sum.compareTo(BigDecimal.ZERO) > 0 ? "UPDATE " + table + " SET summ=?, local_time=?, status=?, pid=? WHERE id=?" : "UPDATE " + table + " SET local_time=?, status=?, pid=? WHERE id=?";
                try (PreparedStatement ps = con.prepareStatement(query);){
                    int i = 1;
                    if (sum != null && sum.compareTo(BigDecimal.ZERO) > 0) {
                        ps.setBigDecimal(i++, sum);
                    }
                    ps.setTimestamp(i++, TimeUtils.convertDateToTimestamp((Date)now));
                    ps.setString(i++, TransactionStatus.PAYMENT_PAYED.getCode());
                    ps.setInt(i++, result.getPaymentId());
                    ps.setInt(i++, result.getId());
                    ps.executeUpdate();
                    this.systemAccountAdd(con, system, result.getTime(), sum);
                }
            }
            catch (Exception ex) {
                paymentDao.delete(payment.getId());
                throw new BGException((Throwable)ex);
            }
            ServerUtils.commitConnection((Connection)con);
            try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
            }
            ServerUtils.commitConnection((Connection)con);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
        EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(payment.getContractId(), 3, payment.getSum()));
        return result;
    }

    protected final void cancelPreparedTransaction(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, Transaction transaction) throws Exception {
        if (transaction != null && !transaction.getStatus().equals(TransactionStatus.PAYMENT_CANCELED.getCode())) {
            Date now = new Date();
            String table = ServerUtils.getModuleMonthTableName((String)"mps_payment", (Date)transaction.getTime(), (int)moduleId);
            try (PreparedStatement ps = con.prepareStatement("UPDATE " + table + " SET status=?, local_time=? WHERE trans_id=? AND mps_id=?");){
                ps.setString(1, TransactionStatus.PAYMENT_CANCELED.getCode());
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)now));
                ps.setString(3, transaction.getTransId());
                ps.setString(4, mpsId);
                ps.executeUpdate();
            }
            transaction.setStatus(TransactionStatus.PAYMENT_CANCELED.getCode());
            transaction.setLocalTime(now);
        }
    }

    public final Transaction getTransactionByTransId(Connection con, int moduleId, String mpsId, long transId, Date time) throws Exception {
        return this.getTransactionByTransId(con, moduleId, mpsId, String.valueOf(transId), time);
    }

    public final Transaction getTransactionByTransId(Connection con, int moduleId, String mpsId, BigInteger transId, Date time) throws Exception {
        return this.getTransactionByTransId(con, moduleId, mpsId, String.valueOf(transId), time);
    }

    public final Transaction getTransactionByTransId(Connection con, int moduleId, String mpsId, String transId, Date time) throws Exception {
        ResultSet rs;
        Transaction result = null;
        String table = ServerUtils.getModuleMonthTableName((String)"mps_payment", (Date)time, (int)moduleId);
        if (ServerUtils.tableExists((Connection)con, (String)table)) {
            PreparedStatement ps = con.prepareStatement("SELECT * FROM " + table + " WHERE trans_id=? AND mps_id=?");
            ps.setString(1, transId);
            ps.setString(2, mpsId);
            rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getTransactionFromRS(rs);
            }
            ps.close();
        }
        GregorianCalendar time1 = new GregorianCalendar();
        time1.setTime(time);
        if (result == null && time1.get(5) == 1) {
            Calendar time2 = (Calendar)((Calendar)time1).clone();
            time2.add(2, -1);
            table = ServerUtils.getModuleMonthTableName((String)"mps_payment", (Date)time2.getTime(), (int)moduleId);
            if (ServerUtils.tableExists((Connection)con, (String)table)) {
                PreparedStatement ps = con.prepareStatement("SELECT * FROM " + table + " WHERE trans_id=? AND mps_id=?");
                ps.setString(1, transId);
                ps.setString(2, mpsId);
                rs = ps.executeQuery();
                if (rs.next()) {
                    result = this.getTransactionFromRS(rs);
                }
                ps.close();
            }
        }
        return result;
    }

    public void cancelTransaction(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, Transaction transaction) throws Exception {
        if (transaction != null && transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
            PaymentManager paymentManager = new PaymentManager(con);
            Payment contractPayment = paymentManager.getPaymentById(transaction.getPaymentId());
            paymentManager.deletePayment(transaction.getPaymentId());
            Date now = new Date();
            String table = ServerUtils.getModuleMonthTableName((String)"mps_payment", (Date)transaction.getTime(), (int)moduleId);
            PreparedStatement ps = con.prepareStatement("UPDATE " + table + " SET status=?, local_time=? WHERE trans_id=? AND mps_id=?");
            ps.setInt(1, Utils.parseInt((String)TransactionStatus.PAYMENT_CANCELED.getCode()));
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)now));
            ps.setString(3, transaction.getTransId());
            ps.setString(4, mpsId);
            ps.executeUpdate();
            ps.close();
            transaction.setStatus(TransactionStatus.PAYMENT_CANCELED.getCode());
            transaction.setLocalTime(now);
            ContractDao contractDao = new ContractDao(con, 0);
            Contract contract = (Contract)contractDao.get(transaction.getContractId());
            contractDao.close();
            ServerUtils.commitConnection((Connection)con);
            BalanceUtils balanceUtils = new BalanceUtils(con);
            balanceUtils.updateBalance(transaction.getTime(), contract);
            balanceUtils.close();
            ServerUtils.commitConnection((Connection)con);
            EventProcessor.getInstance().publish((Event)new PaymentDeletedEvent(0, contractPayment));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contract.getId(), 3, contractPayment.getSum().negate()));
            this.systemAccountDelete(con, moduleId, system, transaction.getTime(), transaction.getSum());
        }
    }

    protected void clearCanceledTransaction(Connection con, int mid, int mpsId, Transaction transaction) throws Exception {
        if (transaction != null && transaction.getStatus().equals(TransactionStatus.PAYMENT_CANCELED.getCode())) {
            String table = ServerUtils.getModuleMonthTableName((String)"mps_payment", (Date)transaction.getTime(), (int)mid);
            PreparedStatement ps = con.prepareStatement("DELETE FROM " + table + " WHERE trans_id=? AND mps_id=?");
            ps.setString(1, transaction.getTransId());
            ps.setInt(2, mpsId);
            ps.executeUpdate();
            ps.close();
            transaction.setStatus(TransactionStatus.PAYMENT_NOT_PAYED.getCode());
            transaction.setLocalTime(new Date());
        }
    }

    public void searchTransactionList(SearchResult<Transaction> searchResult, String systemId, int contractId, String status, Connection con, int moduleId) {
        Statement st;
        Page page = searchResult.getPage();
        Period period = searchResult.getPeriod();
        List result = searchResult.getList();
        Object table = null;
        if (period == null || period.getDateFrom() == null || period.getDateTo() == null || !TimeUtils.checkMonthAndYearDates((Date)period.getDateFrom(), (Date)period.getDateTo())) {
            if (period == null) {
                period = new Period();
            }
            try {
                String tableName;
                Date dateFrom = null;
                if (period != null && period.getDateFrom() != null) {
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(period.getDateFrom());
                    calendar.set(5, 1);
                    dateFrom = calendar.getTime();
                }
                ArrayList<String> tables = new ArrayList<String>();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");
                st = con.createStatement();
                ResultSet rs = st.executeQuery("SHOW TABLES LIKE 'mps\\_payment\\_" + moduleId + "\\_______'");
                while (rs.next()) {
                    tableName = rs.getString(1);
                    Date tableDate = dateFormat.parse(tableName.substring(tableName.length() - 6));
                    if (!TimeUtils.dateInRange((Date)tableDate, (Date)dateFrom, (Date)period.getDateTo())) continue;
                    tables.add(tableName);
                }
                rs.close();
                st.close();
                if (!tables.isEmpty()) {
                    table = "mps_payment_" + moduleId;
                    Collections.sort(tables);
                    this.createTemporaryTable(con, (String)table);
                    tableName = null;
                    st = con.createStatement();
                    for (int index = 0; index < tables.size(); ++index) {
                        tableName = (String)tables.get(index);
                        st.executeUpdate("INSERT INTO `" + (String)table + "` SELECT '" + tableName + "', " + tableName + ".* FROM `" + tableName + "`");
                    }
                    st.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            table = ServerUtils.getModuleMonthTableName((String)"mps_payment", (Date)period.getDateFrom(), (int)moduleId);
            if (!ServerUtils.tableExists((Connection)con, (String)table)) {
                table = null;
            }
        }
        if (table != null) {
            StringBuilder where = new StringBuilder(100);
            where.append(" WHERE 1=1");
            if (systemId != null && !"0".equals(systemId)) {
                where.append(" AND mps_id='").append(systemId).append("'");
            }
            if (contractId > 0) {
                where.append(" AND cid=").append(contractId);
            }
            if (period.getDateFrom() != null) {
                where.append(" AND pay.time >= '").append(TimeUtils.formatSQLDate((Date)period.getDateFrom())).append("'");
            }
            if (period.getDateTo() != null) {
                where.append(" AND pay.time < '").append(TimeUtils.formatSQLDate((Date)TimeUtils.getNextDay((Date)period.getDateTo()))).append("'");
            }
            if (Utils.notBlankString((String)status)) {
                where.append(" AND pay.status='" + status + "'");
            }
            try {
                st = con.createStatement();
                StringBuilder query = new StringBuilder("SELECT COUNT(*), SUM(pay.summ) FROM ").append((String)table).append(" as pay").append((CharSequence)where);
                ResultSet rs = st.executeQuery(query.toString());
                page.setRecordCount(rs.next() ? rs.getInt(1) : 0);
                rs.close();
                rs = st.executeQuery(query.toString());
                if (rs.next()) {
                    page.setRecordCount(rs.getInt(1));
                    searchResult.setSum(rs.getBigDecimal(2));
                }
                rs.close();
                query = new StringBuilder("SELECT pay.*, contract.title as contract_title, contract.comment as contract_comment FROM ");
                query.append((String)table);
                query.append(" as pay LEFT JOIN contract ON pay.cid=contract.id ");
                query.append((CharSequence)where);
                query.append(page.sqlLimit());
                rs = st.executeQuery(query.toString());
                while (rs.next()) {
                    Transaction transaction = this.getTransactionFromRS(rs);
                    transaction.setContractTitle(rs.getString("contract_title"));
                    transaction.setContractComment(rs.getString("contract_comment"));
                    result.add(transaction);
                }
                rs.close();
                st.close();
                st = con.createStatement();
                st.executeUpdate("DROP TEMPORARY TABLE IF EXISTS `mps_payment_" + moduleId + "`");
                st.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public final List<Transaction> getTransactionListForDay(Connection con, int mid, String mpsId, Calendar date) throws Exception {
        LinkedList<Transaction> result = new LinkedList<Transaction>();
        PreparedStatement ps = con.prepareStatement("SELECT * FROM " + ServerUtils.getModuleMonthTableName((String)"mps_payment", (Date)date.getTime(), (int)mid) + " WHERE mps_id=? AND TO_DAYS(time)=TO_DAYS(?)");
        ps.setString(1, mpsId);
        ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(this.getTransactionFromRS(rs));
        }
        ps.close();
        return result;
    }

    public List<Transaction> getTransactionList(Connection con, int moduleId, int contractId, int yy, int mm) {
        Date from = new GregorianCalendar(yy, mm - 1, 1).getTime();
        LinkedList<Transaction> result = new LinkedList<Transaction>();
        String table = ServerUtils.getModuleMonthTableName((String)"mps_payment", (Date)from, (int)moduleId);
        if (ServerUtils.tableExists((Connection)con, (String)table)) {
            try {
                PreparedStatement ps = con.prepareStatement("SELECT pay.* FROM " + table + " as pay WHERE pay.cid=? AND pay.status>0 ORDER BY pay.id");
                ps.setInt(1, contractId);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result.add(this.getTransactionFromRS(rs));
                }
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List<Transaction> getTransactionList(Setup setup, Connection con, int moduleId, String mpsId, Calendar from, Calendar until, boolean onlyPayed) {
        Conf conf = (Conf)setup.getConfig(moduleId, Conf.class);
        return this.getTransactionList(con, moduleId, mpsId, conf, from, until, onlyPayed);
    }

    public List<Transaction> getTransactionList(Connection con, int mid, String mpsId, Conf conf, Calendar from, Calendar until, boolean onlyPayed) {
        LinkedList<Transaction> result = new LinkedList<Transaction>();
        String table = ServerUtils.getModuleMonthTableName((String)"mps_payment", (Date)from.getTime(), (int)mid);
        if (ServerUtils.tableExists((Connection)con, (String)table)) {
            try {
                PreparedStatement ps = con.prepareStatement("SELECT pay.* FROM " + table + " as pay WHERE mps_id=? AND TO_DAYS(time)>=TO_DAYS(?) AND TO_DAYS(time)<=TO_DAYS(?)" + (onlyPayed ? " AND status=1" : " AND status>0"));
                ps.setString(1, mpsId);
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)from));
                ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)until));
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result.add(this.getTransactionFromRS(rs));
                }
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List<Transaction> getTransactionList(Connection con, int moduleId, String mpsId, Calendar from, Calendar to, int paymentTypeId, String status) throws BGException {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        int fromMM = from.get(2) + 1;
        int fromYY = from.get(1);
        int toMM = to.get(2) + 1;
        int toYY = to.get(1);
        Calendar fromDate = (Calendar)from.clone();
        Calendar toDate = (Calendar)to.clone();
        ArrayList<Pair> pairList = new ArrayList<Pair>();
        if (fromYY == toYY) {
            for (i = fromMM; i <= toMM; ++i) {
                pairList.add(new Pair((Object)i, (Object)fromYY));
            }
        } else {
            for (i = fromYY; i <= toYY; ++i) {
                int j;
                if (i == fromYY) {
                    for (j = fromMM; j <= 12; ++j) {
                        pairList.add(new Pair((Object)j, (Object)i));
                    }
                    continue;
                }
                if (i == toYY) {
                    for (j = 1; j <= toMM; ++j) {
                        pairList.add(new Pair((Object)j, (Object)i));
                    }
                    continue;
                }
                for (j = 1; j <= 12; ++j) {
                    pairList.add(new Pair((Object)j, (Object)i));
                }
            }
        }
        for (Pair mmYYPair : pairList) {
            Calendar month = Calendar.getInstance();
            month.set(2, (Integer)mmYYPair.getFirst() - 1);
            month.set(1, (Integer)mmYYPair.getSecond());
            fromDate = TimeUtils.getStartMonth((Calendar)month);
            toDate = TimeUtils.getEndMonth((Calendar)month);
            fromDate = TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)from);
            toDate.set(11, 23);
            toDate.set(12, 59);
            toDate.set(13, 59);
            if ((Integer)mmYYPair.getFirst() == fromMM && (Integer)mmYYPair.getSecond() == fromYY) {
                fromDate = from;
            }
            if ((Integer)mmYYPair.getFirst() == toMM && (Integer)mmYYPair.getSecond() == toYY) {
                toDate = to;
            }
            try {
                String tableName = this.getTable(con, moduleId, month.getTime());
                if (!ServerUtils.tableExists((Connection)con, (String)tableName)) continue;
                String query = "SELECT p.* FROM " + tableName + " p";
                if (paymentTypeId > 0) {
                    query = query + " LEFT JOIN contract_payment cp ON cp.id=p.pid AND cp.pt=" + paymentTypeId;
                }
                query = query + " WHERE mps_id=? AND time>=? AND time<=?";
                if (Utils.notBlankString((String)status)) {
                    query = query + " AND status = ?";
                }
                PreparedStatement ps = con.prepareStatement(query);
                try {
                    int index = 1;
                    ps.setString(index++, mpsId);
                    ps.setTimestamp(index++, TimeUtils.convertCalendarToTimestamp((Calendar)fromDate));
                    ps.setTimestamp(index++, TimeUtils.convertCalendarToTimestamp((Calendar)toDate));
                    if (Utils.notBlankString((String)status)) {
                        ps.setString(index++, status);
                    }
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        result.add(this.getTransactionFromRS(rs));
                    }
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
            catch (SQLException e) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u043f\u0438\u0441\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public List<Transaction> getTransactionList(Connection con, int moduleId, int contractId, String mpsId, String status, Page page) throws BGException {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        try {
            String tableName;
            LocalDate date = LocalDate.now().withDayOfMonth(1);
            while (ServerUtils.tableExists((Connection)con, (String)(tableName = ServerUtils.getModuleMonthTableName((String)"mps_payment", (Date)TimeUtils.convertLocalDateToDate((LocalDate)date), (int)moduleId)))) {
                String query = "SELECT p.* FROM " + tableName + " p";
                query = query + " WHERE cid=?";
                if (Utils.notBlankString((String)mpsId)) {
                    query = query + " AND mps_id=?";
                }
                if (Utils.notBlankString((String)status)) {
                    query = query + " AND status=?";
                }
                try (PreparedStatement ps = con.prepareStatement(query);){
                    int index = 1;
                    ps.setInt(index++, contractId);
                    if (Utils.notBlankString((String)mpsId)) {
                        ps.setString(index++, mpsId);
                    }
                    if (Utils.notBlankString((String)status)) {
                        ps.setString(index++, status);
                    }
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        result.add(this.getTransactionFromRS(rs));
                        if (result.size() != page.getPageSize()) continue;
                        break;
                    }
                }
                date = date.minusMonths(1L);
            }
        }
        catch (SQLException e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u043f\u0438\u0441\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected final Transaction getTransactionFromRS(ResultSet rs) throws SQLException {
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setMpsId(rs.getString("mps_id")).setContractId(rs.getInt("cid"))).setPaymentId(rs.getInt("pid"))).setStatus(rs.getString("status"))).setSum(rs.getBigDecimal("summ"))).setTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("time"))).setLocalTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("local_time"))).setTransId(rs.getString("trans_id")).setRawNumber(rs.getString("rawNumber")).setType(rs.getInt("type")).build();
        return transaction;
    }

    protected bitel.billing.server.contract.bean.Contract actionCheck(MPSRequest request) throws MPSException {
        bitel.billing.server.contract.bean.Contract contract = this.findContract(request.getConnection(), request.getModuleId(), request.getSystem(), request.getNumber(), request.getType());
        if (contract == null) {
            throw new MPSException(3, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d [" + request.getNumber() + "]");
        }
        return contract;
    }

    public static ProcessRegister processRegister(String mpsId, String file, String fileName, Calendar from, Calendar until, Setup setup, Connection con, int moduleId) throws BGException {
        MPSTransactionManager mpsTransactionManager = MPSTransactionManager.getInstance(mpsId, setup, moduleId);
        Conf conf = (Conf)setup.getConfig(moduleId, Conf.class);
        return mpsTransactionManager.processRegister(mpsTransactionManager, con, moduleId, mpsId, conf, file, from, until);
    }

    protected final List<Transaction> getTransactionListFromFileByConfig(Conf.MPSSystem system, String fileString) {
        return this.getTransactionListFromFileByPattern(system.registerPattern, system.registerPatternOrder, system.registerTimeFormat, system.osmpPrefix, fileString);
    }

    protected final List<Transaction> getTransactionListFromFileByPattern(Pattern pattern, Map<String, Integer> patternOrder, String timeFormat, boolean osmpPrefix, String fileString) {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        Matcher match = pattern.matcher(fileString);
        int orderTransId = patternOrder.get("transId");
        int orderTime = patternOrder.get("time");
        int orderAccount = patternOrder.get("account");
        Integer orderType = patternOrder.get("type");
        int orderSum = patternOrder.get("sum");
        while (match.find()) {
            char type;
            String number = match.group(orderAccount);
            Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setTransId(Utils.parseLong((String)match.group(orderTransId), (long)0L)).setTime(TimeUtils.parseDate((String)match.group(orderTime), (String)timeFormat)).setRawNumber(number).setSum(Utils.parseBigDecimal((String)match.group(orderSum).replaceAll(",", "."), (BigDecimal)BigDecimal.ZERO))).setStatus(TransactionStatus.PAYMENT_PAYED.getCode())).build();
            if (osmpPrefix && number != null && number.length() > 1 && number.charAt(1) == '_' && Character.isDigit((int)(type = number.charAt(0)))) {
                transaction.setType(Character.getNumericValue((int)type));
                transaction.setNumber(number.substring(2));
            } else {
                if (orderType != null && orderType > 0) {
                    transaction.setType(Utils.parseInt((String)match.group(orderType)));
                }
                transaction.setNumber(number);
            }
            result.add(transaction);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    protected ProcessRegister processRegister(MPSTransactionManager paymentManager, Connection con, int moduleId, String mpsId, Conf conf, String fileString, Calendar from, Calendar until) throws BGException {
        processRegister = new ProcessRegister();
        system = conf.mpsSystems.get(mpsId);
        dbTransactionList = this.getTransactionList(con, moduleId, mpsId, conf, from, until, false);
        exTransactionList = system.registerPattern != null && system.registerPatternOrder != null && system.registerPatternOrder.size() > 0 ? this.getTransactionListFromFileByConfig(system, fileString) : this.getTransactionListFromFile(system, fileString);
        if (exTransactionList == null) {
            throw new BGException("error: \u0421\u0432\u0435\u0440\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        }
        checkAccount = system.registerCheckAccount;
        for (Transaction exPayment : exTransactionList) {
            number = exPayment.getRawNumber();
            if (!system.osmpPrefix || number == null || number.length() <= 1 || number.charAt(1) != '_') ** GOTO lbl-1000
            v0 = number.charAt(0);
            type = v0;
            if (Character.isDigit((int)v0)) {
                type = Character.getNumericValue(type);
                number = number.substring(2);
            } else lbl-1000:
            // 2 sources

            {
                type = exPayment.getType();
            }
            if (!checkAccount || (contract = paymentManager.findContract(con, moduleId, system, number, type)) == null) continue;
            exPayment.setContractId(contract.getId());
        }
        for (Transaction dbTransaction : dbTransactionList) {
            find = false;
            for (i = 0; i < exTransactionList.size(); ++i) {
                regTransaction = exTransactionList.get(i);
                if (!regTransaction.getTransId().equals(dbTransaction.getTransId())) continue;
                if (regTransaction.getSum().compareTo(dbTransaction.getSum()) != 0 || checkAccount && regTransaction.getContractId() != dbTransaction.getContractId()) {
                    processRegister.getList3().add(regTransaction);
                    processRegister.getList3().add(dbTransaction);
                    exTransactionList.remove(i);
                    find = true;
                    break;
                }
                if (!dbTransaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                    processRegister.getList2().add(dbTransaction);
                    exTransactionList.remove(i);
                    find = true;
                    break;
                }
                exTransactionList.remove(i);
                find = true;
                break;
            }
            if (find || !dbTransaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) continue;
            processRegister.getList1().add(dbTransaction);
        }
        for (Transaction payment : exTransactionList) {
            contract = this.findContract(con, moduleId, system, payment.getNumber(), payment.getType());
            if (contract != null) {
                payment.setContractId(contract.getId());
                payment.setContractTitle(contract.getTitle());
                continue;
            }
            payment.setContractId(-1);
            payment.setContractTitle("\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        contractTitles = new HashMap<Integer, String>(512);
        getContractTitlePS = null;
        try {
            getContractTitlePS = con.prepareStatement("SELECT title FROM contract WHERE id=?");
            for (Transaction transaction : processRegister.getList1()) {
                transaction.setContractTitle(this.getContractTitle(contractTitles, getContractTitlePS, transaction.getContractId()));
            }
            for (Transaction transaction : processRegister.getList2()) {
                transaction.setContractTitle(this.getContractTitle(contractTitles, getContractTitlePS, transaction.getContractId()));
            }
            getContractTitlePS.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        processRegister.setList0(exTransactionList);
        return processRegister;
    }

    public void reviseCancelTransactions(Connection con, int moduleId, String mpsId, Document payments) throws BGException {
        try (BalanceUtils bu = new BalanceUtils(con);
             ContractDao contractDao = new ContractDao(con, 0);){
            HashMap<Date, PreparedStatement> selectPSs = new HashMap<Date, PreparedStatement>();
            HashMap<Date, PreparedStatement> updatePSs = new HashMap<Date, PreparedStatement>();
            PaymentManager man = new PaymentManager(con);
            NodeList nodeList = payments.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                PreparedStatement updatePS;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element payment = (Element)node;
                Date time = TimeUtils.convertStringToDate((String)payment.getAttribute("time"), (String)"dd.MM.yyyy HH:mm:ss");
                String transId = payment.getAttribute("trans_id");
                PreparedStatement selectPS = (PreparedStatement)selectPSs.get(time);
                if (selectPS == null) {
                    selectPS = con.prepareStatement("SELECT pid FROM " + ServerUtils.getModuleMonthTableName((String)"mps_payment", (Date)time, (int)moduleId) + " WHERE mps_id=? AND trans_id=?");
                    selectPSs.put(time, selectPS);
                }
                if ((updatePS = (PreparedStatement)updatePSs.get(time)) == null) {
                    updatePS = con.prepareStatement("UPDATE " + ServerUtils.getModuleMonthTableName((String)"mps_payment", (Date)time, (int)moduleId) + " SET status=2 WHERE mps_id=? AND trans_id=?");
                    updatePSs.put(time, updatePS);
                }
                selectPS.setString(1, mpsId);
                selectPS.setString(2, transId);
                updatePS.setString(1, mpsId);
                updatePS.setString(2, transId);
                int pid = 0;
                ResultSet rs = selectPS.executeQuery();
                if (rs.next()) {
                    pid = rs.getInt("pid");
                }
                Payment pay = man.getPaymentById(pid);
                man.deletePayment(pid);
                updatePS.executeUpdate();
                if (pay == null) continue;
                Contract contract = (Contract)contractDao.get(pay.getContractId());
                con.commit();
                bu.updateBalance(pay.getDate(), contract);
                con.commit();
                EventProcessor.getInstance().publish((Event)new PaymentDeletedEvent(0, pay));
                EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contract.getId(), 3, pay.getSum().negate()));
            }
            updatePSs.clear();
            selectPSs.clear();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void reviseAddTransactions(Connection con, int mid, String mpsId, Setup setup, Document payments) {
        Conf conf = (Conf)setup.getConfig(mid, Conf.class);
        NodeList nodeList = payments.getDocumentElement().getChildNodes();
        BigDecimal error = new BigDecimal(-1);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element payment = (Element)node;
            String transId = payment.getAttribute("trans_id");
            int contractId = Utils.parseInt((String)payment.getAttribute("cid"), (int)-1);
            BigDecimal sum = Utils.parseBigDecimal((String)payment.getAttribute("summ"), (BigDecimal)error);
            Date time = TimeUtils.convertStringToDate((String)payment.getAttribute("time"), (String)"dd.MM.yyyy HH:mm:ss");
            String rawNumber = payment.getAttribute("rawNumber");
            int type = Utils.parseInt((String)payment.getAttribute("type"), (int)0);
            try {
                this.addTransaction(con, mid, mpsId, conf.mpsSystems.get(mpsId), contractId, time, sum, transId, rawNumber, type, "");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void reviseRestoreTransactions(Connection con, int mid, String mpsId, Setup setup, Document payments) throws BGException {
        try {
            Conf conf = (Conf)setup.getConfig(mid, Conf.class);
            Conf.MPSSystem system = conf.mpsSystems.get(mpsId);
            HashMap<Date, PreparedStatement> updatePSs = new HashMap<Date, PreparedStatement>();
            PaymentDao paymentDao = new PaymentDao(con);
            Date now = new Date();
            NodeList nodeList = payments.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Payment payment;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element paymentEl = (Element)node;
                long transId = Utils.parseLong((String)paymentEl.getAttribute("trans_id"), (long)-1L);
                int cid = Utils.parseInt((String)paymentEl.getAttribute("cid"), (int)-1);
                int pid = Utils.parseInt((String)paymentEl.getAttribute("pid"), (int)-1);
                BigDecimal sum = Utils.parseBigDecimal((String)paymentEl.getAttribute("summ"), (BigDecimal)BigDecimal.ZERO);
                Date time = TimeUtils.parseDate((String)paymentEl.getAttribute("time"), (String)"dd.MM.yyyy HH:mm:ss");
                PreparedStatement updatePS = (PreparedStatement)updatePSs.get(time);
                if (updatePS == null) {
                    updatePS = con.prepareStatement("UPDATE " + ServerUtils.getModuleMonthTableName((String)"mps_payment", (Date)time, (int)mid) + " SET status=1, time=?, local_time=?, pid=? WHERE mps_id=? AND trans_id=?");
                    updatePSs.put(time, updatePS);
                }
                if ((payment = (Payment)paymentDao.get(pid)) == null) {
                    payment = Payment.builder().setContractId(cid).setSum(sum).setDate(now).setComment(system.title + ". \u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0438\u0437 \u0440\u0435\u0435\u0441\u0442\u0440\u0430").setUserId(0).setTypeId(system.paymentType).build();
                    paymentDao.update((Object)payment);
                    ContractDao contractDao = new ContractDao(con, 0);
                    Contract contract = (Contract)contractDao.get(cid);
                    contractDao.close();
                    con.commit();
                    BalanceUtils balanceUtils = new BalanceUtils(con);
                    balanceUtils.updateBalance(payment.getDate(), contract);
                    balanceUtils.close();
                    con.commit();
                    EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contract.getId(), 3, payment.getSum()));
                }
                updatePS.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)time));
                updatePS.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)now));
                updatePS.setInt(3, payment.getId());
                updatePS.setString(4, mpsId);
                updatePS.setLong(5, transId);
                updatePS.executeUpdate();
            }
            updatePSs.clear();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    protected abstract List<Transaction> getTransactionListFromFile(Conf.MPSSystem var1, String var2);

    public int getUserLogin(Connection con, int mid, int cid) {
        int result = 0;
        try {
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT id FROM mps_login_" + mid + " WHERE cid=" + cid);
            while (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getUserLoginFormatted(Setup setup, Connection con, int mid, int cid) {
        Conf conf = (Conf)setup.getConfig(mid, Conf.class);
        int result = this.getUserLogin(con, mid, cid);
        if (result != 0) {
            String format = conf.mpsLoginFormat;
            if (format != null) {
                return new DecimalFormat(format).format(result);
            }
            return String.valueOf(result);
        }
        return null;
    }

    public void setUserLogin(Setup setup, Connection con, int moduleId, int contractId, String _login) throws BGException {
        Pattern pat;
        Conf conf = (Conf)setup.getConfig(moduleId, Conf.class);
        int login = 0;
        try {
            login = Integer.parseInt(_login);
        }
        catch (NumberFormatException e) {
            throw new BGException("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0446\u0435\u043b\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f \u0438 \u043c\u0435\u043d\u044c\u0448\u0435 2147483647");
        }
        String format = conf.mpsLoginFormat;
        if (format != null) {
            _login = new DecimalFormat(format).format(login);
        }
        if ((pat = conf.mpsLoginPattern) != null && !pat.matcher(_login).find()) {
            throw new BGException(conf.mpsLoginFormatErrorMessage);
        }
        if (login <= 0) {
            throw new BGException("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f");
        }
        String table = "mps_login_" + moduleId;
        try {
            String message = null;
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT cid FROM " + table + " WHERE id=" + login);
            boolean rsnext = rs.next();
            if (rsnext && rs.getInt("cid") != contractId) {
                message = "\u0422\u0430\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440 \u0443\u0436\u0435 \u0435\u0441\u0442\u044c";
            }
            rs.close();
            if (!rsnext) {
                st.executeUpdate("DELETE FROM " + table + " WHERE cid=" + contractId);
                st.executeUpdate("INSERT INTO " + table + " (cid, id) VALUES (" + contractId + ", " + login + ")");
            }
            st.close();
            if (message != null) {
                throw new BGException(message);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding != null ? this.encoding : this.getDefaultEncoding();
    }

    public String getDefaultEncoding() {
        return DEFAULT_ENCODING;
    }

    protected abstract byte[] getResponse(Connection var1, Conf.MPSSystem var2, MPSResponse var3) throws Exception;

    protected void processResponseEvent(MPSResponse response, Element responseElement) {
        try {
            EventProcessor.getInstance().request((QueueEvent)new MPSBeforeResponseEvent((MPSRequest)response.getParameters().remove("request"), response, responseElement));
        }
        catch (BGException ex) {
            this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0441\u043a\u0440\u0438\u043f\u0442\u0430 \u0441\u043e\u0431\u044b\u0442\u0438\u044f", (Throwable)ex);
            ex.printStackTrace();
        }
    }

    protected MPSTransactionManager() {
        DocumentBuilder db;
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setNamespaceAware(true);
        try {
            db = dFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            db = null;
            e.printStackTrace();
        }
        this.documentBuilder = db;
    }

    protected final String getComment(Conf.MPSSystem system, Conf conf, Connection con, bitel.billing.server.contract.bean.Contract contract) {
        String comment = patternComment.matcher(patternContract.matcher(system.comment).replaceAll(contract.getTitle())).replaceAll(contract.getComment());
        try {
            return new BGMacrosFormat(con, contract).format(comment, new Object[0]);
        }
        catch (Exception e) {
            return "";
        }
    }

    protected void systemAccountAdd(Connection con, Conf.MPSSystem system, Date time, BigDecimal sum) throws BGException {
        if (system.accountServiceId > 0 && system.cid > 0) {
            try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                balanceUtils.addContractAccount(system.cid, TimeUtils.convertDateToLocalDate((Date)time), system.accountServiceId, sum);
                balanceUtils.updateBalance(time, system.cid);
            }
        }
    }

    protected void systemAccountDelete(Connection con, int mid, Conf.MPSSystem system, Date time, BigDecimal sum) throws BGException {
        if (system.accountServiceId > 0 && system.cid > 0) {
            String query = "UPDATE contract_account SET summa=summa-? WHERE  cid=? AND sid=? AND yy=? AND mm=?";
            try (PreparedStatement ps = con.prepareStatement(query);){
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(time);
                ps.setBigDecimal(1, sum);
                ps.setInt(2, system.cid);
                ps.setInt(3, system.accountServiceId);
                ps.setInt(4, cal.get(1));
                ps.setInt(5, cal.get(2) + 1);
                if (ps.executeUpdate() < 1) {
                    this.getLogger().warn("Null account on cancel system account");
                }
                ps.close();
            }
            catch (SQLException ex) {
                this.logError(ex);
            }
            BalanceUtils bu = new BalanceUtils(con);
            bu.updateBalance(time, system.cid);
            bu.close();
        }
    }

    protected void setResponseParameters(MPSResponse response, Element responseElement) {
        Map responseParameters = (Map)response.getParameters().get(KEY_RESPONSE_PARAMETERS);
        if (responseParameters != null) {
            for (Map.Entry entry : responseParameters.entrySet()) {
                XMLUtils.createElement((Element)responseElement, (String)((String)entry.getKey())).setTextContent(String.valueOf(entry.getValue()));
            }
        }
    }

    protected Map<String, String> getResponseAttributes(Connection con, Conf.MPSSystem system, MPSResponse response) {
        if (system.responseAttributes != null && response.getContract() != null && response.getTransId() != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            try {
                BGMacrosFormat format = new BGMacrosFormat(con, response.getContract());
                for (Map.Entry e : system.responseAttributes.entrySet()) {
                    try {
                        result.put((String)e.getKey(), format.format((String)e.getValue(), new Object[0]));
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    private static MPSTransactionManager getBaseTransactionManager() {
        MPSTransactionManager baseTransactionManager = new MPSTransactionManager(){

            @Override
            protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest httpRequest, HttpServletResponse response) {
                return null;
            }

            @Override
            protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
                return null;
            }

            @Override
            protected void processError(MPSException ex, MPSResponse response) {
            }

            @Override
            protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
                return null;
            }

            @Override
            protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
                return null;
            }
        };
        return baseTransactionManager;
    }

    protected byte[] xmlSerialize(Document doc) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(150);
        try {
            XMLUtils.serialize((Node)doc, (OutputStream)out, (String)this.getEncoding());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442\u043d\u0430\u044f xml \u0441\u0435\u0440\u0432\u0438\u0441\u0443: {}", (Object)out.toString(this.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().error("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u0430\u044f \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430", (Throwable)e);
        }
        catch (Exception e) {
            this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438", (Throwable)e);
        }
        return out.toByteArray();
    }
}

