/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.client.admin;

import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class HelpDeskPackageEditor
extends BGPanel {
    private BGTextField title = new BGTextField();
    private BGTextField summa = new BGTextField(10);
    private IntTextField period = new IntTextField();
    private IntTextField count = new IntTextField();
    private JComboBox<ComboBoxItem> chargeBox = new JComboBox();
    private JCheckBox statusBox = new JCheckBox();
    private BGButtonPanelOkCancel controlPanel = new BGButtonPanelOkCancel();

    public HelpDeskPackageEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.summa.setHorizontalAlignment(0);
        this.controlPanel.addActionListener(e -> {
            if (BGButtonPanelOkCancel.OK.getActionCommand().equals(e.getActionCommand())) {
                this.updateData();
            } else {
                this.setVisible(false);
            }
        });
        JPanel titlePanel = new JPanel(new GridBagLayout());
        titlePanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        titlePanel.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
        JPanel dataPanel = new JPanel(new GridBagLayout());
        dataPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434 (\u0434\u043d\u0435\u0439):"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        dataPanel.add((Component)this.period, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 10, 0, 0), 0, 0));
        dataPanel.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 30, 0, 0), 0, 0));
        dataPanel.add((Component)this.summa, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 10, 0, 0), 0, 0));
        dataPanel.add((Component)new JLabel("\u041e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0439:"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 30, 0, 0), 0, 0));
        dataPanel.add((Component)this.count, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 10, 0, 0), 0, 0));
        dataPanel.add((Component)new JLabel("\u0422\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430:"), new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 30, 0, 0), 0, 0));
        dataPanel.add(this.chargeBox, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 10, 0, 0), 0, 0));
        dataPanel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 30, 0, 0), 0, 0));
        dataPanel.add((Component)this.statusBox, new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(titlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(dataPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.controlPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(10, 0, 5, 0), 0, 0));
    }

    public void setData() throws Exception {
        Request request = new Request();
        request.setModule(this.getContext().getModule());
        request.setAction("GetPackage");
        request.setAttribute("id", this.getId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.setDocument(doc);
        }
    }

    public void setDocument(Document doc) throws Exception {
        Element packageElement = XMLUtils.selectElement((Node)doc, (String)"//package");
        Element chargeListElement = XMLUtils.selectElement((Node)doc, (String)"//charge_list");
        this.title.setText(packageElement.getAttribute("title"));
        this.summa.setText(packageElement.getAttribute("summa"));
        this.period.setValue(Utils.parseLong((String)packageElement.getAttribute("period")));
        this.count.setValue(Utils.parseLong((String)packageElement.getAttribute("count")));
        this.statusBox.setSelected(Utils.parseBoolean((String)packageElement.getAttribute("status"), (boolean)false));
        this.chargeBox.setModel(ClientUtils.buildComboBox((Node)chargeListElement, (String)packageElement.getAttribute("chargeId")));
    }

    private void updateData() {
        Request request = new Request();
        request.setModule(this.getContext().getModule());
        request.setAction("UpdatePackage");
        request.setAttribute("id", this.getId());
        request.setAttribute("title", this.title.getText());
        request.setAttribute("period", this.period.getValue());
        request.setAttribute("summa", this.summa.getText());
        request.setAttribute("count", this.count.getValue());
        request.setAttribute("status", this.statusBox.isSelected());
        request.setAttribute("chargeId", ((ComboBoxItem)this.chargeBox.getSelectedItem()).getObject());
        if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
            this.setVisible(false);
        }
    }
}

