/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.tariff;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class ZoneMapTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"world");
    private JLabel view;
    private JPanel editor;
    private BGComboBox<IdTitle> mapCombo;
    private Directory mapDir;
    private int mapId;
    private String mapTitle;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.mapDir = this.getDirManager().getDirectory("zone_maps");
    }

    protected JPanel getEditorPanel() throws Exception {
        if (this.editor == null) {
            this.editor = new JPanel();
            this.mapCombo = new BGComboBox();
            this.buildDirectoryCombo(this.mapDir, (JComboBox)this.mapCombo);
            this.editor.add(new JLabel("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0443 \u0437\u043e\u043d: "));
            this.editor.add((Component)this.mapCombo);
        }
        return this.editor;
    }

    public Component getView() throws Exception {
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        this.extractData();
        StringBuilder sb = new StringBuilder(20);
        sb.append("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0443 \u0437\u043e\u043d: ");
        sb.append(this.mapTitle);
        this.view.setText(sb.toString());
        return this.view;
    }

    private void extractData() throws Exception {
        Map data = this.getDataInHash();
        this.mapId = Utils.parseInt((String)((String)data.get("map_id")));
        this.mapTitle = Utils.maskNull((String)this.mapDir.getValue(this.mapId));
    }

    protected void loadData() throws Exception {
        this.extractData();
        this.setDirectoryItemSelection((JComboBox)this.mapCombo, this.mapId);
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        int mapId = this.getIdFromDirectoryCombo((JComboBox)this.mapCombo);
        data.put("map_id", String.valueOf(mapId));
        this.setDataInHash(data);
    }

    public void serializeToXML(Element el) throws Exception {
        super.serializeToXML(el);
        this.extractData();
        if (Utils.notEmptyString((String)this.mapTitle)) {
            el.setAttribute("title", this.mapTitle);
        }
        el.setAttribute("id", String.valueOf(this.mapId));
        this.serializeChildsToXML(el);
    }

    public void loadFromXML(Element el) throws Exception {
        HashMap<String, String> data = new HashMap<String, String>(3);
        String title = el.getAttribute("title");
        if (title.length() > 0) {
            int id = this.mapDir.getCode(title);
            if (id < 0) {
                id = this.mapDir.addValue(title);
            }
            data.put("map_id", String.valueOf(id));
        }
        this.setDataInHash(data);
        this.saveData();
        this.loadChildsFromXML(el);
    }
}

