/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.BGControlPanelDate;
import bitel.billing.module.common.IPField;
import bitel.billing.module.common.IntTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.time.LocalDate;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.modules.ipn.client.RangeIfacePanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class AddressMove
extends BGPanel {
    private String module = "ipn";
    private int cid = -1;
    private int cPort1 = 0;
    private int cPort2 = 0;
    private long cAddr1 = 0L;
    private long cAddr2 = 0L;
    private long nAddr1 = 0L;
    private RangeIfacePanel ifacePanel = new RangeIfacePanel();
    private BGControlPanelDate date = new BGControlPanelDate();
    private IPField addrTextField_1 = new IPField(){

        public void focusLost(FocusEvent e) {
            long val = this.getIPValue();
            if (val < AddressMove.this.cAddr1) {
                this.setIPValue(AddressMove.this.cAddr1);
            } else if (val > AddressMove.this.cAddr2) {
                this.setIPValue(AddressMove.this.cAddr2);
            }
        }
    };
    private IPField addrTextField_2 = new IPField(){

        private void check() {
            long val = this.getIPValue();
            if (val < AddressMove.this.nAddr1) {
                this.setIPValue(AddressMove.this.nAddr1);
            } else if (val > AddressMove.this.cAddr2) {
                this.setIPValue(AddressMove.this.cAddr2);
            }
        }

        public void focusLost(FocusEvent e) {
            this.check();
        }

        public void focusGained(FocusEvent e) {
            this.check();
        }
    };
    private BGButton addr1Up = new BGButton(">>");
    private BGButton addr1Down = new BGButton("<<");
    private BGButton addr2Up = new BGButton(">>");
    private BGButton addr2Down = new BGButton("<<");
    private IntTextField port1 = new IntTextField();
    private IntTextField port2 = new IntTextField();
    private JTextArea comment = new JTextArea();
    private JLabel current = new JLabel();
    private JList<BGUListItem> contract = new JList();

    public AddressMove() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel1.setLayout(new GridBagLayout());
        jPanel2.setLayout(new GridBagLayout());
        jPanel3.setLayout(new GridBagLayout());
        jPanel4.setLayout(new GridBagLayout());
        this.addrTextField_1.setMinimumSize(new Dimension(165, 24));
        this.addrTextField_1.setPreferredSize(new Dimension(165, 24));
        this.addrTextField_1.setText("0.0.0.0");
        this.addrTextField_1.setHorizontalAlignment(0);
        this.addrTextField_2.setMinimumSize(new Dimension(165, 24));
        this.addrTextField_2.setPreferredSize(new Dimension(165, 24));
        this.addrTextField_2.setText("255.255.255.255");
        this.addrTextField_2.setHorizontalAlignment(0);
        this.addrTextField_1.addActionListener(e -> {
            long val = this.addrTextField_1.getIPValue();
            if (this.addrTextField_2.getIPValue() < val) {
                this.addrTextField_2.setIPValue(val);
            }
            this.nAddr1 = val;
        });
        this.addrTextField_2.addActionListener(e -> {});
        this.addr1Up.addActionListener(e -> {
            long val = Math.min(this.addrTextField_1.getIPValue() + 1L, this.cAddr2);
            this.addrTextField_1.setIPValue(val);
        });
        this.addr1Down.addActionListener(e -> {
            long val = Math.max(this.addrTextField_1.getIPValue() - 1L, this.cAddr1);
            this.addrTextField_1.setIPValue(val);
        });
        this.addr2Up.addActionListener(e -> {
            long val = Math.min(this.addrTextField_2.getIPValue() + 1L, this.cAddr2);
            this.addrTextField_2.setIPValue(val);
        });
        this.addr2Down.addActionListener(e -> {
            long val = Math.max(this.addrTextField_2.getIPValue() - 1L, this.nAddr1);
            this.addrTextField_2.setIPValue(val);
        });
        JLabel jLabel1 = new JLabel(" - ");
        jLabel1.setFont(new Font("Dialog", 1, 16));
        jLabel1.setHorizontalAlignment(0);
        jLabel1.setHorizontalTextPosition(11);
        jPanel2.setBorder((Border)new BGTitleBorder(" \u041d\u043e\u0432\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d "));
        this.current.setFont(new Font("Dialog", 1, 14));
        this.current.setForeground(Color.blue);
        this.current.setToolTipText("");
        this.current.setHorizontalAlignment(0);
        this.current.setText("0.0.0.0 - 255.255.255.255 [0 - 65535]");
        jPanel1.setBorder((Border)new BGTitleBorder(" \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d "));
        this.setForeground(Color.black);
        jPanel3.setBorder((Border)new BGTitleBorder(" \u0414\u043e\u0433\u043e\u0432\u043e\u0440 "));
        this.contract.setSelectionMode(0);
        jPanel5.setLayout(new GridBagLayout());
        this.comment.setMinimumSize(new Dimension(370, 54));
        this.comment.setText("");
        this.comment.setLineWrap(true);
        this.comment.setRows(3);
        this.comment.setWrapStyleWord(true);
        jPanel5.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        jPanel6.setBorder((Border)new BGTitleBorder(" \u041d\u043e\u0432\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043f\u043e\u0440\u0442\u043e\u0432 "));
        this.port1.setMinimumSize(new Dimension(55, 24));
        this.port1.setPreferredSize(new Dimension(55, 24));
        this.port2.setMinimumSize(new Dimension(55, 24));
        this.port2.setPreferredSize(new Dimension(55, 24));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(" - ");
        JScrollPane jScrollPane1 = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane1.setMinimumSize(new Dimension(200, 30));
        jScrollPane1.setPreferredSize(new Dimension(200, 40));
        JPanel panel1 = new JPanel(new GridLayout(0, 2, 5, 0));
        panel1.add((Component)this.addr1Down);
        panel1.add((Component)this.addr1Up);
        JPanel panel2 = new JPanel(new GridLayout(0, 2, 5, 0));
        panel2.add((Component)this.addr2Down);
        panel2.add((Component)this.addr2Up);
        jPanel1.add((Component)this.current, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
        jPanel2.add((Component)this.addrTextField_1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        jPanel2.add((Component)panel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        jPanel2.add((Component)jLabel1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        jPanel2.add((Component)this.addrTextField_2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        jPanel2.add((Component)panel2, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 5, 10), 0, 0));
        jScrollPane1.getViewport().add(this.contract, null);
        jPanel4.add((Component)this.date, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)jPanel6, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel6.add((Component)this.port1, null);
        jPanel6.add((Component)jLabel3, null);
        jPanel6.add((Component)this.port2, null);
        jPanel5.add((Component)jScrollPane2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        jScrollPane2.getViewport().add((Component)this.comment, null);
        jPanel3.add((Component)jScrollPane1, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.ifacePanel.setBorder((Border)new BGTitleBorder("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438/\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u044b"));
        this.add((Component)((Object)this.ifacePanel), new GridBagConstraints(2, 2, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel3, new GridBagConstraints(2, 0, 1, 2, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel5, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void init(String module, int mid) {
        super.init(module, mid);
        this.ifacePanel.init(module, mid);
        this.ifacePanel.setData();
    }

    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetContractAddress");
        request.setModuleId(this.getModuleId());
        request.setContractId(this.cid);
        request.setAttribute("id", this.id);
        this.setDocument(this.getDocument(request));
    }

    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus((Document)doc)) {
            try {
                Element address = XMLUtils.selectElement((Node)doc, (String)"//address");
                this.cAddr1 = Utils.parseLong((String)XMLUtils.getAttribute((Element)address, (String)"addr1", (String)"0"), (long)0L);
                String sAddr1 = IPUtils.convertLongIpToString((long)this.cAddr1);
                this.addrTextField_1.setText(sAddr1);
                this.nAddr1 = this.cAddr1;
                this.cAddr2 = Utils.parseLong((String)XMLUtils.getAttribute((Element)address, (String)"addr2", (String)"0"), (long)0L);
                String sAddr2 = IPUtils.convertLongIpToString((long)this.cAddr2);
                this.addrTextField_2.setText(sAddr2);
                this.port1.setText(XMLUtils.getAttribute((Element)address, (String)"port1", (String)"0"));
                this.cPort1 = (int)this.port1.getValue();
                this.port2.setText(XMLUtils.getAttribute((Element)address, (String)"port2", (String)"65535"));
                this.cPort2 = (int)this.port2.getValue();
                this.port1.setMinValue((long)this.cPort1);
                this.port1.setMaxValue((long)this.cPort2);
                this.port2.setMinValue((long)this.cPort1);
                this.port2.setMaxValue((long)this.cPort2);
                StringBuffer buf = new StringBuffer();
                buf.append(sAddr1);
                buf.append(" - ");
                buf.append(sAddr2);
                buf.append(" [ ");
                buf.append(this.port1.getText());
                buf.append(" - ");
                buf.append(this.port2.getText());
                buf.append(" ] ");
                this.current.setText(buf.toString());
                this.date.setLocalDate(LocalDate.now());
                this.comment.setText("");
                this.ifacePanel.setIfaces(address.getAttribute("ifaces"));
                this.setOpenContractsToList(this.contract);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    public Document buttonOkClick() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("MoveAddress");
        request.setContractId(this.cid);
        request.setModuleId(this.getModuleId());
        request.setAttribute("id", this.id);
        request.setAttribute("ifaces", this.ifacePanel.getIfaces());
        BGUListItem item = this.contract.getSelectedValue();
        if (item != null) {
            request.setAttribute("new_cid", (String)item.getAttribute("cid"));
        }
        request.setAttribute("addr1", this.addrTextField_1.getIPValue());
        request.setAttribute("addr2", this.addrTextField_2.getIPValue());
        request.setAttribute("port1", this.port1.getText());
        request.setAttribute("port2", this.port2.getText());
        String dateString = this.date.getDateString();
        if (dateString != null) {
            request.setAttribute("date", dateString);
        }
        request.setAttribute("comment", this.comment.getText().trim());
        return this.getDocument(request);
    }
}

