/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.collector;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgent;
import ru.bitel.bgbilling.apps.inet.accounting.FlowAgentInterface;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.FlowPacket;
import ru.bitel.bgbilling.modules.inet.server.collector.FlowListenerWorkerContext;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.util.Matcher;
import ru.bitel.common.worker.WorkerTask;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceRuntimeManager;

abstract class FlowListenerWorker<A extends FlowArray<?>>
extends WorkerTask<FlowListenerWorkerContext<A>> {
    private static final Logger logger = LogManager.getLogger();
    protected final long millis;
    protected final List<FlowPacket> packetList;
    protected final int overloadLevel;

    public FlowListenerWorker(long millis, List<FlowPacket> packetList, int overloadLevel) {
        this.millis = millis;
        this.packetList = packetList;
        this.overloadLevel = overloadLevel;
    }

    protected void runImpl() {
        Accounting accounting = ((FlowListenerWorkerContext)this.context).accounting;
        Map<InetAddress, FlowAgent> sourceMap = ((FlowListenerWorkerContext)this.context).ifaceSelector.getAgentMap();
        long now = this.millis;
        int size = this.packetList.size();
        for (int i = 0; i < size; ++i) {
            FlowPacket packet = this.packetList.get(i);
            InetAddress inetAddress = ((InetSocketAddress)packet.address).getAddress();
            FlowAgent source = sourceMap.get(inetAddress);
            if (source == null) {
                logger.warn("Source not found for " + inetAddress);
                continue;
            }
            this.processPacket(accounting, inetAddress, source, packet, now);
        }
    }

    public abstract void processPacket(Accounting var1, InetAddress var2, FlowAgent var3, FlowPacket var4, long var5);

    protected void processPacketImpl(Accounting accounting, InetAddress agentAddress, FlowAgent flowAgent, FlowPacket packet, FlowArray<? extends Data> flows, long now, long millis, Long hour) {
        if (this.overloadLevel > 2) {
            switch (((FlowListenerWorkerContext)this.context).flowFilter) {
                case 1: {
                    if (!this.checkIpResource(accounting, flows, false)) break;
                    ((FlowListenerWorkerContext)this.context).writeRecord(packet, now, hour, flowAgent);
                    break;
                }
                case 2: {
                    if (!this.checkIpResource(accounting, flows, true)) break;
                    ((FlowListenerWorkerContext)this.context).writeRecord(packet, now, hour, flowAgent);
                    break;
                }
                default: {
                    ((FlowListenerWorkerContext)this.context).writeRecord(packet, now, hour, flowAgent);
                }
            }
            return;
        }
        switch (((FlowListenerWorkerContext)this.context).flowFilter) {
            case 1: {
                if (!this.checkIpResource(accounting, flows, false)) break;
                ((FlowListenerWorkerContext)this.context).writeRecord(packet, now, hour, flowAgent);
                this.processPacketImpl0(flowAgent, flows, now, millis, hour);
                break;
            }
            case 2: {
                if (!this.checkIpResource(accounting, flows, true)) break;
                ((FlowListenerWorkerContext)this.context).writeRecord(packet, now, hour, flowAgent);
                this.processPacketImpl0(flowAgent, flows, now, millis, hour);
                break;
            }
            case 3: {
                if (this.checkIpResource(accounting, flows, false)) {
                    ((FlowListenerWorkerContext)this.context).writeRecord(packet, now, hour, flowAgent);
                    this.processPacketImpl0(flowAgent, flows, now, millis, hour);
                    break;
                }
                if (!this.processPacketImpl0(flowAgent, flows, now, millis, hour)) break;
                ((FlowListenerWorkerContext)this.context).writeRecord(packet, now, hour, flowAgent);
                break;
            }
            case 4: {
                if (this.checkIpResource(accounting, flows, true)) {
                    ((FlowListenerWorkerContext)this.context).writeRecord(packet, now, hour, flowAgent);
                    this.processPacketImpl0(flowAgent, flows, now, millis, hour);
                    break;
                }
                if (!this.processPacketImpl0(flowAgent, flows, now, millis, hour)) break;
                ((FlowListenerWorkerContext)this.context).writeRecord(packet, now, hour, flowAgent);
                break;
            }
            case 5: {
                if (!this.processPacketImpl0(flowAgent, flows, now, millis, hour)) break;
                ((FlowListenerWorkerContext)this.context).writeRecord(packet, now, hour, flowAgent);
                break;
            }
            default: {
                ((FlowListenerWorkerContext)this.context).writeRecord(packet, now, hour, flowAgent);
                this.processPacketImpl0(flowAgent, flows, now, millis, hour);
            }
        }
    }

    private boolean checkIpResource(Accounting accounting, FlowArray<? extends Data> flows, boolean withTime) {
        boolean skip = true;
        Object matcher = withTime ? new Matcher<IpResourceRuntimeManager.IpResourceRange>(){

            public boolean matched(IpResourceRuntimeManager.IpResourceRange x) {
                return RangeUtils.inRange((long)FlowListenerWorker.this.millis, (long)FlowListenerWorker.this.millis, (long)x.dateFrom, (long)x.dateTo);
            }
        } : new Matcher<IpResourceRuntimeManager.IpResourceRange>(){

            public boolean matched(IpResourceRuntimeManager.IpResourceRange x) {
                return true;
            }
        };
        int size = flows.size;
        for (int i = 0; i < size; ++i) {
            Data flow = flows.array[i];
            IpAddress srcAddress = flow.getSrcIpAddress();
            IpAddress dstAddress = flow.getDstIpAddress();
            if (!accounting.ipResourceManager.contains(srcAddress.address, (Matcher)matcher) && !accounting.ipResourceManager.contains(dstAddress.address, (Matcher)matcher)) continue;
            skip = false;
            break;
        }
        return skip;
    }

    private boolean processPacketImpl0(FlowAgent flowAgent, FlowArray<? extends Data> flows, long now, long millis, Long hour) {
        if (!flowAgent.process) {
            if (logger.isTraceEnabled()) {
                logger.trace("Skip processing packet");
            }
            return true;
        }
        Set<Integer> processAgentDeviceIds = ((FlowListenerWorkerContext)this.context).processAgentDeviceIds;
        if (processAgentDeviceIds != null && !processAgentDeviceIds.contains(flowAgent.getId())) {
            if (logger.isTraceEnabled()) {
                logger.trace("Skip processing packet (not processing device)");
            }
            return true;
        }
        boolean result = false;
        int size = flows.size;
        for (int i = 0; i < size; ++i) {
            Data flow = flows.array[i];
            IpAddress srcAddress = flow.getSrcIpAddress();
            IpAddress dstAddress = flow.getDstIpAddress();
            int srcPort = flow.getSrcPort();
            int dstPort = flow.getDstPort();
            long octets = flow.getOctets();
            if (srcAddress == null || srcAddress.address == null || dstAddress == null || dstAddress.address == null) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("srcAddress and/or dstAddress is null - skiping record");
                continue;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Processing " + flow.toString());
            }
            int inputIface = flow.getInputInterface();
            int outputIface = flow.getOutputInterface();
            int diffServ = flow.getDiffServ();
            try {
                FlowAgentInterface iface = flowAgent.getInterface(hour, millis, inputIface);
                if (iface == null || !iface.processFlow(flow, hour, millis, srcAddress, 1, outputIface, dstAddress, dstPort, diffServ, octets, true)) {
                    if (logger.isTraceEnabled()) {
                        if (iface == null) {
                            logger.trace("Not found iface = " + inputIface);
                        } else {
                            logger.trace("Session not found on iface = " + inputIface);
                        }
                    }
                    if (flowAgent.defaultIface != null) {
                        if (!flowAgent.defaultIface.processFlow(flow, hour, millis, srcAddress, 1, outputIface, dstAddress, dstPort, diffServ, octets, true)) {
                            logger.trace("Session not found on default iface");
                        } else {
                            result = true;
                        }
                    } else {
                        logger.trace("Default iface not found");
                    }
                } else {
                    result = true;
                }
                iface = flowAgent.getInterface(hour, millis, outputIface);
                if (iface == null || !iface.processFlow(flow, hour, millis, dstAddress, 2, inputIface, srcAddress, srcPort, diffServ, octets, true)) {
                    if (logger.isTraceEnabled()) {
                        if (iface == null) {
                            logger.trace("Not found iface = " + outputIface);
                        } else {
                            logger.trace("Session not found on iface = " + outputIface);
                        }
                    }
                    if (flowAgent.defaultIface != null) {
                        if (!flowAgent.defaultIface.processFlow(flow, hour, millis, dstAddress, 2, inputIface, srcAddress, srcPort, diffServ, octets, true)) {
                            logger.trace("Session not found on default iface");
                            continue;
                        }
                        result = true;
                        continue;
                    }
                    logger.trace("Default iface not found");
                    continue;
                }
                result = true;
                continue;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }
}

