/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.radius;

import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.FlowPacket;
import ru.bitel.bgbilling.kernel.network.flow.NetFlowArray;
import ru.bitel.bgbilling.kernel.network.flow.SFlowArray;
import ru.bitel.bgbilling.modules.dialup.server.radius.FlowListenerWorkerContext;
import ru.bitel.bgbilling.modules.dialup.server.radius.TrafficInspector;
import ru.bitel.bgbilling.modules.dialup.server.traffic.ServiceLinkFinder;
import ru.bitel.common.worker.WorkerTask;

class FlowListenerWorker
extends WorkerTask<FlowListenerWorkerContext> {
    private static final Logger logger = LogManager.getLogger();
    protected final List<FlowPacket> packetList;

    public FlowListenerWorker(List<FlowPacket> packetList) {
        this.packetList = packetList;
    }

    protected void runImpl() {
        Map<String, List<TrafficInspector>> receiveFrom = ((FlowListenerWorkerContext)this.context).receiveFrom;
        ServiceLinkFinder serviceFinder = ((FlowListenerWorkerContext)this.context).serviceFinder;
        long millis = System.currentTimeMillis();
        int size = this.packetList.size();
        for (int i = 0; i < size; ++i) {
            FlowPacket packet = this.packetList.get(i);
            InetAddress inetAddress = ((InetSocketAddress)packet.address).getAddress();
            String host = inetAddress.getHostAddress();
            List<TrafficInspector> nasList = receiveFrom.get(host);
            if (nasList == null) {
                logger.info("Ignoring NetFlow packet from host " + host);
                return;
            }
            byte[] address = inetAddress.getAddress();
            long hostAddress = address[3] & 0xFF;
            hostAddress |= (long)(address[2] << 8 & 0xFF00);
            hostAddress |= (long)(address[1] << 16 & 0xFF0000);
            hostAddress |= (long)(address[0] << 24 & 0xFF000000);
            this.processPacket(serviceFinder, nasList, hostAddress &= 0xFFFFFFFFL, packet, millis);
        }
    }

    public void processPacket(ServiceLinkFinder serviceFinder, List<TrafficInspector> nasList, long agentAddress, FlowPacket packet, long millis) {
        if (packet.data.getInt(0) == 5) {
            SFlowArray sFlowArray = ((FlowListenerWorkerContext)this.context).sFlowArray;
            if (sFlowArray.parsePacket(packet.data, millis)) {
                this.processPacket(serviceFinder, nasList, agentAddress, (FlowArray<? extends Data>)sFlowArray);
            }
        } else {
            NetFlowArray netFlowArray = ((FlowListenerWorkerContext)this.context).netFlowArray;
            if (netFlowArray.parsePacket(packet.data, millis)) {
                this.processPacket(serviceFinder, nasList, agentAddress, (FlowArray<? extends Data>)netFlowArray);
            }
        }
    }

    protected void processPacket(ServiceLinkFinder serviceFinder, List<TrafficInspector> nasList, long agentAddress, FlowArray<? extends Data> packet) {
        int size = packet.size;
        block5: for (int i = 0; i < size; ++i) {
            Data flow = packet.array[i];
            if (logger.isDebugEnabled()) {
                logger.debug("Processing flow..");
                logger.debug(flow.toString());
            }
            long srcAddress = flow.getSrcAddress();
            long dstAddress = flow.getDstAddress();
            int srcPort = flow.getSrcPort();
            int dstPort = flow.getDstPort();
            long octets = flow.getOctets();
            switch (serviceFinder.getServiceLinkMode()) {
                case 0: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Outgoing mode..");
                    }
                    this.processFlow(serviceFinder, nasList, agentAddress, 1, srcAddress, dstAddress, srcPort, dstPort, octets);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Incoming mode..");
                    }
                    this.processFlow(serviceFinder, nasList, agentAddress, 2, srcAddress, dstAddress, srcPort, dstPort, octets);
                    continue block5;
                }
                case 2: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Outgoing mode..");
                    }
                    this.processFlow(serviceFinder, nasList, agentAddress, 1, srcAddress, dstAddress, srcPort, dstPort, octets);
                    continue block5;
                }
                case 1: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Incoming mode..");
                    }
                    this.processFlow(serviceFinder, nasList, agentAddress, 2, srcAddress, dstAddress, srcPort, dstPort, octets);
                }
            }
        }
    }

    protected void processFlow(ServiceLinkFinder serviceFinder, List<TrafficInspector> nasList, long address, int direction, long srcAddress, long dstAddress, int srcPort, int dstPort, long octets) {
        if (logger.isDebugEnabled()) {
            logger.debug("Finding session on " + nasList.size() + " nases..");
        }
        for (TrafficInspector inspector : nasList) {
            int sid;
            DialUpSessionRealtime session = null;
            if (direction == 1) {
                session = inspector.getSession(srcAddress);
                if (session == null && logger.isDebugEnabled()) {
                    logger.debug("Session not found " + IPUtils.convertLongIpToString((long)srcAddress));
                }
            } else {
                session = inspector.getSession(dstAddress);
                if (session == null && logger.isDebugEnabled()) {
                    logger.debug("Session not found " + IPUtils.convertLongIpToString((long)dstAddress));
                }
            }
            if (session == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("OK address registred..");
            }
            long serviceIP = -1L;
            int servicePort = -1;
            if (direction == 1) {
                serviceIP = dstAddress;
                servicePort = dstPort;
            } else {
                serviceIP = srcAddress;
                servicePort = srcPort;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Service find IP:" + IPUtils.convertLongIpToString((long)serviceIP) + "; port:" + servicePort + "; direct ( 1 - out / 2 - in   ): " + direction);
            }
            if ((sid = serviceFinder.getServiceId(direction, serviceIP, servicePort)) < 0) {
                logger.error("Service not found for direct=" + direction + "; IP:" + IPUtils.convertLongIpToString((long)serviceIP) + "; port:" + servicePort);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("SID = " + sid);
            }
            session.addTrafficCollectorValuebySID(sid, octets);
        }
    }
}

