/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.modules.ipn.server.GateWorker;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.dlink.UserPortStatus;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class DHCPGateWorker
extends GateWorker {
    private static final Pattern patternTab = Pattern.compile("\\t");

    @Override
    protected void doSync() {
    }

    @Override
    public void parentSync(Gate child, GateWorker childWorker) {
        this.log.debug("parentSync");
        String host = this.gate.getHost();
        int port = this.gate.getPort();
        int gid = this.gate.getId();
        Preferences gateSetup = new Preferences(this.gate.getConfig(), "\n");
        int timeout = gateSetup.getInt("timeout", 0);
        if (Utils.isEmptyString((String)host) || port <= 0) {
            this.log.error("Can't get IP/port for BGDHCP for this gate! ");
            this.gateErrors.append("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0430\u0434\u0440\u0435\u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 dhcp \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0448\u043b\u044e\u0437\u0430!");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(gid + " gate: " + host + ":" + port);
        }
        Socket socket = null;
        try {
            if (childWorker instanceof UserPortStatus.UserPortStatusParser) {
                List<UserPortStatus> userPortStatusList = ((UserPortStatus.UserPortStatusParser)((Object)childWorker)).getUserList(childWorker.statusList);
                socket = new Socket(host, port);
                socket.setSoTimeout(timeout);
                InputStreamReader isr = new InputStreamReader(socket.getInputStream());
                BufferedReader in = new BufferedReader(isr);
                XMLOutputFactory xof = XMLOutputFactory.newInstance();
                XMLStreamWriter xmlStreamWriter = xof.createXMLStreamWriter(new OutputStreamWriter(socket.getOutputStream()));
                xmlStreamWriter.writeStartDocument("utf-8", "1.0");
                xmlStreamWriter.writeStartElement("sync");
                xmlStreamWriter.writeAttribute("type", "dhcp");
                Gate gate = child;
                this.syncGate(gate, xmlStreamWriter);
                xmlStreamWriter.writeStartElement("list");
                xmlStreamWriter.writeAttribute("gateId", String.valueOf(gate.getId()));
                xmlStreamWriter.writeEndElement();
                HashMap<Integer, UserPortStatus> portStatusMap = new HashMap<Integer, UserPortStatus>();
                String line = in.readLine();
                while (line != null && !"".equals(line)) {
                    String[] p = patternTab.split(line);
                    if (p.length > 1) {
                        UserPortStatus st = new UserPortStatus();
                        st.ipAddr = p[1];
                        st.port = Utils.parseInt((String)p[0], (int)-1);
                        portStatusMap.put(st.port, st);
                    }
                    line = in.readLine();
                }
                String gateId = String.valueOf(gate.getId());
                for (UserPortStatus status : userPortStatusList) {
                    UserPortStatus s = (UserPortStatus)portStatusMap.remove(status.port);
                    if (!(s != null && s.ipAddr.equals(status.ipAddr) || status.status.status == 3)) {
                        xmlStreamWriter.writeStartElement(status.macAddr == null ? "port" : "portMac");
                        xmlStreamWriter.writeAttribute("gateId", gateId);
                        xmlStreamWriter.writeAttribute("id", String.valueOf(status.port));
                        xmlStreamWriter.writeAttribute("ip", status.ipAddr);
                        if (status.macAddr != null) {
                            xmlStreamWriter.writeAttribute("mac", status.macAddr);
                        }
                        xmlStreamWriter.writeEndElement();
                    }
                    if (s == null || status.status.status != 3) continue;
                    xmlStreamWriter.writeStartElement("removePort");
                    xmlStreamWriter.writeAttribute("gateId", gateId);
                    xmlStreamWriter.writeAttribute("id", String.valueOf(status.port));
                    xmlStreamWriter.writeAttribute("ip", status.ipAddr);
                    xmlStreamWriter.writeEndElement();
                }
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndDocument();
                xmlStreamWriter.flush();
                xmlStreamWriter.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void syncGates(Gate gate, XMLStreamWriter xmlStreamWriter) {
        try {
            if (gate != null) {
                xmlStreamWriter.writeStartElement("gate");
                xmlStreamWriter.writeAttribute("id", String.valueOf(gate.getId()));
                xmlStreamWriter.writeAttribute("host", gate.getHost());
                Preferences gateSetup = new Preferences(gate.getConfig(), "\n");
                ParameterMap params = gateSetup.sub("dhcp.");
                for (Map.Entry e : params.entrySet()) {
                    xmlStreamWriter.writeStartElement("param");
                    xmlStreamWriter.writeAttribute("id", "dhcp." + (String)e.getKey());
                    xmlStreamWriter.writeAttribute("value", (String)e.getValue());
                    xmlStreamWriter.writeEndElement();
                }
                if (gate.getChildren() != null) {
                    for (Gate gateChildren : gate.getChildren()) {
                        this.syncGates(gateChildren, xmlStreamWriter);
                    }
                }
                xmlStreamWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    protected void syncGate(Gate gate, XMLStreamWriter xmlStreamWriter) {
        try {
            if (gate != null) {
                ArrayList<Gate> gateList = new ArrayList<Gate>();
                gateList.add(gate);
                for (Gate g = gate; g != null; g = g.getParent()) {
                    gateList.add(g);
                }
                HashMap<String, String> params = new HashMap<String, String>();
                for (int i = gateList.size() - 1; i >= 0; --i) {
                    Preferences gateSetup = new Preferences(((Gate)gateList.get(i)).getConfig(), "\n");
                    ParameterMap p = gateSetup.sub("dhcp.");
                    for (Map.Entry e : p.entrySet()) {
                        params.put((String)e.getKey(), (String)e.getValue());
                    }
                }
                xmlStreamWriter.writeStartElement("gate");
                xmlStreamWriter.writeAttribute("id", String.valueOf(gate.getId()));
                xmlStreamWriter.writeAttribute("host", gate.getHost());
                for (Map.Entry e : params.entrySet()) {
                    xmlStreamWriter.writeStartElement("param");
                    xmlStreamWriter.writeAttribute("id", "dhcp." + (String)e.getKey());
                    xmlStreamWriter.writeAttribute("value", (String)e.getValue());
                    xmlStreamWriter.writeEndElement();
                }
                xmlStreamWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    protected List<Gate> getGateListFromTree(Gate root) {
        ArrayList<Gate> result = new ArrayList<Gate>();
        this.getGateListFromTree(result, root);
        return result;
    }

    protected void getGateListFromTree(List<Gate> list, Gate root) {
        if (root != null) {
            list.add(root);
        }
        if (root.getChildren() != null) {
            for (Gate gate : root.getChildren()) {
                this.getGateListFromTree(list, gate);
            }
        }
    }
}

