/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.modules.dba.server.bean.TableConfigItem;
import ru.bitel.common.Utils;

public class TableConfigManager {
    private Connection con;
    private String tableName;

    public TableConfigManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "dba_table_config_" + mid;
    }

    public List<TableConfigItem> getConfigItemList() {
        ArrayList<TableConfigItem> result = new ArrayList<TableConfigItem>();
        try {
            String query = "SELECT * FROM " + this.tableName;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                TableConfigItem item = new TableConfigItem();
                item.setModuleId(rs.getInt("mid"));
                item.setTableId(rs.getInt("tid"));
                item.setData(rs.getString("data"));
                result.add(item);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<String, String> getConfigItemMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String query = "SELECT * FROM " + this.tableName;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.put(rs.getInt("mid") + "_" + rs.getInt("tid"), rs.getString("data"));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateConfigItem(TableConfigItem item) {
        try {
            String query = null;
            PreparedStatement ps = null;
            query = "DELETE FROM " + this.tableName + " WHERE mid=? AND tid=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, item.getModuleId());
            ps.setInt(2, item.getTableId());
            ps.executeUpdate();
            ps.close();
            if (Utils.notBlankString((String)item.getData())) {
                query = "INSERT INTO " + this.tableName + " (mid, tid, data) VALUES (?, ?, ?)";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, item.getModuleId());
                ps.setInt(2, item.getTableId());
                ps.setString(3, item.getData());
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

