/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.client.tariff.tree;

import bitel.billing.module.common.FloatTextField;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.common.Utils;

public class CostTariffTreeNode
extends DefaultTariffTreeNode {
    private static final String KEY_COST = "cost";
    private static final String KEY_OPERATION = "operation";
    private static final String[] operations = new String[]{"=", "+", "-", "*"};
    private static Icon icon = ClientUtils.getIcon((String)"coin");
    private JPanel editPanel;
    private FloatTextField costField;
    private JComboBox<String> operationComboBox = new JComboBox<String>(operations);

    protected JPanel getEditorPanel() {
        this.editPanel = new JPanel();
        this.costField = new FloatTextField();
        this.costField.setColumns(10);
        this.editPanel.add(new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c "));
        this.editPanel.add(this.operationComboBox);
        this.editPanel.add((Component)this.costField);
        return this.editPanel;
    }

    public Component getView() {
        Map data = this.getDataInHash();
        String operation = (String)data.get(KEY_OPERATION);
        if (operation == null) {
            operation = operations[0];
        }
        String cost = (String)data.get(KEY_COST);
        int scale = 2;
        if (cost == null) {
            cost = "0";
        } else {
            int pos = cost.replace(',', '.').indexOf(46);
            if (pos > -1) {
                scale = cost.length() - pos - 1;
            }
        }
        cost = Utils.formatCostByGrouping((BigDecimal)new BigDecimal(cost), (int)3, (int)scale);
        return new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c " + operation + " " + cost, icon, 2);
    }

    protected void loadData() {
        Map data = this.getDataInHash();
        this.costField.setText(data.getOrDefault(KEY_COST, "0"));
        this.operationComboBox.setSelectedItem(data.getOrDefault(KEY_OPERATION, operations[0]));
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(KEY_COST, this.costField.getText());
        data.put(KEY_OPERATION, (String)this.operationComboBox.getSelectedItem());
        this.setDataInHash(data);
    }
}

