/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server;

import bitel.billing.server.MaxTrafficCalculator;
import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import bitel.billing.server.tariff.detail.TariffDetailKey;
import bitel.billing.server.tariff.detail.TariffDetailUtils;
import bitel.billing.server.tariff.detail.TariffDetailValue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpSessionUtils;
import ru.bitel.bgbilling.modules.dialup.server.calc.CalcPeriod;
import ru.bitel.bgbilling.modules.dialup.server.calc.ContractData;
import ru.bitel.bgbilling.modules.dialup.server.calc.ContractDataStorage;
import ru.bitel.bgbilling.modules.dialup.server.calc.SessionUpdater;
import ru.bitel.bgbilling.modules.dialup.server.mail.MailTaskSessionsRecalculator;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class SessionsRecalculator
extends RunTask {
    private int mid = -1;
    private String email;
    private Calendar _date1;
    private Calendar _date2;
    private long _groups = 0L;
    private String contracts;
    private Calendar startMonth;
    private Calendar endMonth;
    private StringBuffer report;
    private Preferences moduleSetup;
    private String logSessionTableName;
    private String sessionDetailTableName;
    private String sessionAccountTableName;
    private String sids;
    private SessionUpdater sessionUpdater;
    private ContractDataStorage contractDataStorage;
    private Connection con;
    private Connection conSlave;
    private static final int MAX_LOG_ERROR_COUNT = 100;

    public SessionsRecalculator(String email, Calendar date1, Calendar date2, int mid, long groups, String contracts) {
        this.email = email;
        this._date1 = date1;
        this._date2 = date2;
        this.mid = mid;
        this._groups = groups;
        this.contracts = contracts;
        this.startMonth = (Calendar)this._date1.clone();
        this.startMonth.set(5, 1);
        this.endMonth = (Calendar)this._date2.clone();
        this.endMonth.set(5, this.endMonth.getActualMaximum(5));
    }

    public String getDescription() {
        return "\u041c\u043e\u0434\u0443\u043b\u044c DialUp. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0430 \u0441\u0435\u0441\u0441\u0438\u0439. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.mid + ". \u0417\u0430 \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.format((Calendar)this.startMonth, (String)"MM.yyyy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() {
        this.con = this.setup.getDBConnectionFromPool();
        this.conSlave = this.setup.getDBSlaveConnectionFromPool();
        try {
            this.getLogger().info("DialUp recalculate started..");
            this.logSessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)this._date1.getTime(), (int)this.mid);
            this.sessionAccountTableName = ServerUtils.getModuleMonthTableName((String)"session_account", (Date)this._date1.getTime(), (int)this.mid);
            this.sessionDetailTableName = ServerUtils.getModuleMonthTableName((String)"session_detail", (Date)this._date1.getTime(), (int)this.mid);
            this.prepareReportAndBeans();
            String whereString = this.getWhereString();
            String query = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            HashMap<TariffDetailKey, TariffDetailValue> tariffDetailMap = new HashMap<TariffDetailKey, TariffDetailValue>(1024);
            Set tariffDetailRangeTakeAllSet = TariffDetailUtils.getCostTypeRangeTakeAllIdSet((Preferences)this.moduleSetup);
            int sessionCount = 0;
            int errorSessionCount = 0;
            if (ServerUtils.tableExists((Connection)this.con, (String)this.logSessionTableName)) {
                query = "SELECT contract.title, login.login, session.session_start, login.cid, session.id,  detail.dtime, detail.sid, detail.amount FROM " + this.logSessionTableName + " AS session LEFT JOIN " + this.sessionDetailTableName + " AS detail ON session.id=detail.session_id INNER JOIN user_login_" + this.mid + " AS login ON session.lid=login.id INNER JOIN contract ON login.cid=contract.id " + whereString;
                query = query + " WHERE session_start>=? AND session_start<? ";
                if (ServerUtils.columnExist((Connection)this.con, (String)this.logSessionTableName, (String)"fake")) {
                    query = query + " AND fake=0";
                }
                query = query + " ORDER BY login.cid, session.id, detail.sid";
                ps = this.conSlave.prepareStatement(query);
                ps.setFetchSize(1000000);
                ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)this._date1));
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)TimeUtils.getNextDay((Calendar)this._date2)));
                rs = ps.executeQuery();
                this.getLogger().info("DialUp recalculate session selected, start recalculate..");
                ContractData currentContractData = null;
                int currentSessionId = 0;
                boolean currentSessionStatus = true;
                HashMap<Integer, Double> sessionAccount = new HashMap<Integer, Double>();
                while (rs.next()) {
                    if (sessionCount == 0) {
                        ++sessionCount;
                    }
                    int cid = rs.getInt(4);
                    int sessionId = rs.getInt(5);
                    Calendar dtime = TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp(6));
                    int sid = rs.getInt(7);
                    long amount = rs.getLong(8);
                    if (currentSessionId != 0 && sessionId != currentSessionId) {
                        if (currentContractData != null) {
                            this.sessionUpdater.updateSessionData(currentSessionId, currentContractData.cid, sessionAccount);
                        }
                        if (!currentSessionStatus) {
                            ++errorSessionCount;
                        }
                        if (++sessionCount != 0 && sessionCount % 100 == 0) {
                            this.getLogger().info("DialUp recalculate sessions => " + sessionCount);
                        }
                        sessionAccount = new HashMap(5);
                        currentSessionStatus = true;
                    }
                    currentSessionId = sessionId;
                    if (dtime != null && sid > 0 && amount > 0L) {
                        if (currentContractData == null || cid != currentContractData.cid) {
                            currentContractData = this.contractDataStorage.getContractData(cid, sessionId, dtime);
                        }
                        TariffTreeSet.TariffSetEntry tse = currentContractData.tts.getTreeEntry(dtime);
                        CalcPeriod period = currentContractData.getCalcPeriod(dtime);
                        if (tse != null && period != null) {
                            TariffRequest calcReq = new TariffRequest();
                            calcReq.setRequestParam("cid", (Object)currentContractData.cid);
                            calcReq.setRequestParam("action", (Object)"calculate");
                            calcReq.setRequestParam("month_time", (Object)this.startMonth);
                            float servicePart = DialUpSessionUtils.getPart(period.start, period.end, sid, currentContractData.serviceRanges);
                            float tariffPart = tse.getPartOnPeriod(period.start, period.end);
                            float tariffPartSuspended = tse.getPartOnPeriod(period.start, period.end, currentContractData.suspendedPeriods);
                            calcReq.setRequestParam("sid", (Object)sid);
                            calcReq.setRequestParam("time", (Object)dtime);
                            calcReq.setRequestParam("amount", (Object)amount);
                            calcReq.setRequestParam("period_end", (Object)period.end);
                            calcReq.setRequestParam("part_service", (Object)Float.valueOf(servicePart));
                            calcReq.setRequestParam("part_tariff", (Object)Float.valueOf(tariffPart));
                            calcReq.setRequestParam("part_tariff_suspended", (Object)Float.valueOf(tariffPartSuspended));
                            calcReq.setRequestParam("tariffOptions", (Object)currentContractData.tariffOptions);
                            calcReq.setRequestParam("costTypeRangeTakeAllSet", (Object)tariffDetailRangeTakeAllSet);
                            tse.getTree().processRequest(calcReq);
                            Float costAmount = (Float)calcReq.getResponseParam("costAmount");
                            Float dividend = (Float)calcReq.getResponseParam("cost");
                            Long divisor = (Long)calcReq.getResponseParam("divisor");
                            if (calcReq.wasAccepted()) {
                                Double cost = null;
                                if (costAmount != null) {
                                    cost = costAmount.doubleValue();
                                } else if (dividend != null && divisor != null && divisor > 0L) {
                                    cost = (double)amount * dividend.doubleValue() / (double)divisor.longValue();
                                }
                                if (cost != null) {
                                    Double costSum = (Double)sessionAccount.get(sid);
                                    costSum = costSum != null ? Double.valueOf(costSum + cost) : cost;
                                    sessionAccount.put(sid, costSum);
                                    TariffDetailUtils.putTariffDetail(tariffDetailMap, (TariffRequest)calcReq, (int)currentContractData.cid, (int)sid, (double)cost, (long)amount);
                                }
                            } else {
                                if (currentSessionStatus && errorSessionCount <= 100) {
                                    this.report.append("\n\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0446\u0435\u043d\u0430 \u0443\u0441\u043b\u0443\u0433\u0438 " + sid + " \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + rs.getString(1) + "; \u043b\u043e\u0433\u0438\u043d: " + rs.getString(2) + "; \u0432\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u0441\u0435\u0441\u0441\u0438\u0438: " + TimeUtils.format((Date)rs.getTimestamp(3), (String)"dd.MM.yyyy HH:mm:ss") + "; \u0432\u0440\u0435\u043c\u044f: " + TimeUtils.format((Calendar)dtime, (String)"dd.MM.yyyy HH:mm:ss"));
                                }
                                currentSessionStatus = false;
                            }
                            TariffRequest initReq = new TariffRequest();
                            initReq.setRequestParam("cid", (Object)currentContractData.cid);
                            initReq.setRequestParam("action", (Object)"init");
                            initReq.setRequestParam("month_time", (Object)this.startMonth);
                            initReq.setRequestParam("sid", (Object)sid);
                            initReq.setRequestParam("time", (Object)dtime);
                            initReq.setRequestParam("amount", (Object)amount);
                            initReq.setRequestParam("period_end", (Object)period.end);
                            calcReq.setRequestParam("part_service", (Object)Float.valueOf(servicePart));
                            calcReq.setRequestParam("part_tariff", (Object)Float.valueOf(tariffPart));
                            calcReq.setRequestParam("part_tariff_suspended", (Object)Float.valueOf(tariffPartSuspended));
                            calcReq.setRequestParam("tariffOptions", (Object)currentContractData.tariffOptions);
                            tse.getTree().processRequest(initReq);
                        } else {
                            if (currentSessionStatus && errorSessionCount <= 100) {
                                this.report.append("\n\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0446\u0435\u043d\u0430 \u0443\u0441\u043b\u0443\u0433\u0438 " + sid + " \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + rs.getString(1) + "; \u043b\u043e\u0433\u0438\u043d: " + rs.getString(2) + "; \u0432\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u0441\u0435\u0441\u0441\u0438\u0438: " + TimeUtils.format((Date)rs.getTimestamp(3), (String)"dd.MM.yyyy HH:mm:ss") + "; \u0432\u0440\u0435\u043c\u044f: " + TimeUtils.format((Calendar)dtime, (String)"dd.MM.yyyy HH:mm:ss"));
                            }
                            currentSessionStatus = false;
                        }
                    }
                    if (!rs.isLast()) continue;
                    if (currentContractData != null) {
                        this.sessionUpdater.updateSessionData(currentSessionId, currentContractData.cid, sessionAccount);
                    }
                    if (!currentSessionStatus) {
                        ++errorSessionCount;
                    }
                    ++sessionCount;
                }
                ps.close();
            } else {
                this.report.append("\n\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u0430 " + this.logSessionTableName);
            }
            this.getLogger().info("DialUp session recalculate finished, count => " + sessionCount);
            this.report.append("\n\n\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u0441\u0447\u0435\u0442\u0430 => ");
            this.report.append(TimeUtils.format((Calendar)new GregorianCalendar(), (String)"dd.MM.yyyy HH:mm:ss"));
            this.report.append("\n\u0421\u0435\u0441\u0441\u0438\u0439 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e => ");
            this.report.append(sessionCount);
            this.report.append("\n\u0418\u0437 \u043d\u0438\u0445 \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0445 => ");
            this.report.append(errorSessionCount);
            this.getLogger().info("DialUp recalculate result: \n");
            this.getLogger().info(this.report.toString());
            this.getLogger().info("Start wait session updater");
            this.sessionUpdater.waitUpdater();
            this.getLogger().info("Stop wait session updater");
            this.setBalanceAndSendReport(whereString, tariffDetailMap, tariffDetailRangeTakeAllSet);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)this.con, (Connection)this.conSlave);
        }
    }

    private String getWhereString() {
        Object whereString = null;
        whereString = Utils.notBlankString((String)this.contracts) ? " AND contract.id IN ( " + this.contracts + ")" : (this._groups > 0L ? " AND contract.gr&" + this._groups + ">0" : "");
        return whereString;
    }

    private void prepareReportAndBeans() {
        this.report = new StringBuffer(10000);
        this.moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.mid));
        this.sids = MaxTrafficCalculator.getModuleServicesWithoutMaxTraf((Connection)this.con, (int)this.mid, (Preferences)this.moduleSetup);
        this.report.append("\u0417\u0430\u043f\u0443\u0441\u043a \u043f\u0435\u0440\u0435\u0441\u0447\u0435\u0442\u0430 => ");
        this.report.append(TimeUtils.format((Calendar)new GregorianCalendar(), (String)"dd.MM.yyyy HH:mm:ss"));
        this.report.append("\n");
        this.report.append("\n\u041f\u0435\u0440\u0438\u043e\u0434: " + TimeUtils.formatPeriod((Calendar)this._date1, (Calendar)this._date2));
        this.sessionUpdater = new SessionUpdater((DefaultServerSetup)this.setup, this.sessionAccountTableName, this.logSessionTableName);
        this.contractDataStorage = new ContractDataStorage(this.conSlave, this.mid, this.sids, this._date1, this._date2, this.startMonth, this.endMonth);
    }

    private void setBalanceAndSendReport(String whereString, Map<TariffDetailKey, TariffDetailValue> tariffDetailMap, Set<Integer> tariffDetailRangeTakeAllSet) throws SQLException {
        ServiceCostCache cache = new ServiceCostCache();
        String query = "SELECT cid, sid, SUM(summa) FROM " + this.sessionAccountTableName + " AS session_account INNER JOIN contract ON session_account.cid=contract.id INNER JOIN " + this.logSessionTableName + " AS session ON session.id=session_account.session_id" + whereString + " GROUP BY cid, sid";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            CostSum sum = new CostSum(rs.getInt(1), rs.getInt(2), rs.getBigDecimal(3));
            cache.addAmount(sum);
        }
        ps.close();
        this.getLogger().info("Start balance setting.");
        BalanceUtils bu = new BalanceUtils(this.con);
        bu.setAccount(this.con, this.getLogger(), this.startMonth, cache, this.sids, this.contracts, null);
        bu.close();
        if (TimeUtils.dateEqual((Calendar)this._date1, (Calendar)this.startMonth) && TimeUtils.dateEqual((Calendar)this._date2, (Calendar)this.endMonth)) {
            int records = TariffDetailUtils.flushTariffDetail((Logger)this.getLogger(), (String)"dialup", (DefaultServerSetup)this.setup, (Preferences)this.moduleSetup, (Connection)this.con, (int)this.mid, (Calendar)this.startMonth, (Calendar)this.endMonth, (String)this.contracts, (long)this._groups, tariffDetailMap, tariffDetailRangeTakeAllSet, (int)1);
            this.report.append("\n\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0433\u043e \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043f\u043e \u0442\u0438\u043f\u0430\u043c \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f: \u0437\u0430\u043f\u0438\u0441\u0435\u0439 - " + records);
        } else {
            this.report.append("\n\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0433\u043e \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043d\u0435 \u043f\u0435\u0440\u0435\u0441\u0447\u0438\u0442\u0430\u043d\u0430, \u0442.\u043a. \u043f\u0435\u0440\u0438\u043e\u0434 \u043e\u0431\u0441\u0447\u0435\u0442\u0430 - \u043d\u0435 \u0432\u0435\u0441\u044c \u043c\u0435\u0441\u044f\u0446.");
            this.getLogger().info("Tariff detail not calculated because period of calculating is not a month.");
        }
        try {
            new MailMsg((Preferences)this.setup).sendMessage(new MailTaskSessionsRecalculator().setModuleId(this.mid).setRecipients(this.email).setSubject("DialUP recalculate result").addTextPart("text", this.report.toString()));
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }
}

