/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.detail;

import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowSelector;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.inet.IpRange;

public class InetFlowSelector
implements FlowSelector {
    final long timeFrom;
    final long timeTo;
    private final Set<Integer> ifaces;
    private final byte[] addressFrom;
    private final byte[] addressTo;
    private final byte[] prefix;
    private final short prefixLength;
    private final List<IpNet> routeNetList;
    private final int deltaTimeZone;

    public InetFlowSelector(long timeFrom, long timeTo, Set<Integer> ifaces, byte[] addressFrom, byte[] addressTo, byte[] prefix, short prefixLength, List<IpNet> routeNetList, int deltaTimeZone) {
        this.timeFrom = timeFrom;
        this.timeTo = timeTo;
        if (ifaces != null && (ifaces.size() == 0 || ifaces.contains(-1))) {
            ifaces = null;
        }
        this.ifaces = ifaces;
        this.addressFrom = addressFrom;
        this.addressTo = addressTo;
        this.prefix = prefix;
        this.prefixLength = prefixLength;
        if (routeNetList != null && routeNetList.size() == 0) {
            routeNetList = null;
        }
        this.routeNetList = routeNetList;
        this.deltaTimeZone = deltaTimeZone;
    }

    public FlowSelector.Result test(long hour, Data flow) {
        IpNet net;
        int i;
        int size;
        long timestamp = flow.getMilliseconds() + (long)this.deltaTimeZone;
        if (timestamp < this.timeFrom || timestamp > this.timeTo) {
            return RESULT_ERROR;
        }
        if (this.ifaces == null || this.ifaces.contains(flow.getOutputInterface())) {
            if (this.addressFrom == null && this.prefix == null) {
                return RESULT_OK_IN;
            }
            byte[] dstAddress = flow.getDstIpAddress().address;
            if (this.addressFrom != null && this.addressFrom.length == dstAddress.length && (this.addressTo == null ? IpAddress.equals((byte[])this.addressFrom, (byte[])dstAddress) : IpRange.inRange((byte[])dstAddress, (byte[])dstAddress, (byte[])this.addressFrom, (byte[])this.addressTo))) {
                return RESULT_OK_IN;
            }
            if (this.prefix != null && this.prefix.length == dstAddress.length && IpNet.inNet((byte[])dstAddress, (byte[])this.prefix, (int)this.prefixLength)) {
                return RESULT_OK_IN;
            }
            if (this.routeNetList != null) {
                size = this.routeNetList.size();
                for (i = 0; i < size; ++i) {
                    net = this.routeNetList.get(i);
                    if (!net.inNet(dstAddress)) continue;
                    return RESULT_OK_IN;
                }
            }
        }
        if (this.ifaces == null || this.ifaces.contains(flow.getInputInterface())) {
            if (this.addressFrom == null && this.prefix == null) {
                return RESULT_OK_OUT;
            }
            byte[] srcAddress = flow.getSrcIpAddress().address;
            if (this.addressFrom != null && this.addressFrom.length == srcAddress.length && (this.addressTo == null ? IpAddress.equals((byte[])this.addressFrom, (byte[])srcAddress) : IpRange.inRange((byte[])srcAddress, (byte[])srcAddress, (byte[])this.addressFrom, (byte[])this.addressTo))) {
                return RESULT_OK_OUT;
            }
            if (this.prefix != null && this.prefix.length == srcAddress.length && IpNet.inNet((byte[])srcAddress, (byte[])this.prefix, (int)this.prefixLength)) {
                return RESULT_OK_IN;
            }
            if (this.routeNetList != null) {
                size = this.routeNetList.size();
                for (i = 0; i < size; ++i) {
                    net = this.routeNetList.get(i);
                    if (!net.inNet(srcAddress)) continue;
                    return RESULT_OK_OUT;
                }
            }
        }
        return RESULT_ERROR;
    }
}

