<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:common="http://common.bitel.ru">
	<xsl:import href="layout.xsl" />
	<xsl:template name="title">
		<xsl:choose>
			<xsl:when test="data/@action = 'HD'">
				Управление зонами
			</xsl:when>
			<xsl:when test="data/@action = 'ZoneParams'">
				Параметры зоны
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="head">
	<script language="javascript" type="text/javascript" src="js/ru.bitel.bgbilling.modules.hd.js">
	</script>
	<xsl:text disable-output-escaping="yes">
	<![CDATA[
	<style TYPE="text/css" TITLE="hd style">
	<!--
		@media screen,print
		{
			a.s { color: #0056a2; font-family: Arial; text-decoration: underline;font-size: 12px; padding-bottom: 20px;padding-left: 10px; padding-top: 0px; }
			a:hover { color: #269AF0; text-decoration: underline; } 
			a:visited { color: #0056a2; text-decoration: underline; }
			div.template
			{
				font-family: Arial;
				font-size: 12px;
				padding-bottom: 10px;
				padding-left: 20px;
				padding-top: 12px;
			}
			div.divZone
			{
				font-family: Arial;
				font-size: 14px;
				padding-bottom: 0px;
				padding-left: 20px;
				padding-top: 15px;
			}
			div.divText
			{
				font-family: Arial;
				font-size: 12px;
				padding-bottom: 0px;
				padding-left: 10px;
				padding-top: 5px;
			}	
			table.r
			{
				border-collapse:separate;
	  			border-spacing:15px 3px;
	  			text-align: left;
			}
			input.p
			{
				width:300px;
			}
			label,input.di { display:block; }
			label
			{
				font-family: Arial;
				font-size: 10px;
				padding-top: 10px;
			}
			fieldset { padding:0; border:0; margin-top:25px; }
			.ui-dialog .ui-state-error { padding: .3em; }
			.validateTips { border: 1px solid transparent; padding: 0.3em; }
			select
			{
				text-align:center;
			}
		}
	-->
	</style>    
	
	    ]]>
	</xsl:text>
	</xsl:template>
	
	<xsl:template match="/data">
	<div id="hdZoneList" class="report">
		<!-- список зон -->
	</div>
	<div id="hdZoneTitle"
		style="font-family: Arial;font-size: 14px;padding-bottom: 10px;padding-left: 10px; padding-top: 12px;">
		<!-- Название зоны и ссылки -->
	</div>
	<div id="hdInfoZone">
		<!-- ns servers -->
		<!-- soa -->
		<!-- records -->
	</div>
	<div id="hdSoaZone">
		<div class="template">
			<b>SOA:</b>
			<form id="hdSoaForm" method="post" action="{$WEBEXECUTER}">
				<input type="hidden" id="module" name="module" value=""/>
				<input type="hidden" id="mid" name="mid" value=""/>
				<input type="hidden" name="action" value="SaveZoneSOAParams" />
				<input type="hidden" id="zoneId" name="zoneId" value='' />
				<input type="hidden" id="ct" name="ct" value='' />
				<table border="0" cellspacing="0">
					<tr>
						<td>TTL</td>
						<td>
							<input type="text" name="soa.ttl" value='' />
						</td>
						<td>
							<font class="info" id="qwe">
								Допустимое время хранения данной ресурсной записи в кэше
								неответственного DNS-сервера.
								<br />
								Рекомендуемое значение
								<span id="ttlDef"/>
							</font>
						</td>
					</tr>
					<tr>
						<td>Person</td>
						<td>
							<input type="text" name="soa.person" value='' />
						</td>
						<td>
							<font class="info">
								Электронной адрес сотрудника, ответственного за домен.
								<br />
								Рекомендуемое значение
								<span id="personDef"/>
							</font>
						</td>
					</tr>
					<tr>
						<td>Serial</td>
						<td>
							<input type="text" name="soa.serial" value='' />
						</td>
						<td>
							<font class="info">
								Серийный номер обновляется автоматически при любом изменении
								файлов зоны.Используется для синхронизации вторичных серверов.
								<br />
								Рекомендуемое значение
								<span id="serialDef"/>
							</font>
						</td>
					</tr>
					<tr>
						<td>Refresh</td>
						<td>
							<input type="text" name="soa.refresh" value='' />
						</td>
						<td>
							<font class="info">
								Интервал, в течение которого вторичный сервер проверяет
								обновления зон.
								<br />
								Рекомендуемое значение
								<span id="refreshDef"/>
							</font>
						</td>
					</tr>
					<tr>
						<td>Retry</td>
						<td>
							<input type="text" name="soa.retry" value='' />
						</td>
						<td>
							<font class="info">
								Время ожидания вторичного сервера после неудачной попытки
								загрузки БД зоны.
								<br />
								Рекомендуемое значение
								<span id="retryDef"/>
							</font>
						</td>
					</tr>
					<tr>
						<td>Expire</td>
						<td>
							<input type="text" name="soa.expire" value='' />
						</td>
						<td>
							<font class="info">
								Период, в течение которого информация зоны на вторичном сервере
								действительна.
								<br />
								Рекомендуемое значение
								<span id="expireDef"/>
							</font>
						</td>
					</tr>
					<tr>
						<td>Minimum</td>
						<td>
							<input type="text" name="soa.minimum" value='' />
						</td>
						<td>
							<font class="info">
								Минимальное время жизни кэшированных записей на вторичном
								сервере.
								<br/>
								Рекомендуемое значение
								<span id="minimumDef"/>
							</font>
						</td>
					</tr>
				</table>
				<div>
					<input type="button" value="Сохранить" onClick="saveSOAParams()" />
				</div>
			</form>
		</div>
	</div>
	<div id="hdRecordsZone">
		<div class="template">
			<div>
				<div id="addNewRecordZone" >
						Добавить новую запись: <br/>
						<select id="type" name="type" onchange="discription();"></select>
						<input type="button" value="Добавить" onclick="showEditor(-1,'add')"/>
				</div>
				<div id="hl">
					<div id="A" style="display:block; padding-left: 10px;">
						<font class="info">
							Запись типа A позволяет установить соответствие между именем хоста в домене и его IP-адресом.<br/>
							<b>Формат записи: имя_хоста    [TTL]    A    IP-адрес,</b> где TTL необязательный параметр.<br/>
							Пример: <i>info.test.ru    86400    A    194.85.61.44</i>
						</font>
					</div>
					<div id="AAAA" style="display:none; padding-left: 10px;">
						<font class="info">
							Запись типа A позволяет установить соответствие между именем хоста в домене и его IP-адресом протокола IPv6.<br/>
							<b>Формат записи: имя_хоста    [TTL]    AAAA    IP-адрес,</b> где TTL необязательный параметр.<br/>
							Пример: <i>k.test-dervice.ru    86400    AAAA    2001:7fd::1</i>
						</font>
					</div>
					<div id="MX" style="display:none; padding-left: 10px;">
						<font class="info">
							Запись типа MX (Mail Exchange - почтовый сервер) определяет почтовый сервер - машину,<br/>
							которая обрабатывает почту для вашего домена.<br/>
							<b>Формат записи: доменное_имя    [TTL]    MX    приоритет    почтовый сервер,</b>где TTL необязательный параметр.<br/>
							Пример: <i> test.ru.    86400    MX    10    relay2.test.ru.</i>
						</font>
					</div>
					<div id="CNAME" style="display:none; padding-left: 10px;">
						<font class="info">
							Запись типа CNAME (Canonical Name - Каноническое имя) позволяют присваивать хосту мнемонические имена.<br/>
							Мнемонические имена, или псевдонимы, широко применяются для связывания с хостом какой-либо функции,<br/>
							либо просто для сокращения имени.<br/>
							<b>Другие записи для данного хоста должны ссылаться на его реальное (каноническое) имя, а не на мнемоническое!</b> 
							<b>Формат записи: мнемоимя    [TTL]    CNAME    имя_хоста, </b>где TTL необязательный параметр.<br/>
							Пример: <i>ftp.test.ru.     86400    CNAME    arhive.test.ru.</i> 
						</font>
					</div>
					<div id="NS" style="display:none; padding-left: 10px;">
						<font class="info">
							Записи типа NS (Name Server - cервер имен) описывают DNS-серверы для данного домена.<br/>
							Количество записей типа NS в файле зоны должно точно соответствовать количеству DNS-серверов,<br/>
							обслуживающих домен и включать все DNS-серверы, указанные в домене.<br/>
							<b>Формат записи: доменное_имя    [TTL]    NS    имя_хоста, </b>где TTL необязательный параметр.<br/>
							Пример: <i>test.ru.    86400    NS    ns3.test.ru.</i>
						</font>
					</div>
					<div id="PTR" style="display:none; padding-left: 10px;">
						<font class="info">
							Записи типа PTR (Pointer - указатель) служат для выполнения обратного преобразования IP-адресов в имена хостов.<br/>
							Для каждого сетевого интерфейса хоста рекомендуется создать запись PTR.<br/>
							<b>Формат записи: адрес    [TTL]    PTR    имя_хоста, </b>где TTL необязательный параметр.<br/>
							Пример: <i>42.61.85.194.in-addr.arpa.    86400    PTR    www.my-domain-name.ru.</i>
						</font>
					</div>
					<div id="TXT" style="display:none; padding-left: 10px;">
						<font class="info">
							Запись типа TXT обычно используется для текстового описания доменного имени.<br/>
							<b>Формат записи: имя   [TTL]   TXT   текст,</b>где TTL необязательный параметр.<br/>
							Пример: <i>test.ru.      TXT   "the domain for RU-CENTER services testing"</i>
						</font>
					</div>
				</div>
			</div>
			
			<div id="records" style="max-height:450px;overflow-y:auto;padding-top: 10px;"></div>


			<div id="dialog-form" title="Редактор записи зоны">
				<p  id="tips" class="validateTips"></p>
					<fieldset>
						<form method="post" action="{$WEBEXECUTER}" id="hdEditRecordForm" >
							<input type="hidden" id="module" name="module" value=""/>
							<input type="hidden" id="mid" name="mid" value=""/>
							<input type="hidden" id="action" name="action" value="" />
							<input type="hidden" id="zoneId" name="zoneId" value='' />
							<input type="hidden" id="ct" name="ct" value='' />
							<input type="hidden" id="recordId" name="recordId" value=''/>
							<input type="hidden" id="typeString" name="typeString" value='' />
					
							<label for="param1">Параметр 1</label>
							<input type="text" name="param1" id="param1" class="text ui-widget-content ui-corner-all di" style="width:500px;" />
							<label for="type">Тип</label>
							<select name="type" id="type" value="" disabled="true" style="width:500px;" />
							<label for="param2">Парметр 2</label>
							<textarea name="param2" id="param2" value="" class="text ui-widget-content ui-corner-all di" style="height:90px; width:500px;" />
						</form>
					</fieldset>
			</div>
			
			<form method="post" action="{$WEBEXECUTER}" id="hdDeleteRecordForm" >
				<input type="hidden" id="module" name="module" value=""/>
				<input type="hidden" id="mid" name="mid" value=""/>
				<input type="hidden" id="action" name="action" value="" />
				<input type="hidden" id="zoneId" name="zoneId" value='' />
				<input type="hidden" id="ct" name="ct" value='' />
				<input type="hidden" id="recordId" name="recordId" value=''/>
			</form>
		</div>
	</div>
	<div id="hdBackButton" >
		<input type="button" value="Назад" onClick="getTopicList()"/>
	</div>
	</xsl:template>
</xsl:stylesheet>
