/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server;

import bitel.billing.server.BGPaymentModule;
import bitel.billing.server.ModuleBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMethod;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMode;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.assist.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.assist.server.event.worker.AssistAutopaymentEventWorker;
import ru.bitel.bgbilling.modules.assist.server.event.worker.AssistCheckEventWorker;
import ru.bitel.bgbilling.modules.assist.server.service.AssistServiceImpl;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.jmx.MBeanPaymentModule;

@BGPaymentModule
public class Module
extends ModuleBase
implements MBeanPaymentModule {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.assist.server"};
    final String[] loggerName = new String[]{Module.class.getName(), TransactionManager.class.getName(), AssistServiceImpl.class.getName()};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void start(Connection con, BGModule module) throws BGException {
        this.registerMBean(module);
        new AssistCheckEventWorker(Setup.getSetup(), module.getId());
        new AssistAutopaymentEventWorker(Setup.getSetup(), module.getId());
    }

    public void moduleAction(ServerContext ctx, int mid, Event event) throws SQLException {
        ContractDeleteEvent cdEvent;
        if (event instanceof ContractDeleteEvent && !(cdEvent = (ContractDeleteEvent)event).isCheck()) {
            String cidStr = String.valueOf(event.getContractId());
            ServerUtils.deleteRowsFromTable((Connection)ctx.getConnection(), (String)("assist_payment_" + mid), (String)"cid", (String)cidStr, null);
        }
    }

    public void serializeContract(Connection con, int cid, int mid, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("assist_payment_" + mid), (String)"cid", (String)String.valueOf(cid), null, (boolean)false, null, null);
    }

    public List<PaymentMethod> getPaymentMethods(int moduleId) {
        ArrayList<PaymentMethod> methods = new ArrayList<PaymentMethod>();
        if (Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)).getBoolean("assist.sbp.enable", false)) {
            methods.add(PaymentMethod.SBP);
        }
        methods.add(PaymentMethod.CARD);
        return methods;
    }

    public PaymentMode getPaymentMode() {
        return PaymentMode.FORM;
    }

    public String[] getLoggerNames() {
        return this.loggerName;
    }
}

