/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.email.server.bean.ContractPermition;
import ru.bitel.bgbilling.modules.email.server.bean.DomainManager;
import ru.bitel.bgbilling.modules.email.server.bean.ForwardManager;
import ru.bitel.bgbilling.modules.email.server.bean.WebPermition;
import ru.bitel.bgbilling.modules.email.server.bean.WebPermitionManager;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class EmailUtils {
    private static Logger logger = LoggerFactory.getLogger(EmailUtils.class);

    public static boolean checkForwardEmail(String email, ParameterMap moduleSetup) {
        boolean result = true;
        String regexp = moduleSetup.get("email.forward.regexp", "^[\\w]{4,20}@[\\.\\w]{5,20}$");
        try {
            Pattern pattern = Pattern.compile(regexp);
            result = pattern.matcher(email).find();
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public static boolean checkAccountName(String name, ParameterMap moduleSetup) {
        boolean result = true;
        String regexp = moduleSetup.get("email.account.regexp", "^[\\w]{4,20}$");
        try {
            Pattern pattern = Pattern.compile(regexp);
            result = pattern.matcher(name).find();
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public static ContractPermition getCurrentPermition(int moduleId, int contractId, Account account, Connection con, ParameterMap moduleSetup) {
        ContractPermition contractPermition = new ContractPermition();
        WebPermitionManager webPermitionManager = new WebPermitionManager(con, moduleId, moduleSetup);
        WebPermition webPermition = webPermitionManager.getPermition(contractId);
        AccountManager accountManager = new AccountManager(con, moduleId);
        List<Account> accountList = accountManager.getContractAccountList(contractId);
        if (webPermition.create && (webPermition.maxCreate == 0 || webPermition.maxCreate > accountList.size())) {
            contractPermition.create = true;
        }
        if (webPermition.delete) {
            contractPermition.delete = true;
        }
        if (account != null) {
            int forwardCount = new ForwardManager(con, moduleId).getForwardCount(account.getId());
            if (webPermition.forward && (webPermition.maxForward == 0 || webPermition.maxForward > forwardCount)) {
                contractPermition.forward = true;
            }
        }
        return contractPermition;
    }

    public static void deleteAccount(Account account, DomainManager domainManager, AccountManager accountManager) throws BGException {
        if (account != null) {
            try {
                Domain domain = domainManager.get(account.getDomainId());
                if (domain != null) {
                    if (TimeUtils.dateInRange((Date)new Date(), (Date)account.getDate1(), (Date)account.getDate2())) {
                        domainManager.getServiceActivator(domain).cancel(account);
                    }
                    accountManager.deleteAccount(account.getId());
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

