/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.radius;

import bitel.billing.server.processor.NASSession;
import bitel.billing.server.processor.ipn.IPNSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.AccountingSession;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.modules.ipn.server.radius.IPNNas;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.Utils;

public class IPNNasConnection
extends NasConnection<IPNSession> {
    private static final Logger logger = LogManager.getLogger();

    public IPNNasConnection(IPNSession session, DefaultServerSetup setup, NasList<? extends NasConnection<?>, ? extends Nas<? extends NasConnection<?>, ?, ?>> nasList, int nasId) {
        super((AccountingSession)session, setup, nasList, nasId);
    }

    public synchronized void startConnection(IPNNas nas, RadiusPacket request) {
        NASSession session = (NASSession)this.getSession();
        try {
            if (this.getStatus() == NasConnection.Status.waiting) {
                if (request != null) {
                    String sessionId = request.getStringAttribute(-1, 44, null);
                    session.setAcctSessionId(sessionId != null ? sessionId : "UNDEF");
                    int ip = request.getIntAttribute(-1, 8, Integer.valueOf(0));
                    if (ip != 0) {
                        session.setIpAddress(Utils.unsignedIntToLong((int)ip));
                    }
                }
                this.setStatus(NasConnection.Status.working);
            } else {
                logger.warn("Duplicate start!!!");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

