/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.utils;

import bitel.billing.server.admin.resource.bean.NumberResource;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.load.bean.Source;
import bitel.billing.server.load.bean.SourceManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerEmployee;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.sorm.common.ConnectionStandard;
import ru.bitel.bgbilling.modules.sorm.common.JSONSerializationUtils;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.Bunch;
import ru.bitel.bgbilling.modules.sorm.common.bean.InstalledInstanceModule;
import ru.bitel.bgbilling.modules.sorm.common.bean.ServiceSorm;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.bgbilling.modules.sorm.server.bean.DialUpLogin;
import ru.bitel.bgbilling.modules.sorm.server.bean.DialUpNAS;
import ru.bitel.bgbilling.modules.sorm.server.bean.InternalUser;
import ru.bitel.bgbilling.modules.sorm.server.bean.NumberRange;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormCSVWriter;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormContract;
import ru.bitel.bgbilling.modules.sorm.server.mail.MailSendError;
import ru.bitel.bgbilling.modules.sorm.server.service.SormServiceImpl;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUploadHelper;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUploadLogsTable;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDeviceType;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneResourceSubscription;
import ru.bitel.oss.systems.inventory.resource.common.service.PhoneResourceService;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;

public final class SormUtils {
    private static final Logger logger = LogManager.getLogger();
    public static final String PARAMETER_KEY_REGION = "region";
    public static final String PARAMETER_KEY_ZONE = "zone";
    public static final char CSV_SEPARATOR = ';';

    public static synchronized List<SormContract> getUploadContracts(Upload uploadImplementation, boolean forFullUpload) {
        ArrayList<SormContract> result = new ArrayList<SormContract>();
        Connection con = uploadImplementation.getConnection();
        int sormModuleId = uploadImplementation.getModuleId();
        int lastUploadContractId = -1;
        if (!forFullUpload) {
            lastUploadContractId = SormUtils.getLastUploadContractId(con, sormModuleId, uploadImplementation.getSormProject().getId());
        }
        String selectedModules = uploadImplementation.getConfig().get("sorm.upload.modules");
        String query = sormModuleId == 250 ? "SELECT c.id, c.title, c.fc, c.date1, c.date2, c.status, c.scid FROM contract AS c LEFT JOIN contract_module AS cmod ON c.id=cmod.cid WHERE (c.date1>=? OR ( c.date1 <= ? AND (c.date2 is null OR c.date2 >=?))) AND cmod.mid IN(" + selectedModules + ")" : "SELECT c.id, c.title, c.fc, c.date1, c.date2, c.status, c.scid FROM contract AS c LEFT JOIN contract_module AS cmod ON c.id=cmod.cid WHERE (c.date1>=? OR ( c.date1 <= ? AND (c.date2 is null OR c.date2 >=?))) AND cmod.mid IN(" + selectedModules + ") AND c.id IN (SELECT c.id FROM contract as c LEFT JOIN contract_module AS cmod ON c.id=cmod.cid WHERE cmod.mid=" + sormModuleId + ")";
        if (lastUploadContractId > 0) {
            query = query + " AND c.id>" + lastUploadContractId;
        }
        query = query + " group by c.id";
        try (PreparedStatement ps = con.prepareStatement(query);){
            int index = 1;
            Calendar cal = Calendar.getInstance();
            cal.add(1, -3);
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)cal));
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)cal));
            ps.setDate(index, TimeUtils.convertCalendarToSqlDate((Calendar)cal));
            logger.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + ps);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(SormUtils.getSormContractFromRS(rs));
                }
            }
            logger.debug("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438=" + result.size());
            if (!uploadImplementation.isFullUpload()) {
                result.addAll(SormUtils.getChangedContracts(con, sormModuleId).stream().filter(cc -> !result.contains(cc)).toList());
                logger.debug("\u041f\u043e\u0441\u043b\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0451\u043d\u043d\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432. \u041e\u0431\u0449\u0435\u0435 \u043a\u043e\u043b-\u0432\u043e=" + result.size());
            }
        }
        catch (SQLException ex) {
            logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u043f\u0438\u0441\u043a\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438. \u041e\u0448\u0438\u0431\u043a\u0430: " + ex.getMessage());
        }
        return result;
    }

    public static synchronized List<SormContract> getUploadContracts(Upload uploadImplementation) {
        return SormUtils.getUploadContracts(uploadImplementation, uploadImplementation.isFullUpload());
    }

    private static List<SormContract> getChangedContracts(Connection con, int sormModuleId) throws SQLException {
        ArrayList<SormContract> result;
        block14: {
            result = new ArrayList<SormContract>();
            String tableName = SormUploadLogsTable.getSormChangedContractTable(sormModuleId);
            if (ServerUtils.tableExists((Connection)con, (String)tableName)) {
                String query = "SELECT c.id, c.title, c.fc, c.date1, c.date2, c.status, c.scid FROM " + tableName + " AS chan LEFT JOIN contract AS c ON chan.contractId=c.id GROUP BY c.id";
                try (Statement statement = con.createStatement();
                     ResultSet rs = statement.executeQuery(query);){
                    while (rs.next()) {
                        result.add(SormUtils.getSormContractFromRS(rs));
                    }
                    break block14;
                }
            }
            logger.warn("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u0441 \u0438\u0437\u043c\u0435\u043d\u0451\u043d\u043d\u044b\u043c\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\u043c\u0438 \u0434\u043b\u044f \u0438\u043d\u043a\u0440\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0421\u041e\u0420\u041c \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442! tableName=" + tableName);
        }
        return result;
    }

    private static SormContract getSormContractFromRS(ResultSet rs) throws SQLException {
        int scid = rs.getInt("c.scid");
        return new SormContract(rs.getInt("c.id"), rs.getString("c.title"), TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("c.date1")), TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("c.date2")), rs.getInt("c.fc") == 0, rs.getInt("c.status"), scid > 0, scid);
    }

    public static void clearChangedContractsTable(Connection con, int moduleId) {
        String tableName = SormUploadLogsTable.getSormChangedContractTable(moduleId);
        if (ServerUtils.tableExists((Connection)con, (String)tableName)) {
            try (PreparedStatement ps = con.prepareStatement("DELETE FROM " + tableName + " WHERE id>0");){
                ps.executeUpdate();
                if (logger.isDebugEnabled()) {
                    logger.debug("\u041e\u0447\u0438\u0441\u0442\u0438\u043b\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u0443 \u0438\u0437\u043c\u0435\u043d\u0451\u043d\u043d\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex);
            }
        }
    }

    public static int getLastUploadContractId(Connection con, int sormModuleId, int sormProjectId) {
        String contractLogUploadTable = SormUploadLogsTable.getContractLogUploadTable(sormModuleId);
        String contractLogUploadTableCreateQuery = SormUploadLogsTable.getContractLogUploadCreateQuery(sormModuleId);
        int lastUploadContractId = -1;
        String query = "SELECT contractId FROM " + contractLogUploadTable + " WHERE sormProjectId=? ORDER BY contractId DESC LIMIT 1";
        try (PreparedStatement ps = con.prepareStatement(query);){
            ServerUtils.checkTable((Connection)con, (String)contractLogUploadTable, (String)contractLogUploadTableCreateQuery);
            ps.setInt(1, sormProjectId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                lastUploadContractId = rs.getInt("contractId");
            }
            rs.close();
            if (logger.isDebugEnabled()) {
                logger.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430. \u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0439: " + lastUploadContractId);
            }
        }
        catch (SQLException ex) {
            logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0432\u0437\u044f\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440: " + ex);
        }
        return lastUploadContractId;
    }

    public static void updateContractLogTable(Upload uploadImplementation) throws SQLException {
        Connection con = uploadImplementation.getConnection();
        int lastUploadCid = uploadImplementation.getContracts().get(uploadImplementation.getContracts().size() - 1).getContractId();
        int sormProjectId = uploadImplementation.getSormProject().getId();
        if (lastUploadCid <= 0) {
            return;
        }
        int moduleId = uploadImplementation.getModuleId();
        String contractLogUploadTable = SormUploadLogsTable.getContractLogUploadTable(moduleId);
        ServerUtils.checkTable((Connection)con, (String)contractLogUploadTable, (String)SormUploadLogsTable.getContractLogUploadCreateQuery(moduleId));
        String logQuery = "INSERT INTO " + contractLogUploadTable + " (contractId, sormProjectId) values (?,?)";
        try (PreparedStatement statement = con.prepareStatement(logQuery);){
            statement.setInt(1, lastUploadCid);
            statement.setInt(2, sormProjectId);
            statement.executeUpdate();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0434\u043b\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u0421\u041e\u0420\u041c: " + sormProjectId + " ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + lastUploadCid);
        }
    }

    public static void clearContractLogTable(Connection con, int sormProjectId, int sormModuleId) throws BGException {
        block8: {
            String contractLogUploadTable = SormUploadLogsTable.getContractLogUploadTable(sormModuleId);
            try {
                if (!ServerUtils.tableExists((Connection)con, (String)contractLogUploadTable)) break block8;
                String query = "DELETE FROM " + contractLogUploadTable + " WHERE sormProjectId=" + sormProjectId;
                try (Statement st = con.createStatement();){
                    st.executeUpdate(query);
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public static Map<Integer, List<InetServ>> getPairsAbonentInetServicesByContractIds(Preferences config, List<Integer> contracts, ServerContext serverContext) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430 \u0438 \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u043c\u043e\u0434\u0443\u043b\u044f \u0438\u043d\u0435\u0442 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430");
        }
        HashMap<Integer, List<InetServ>> result = new HashMap<Integer, List<InetServ>>();
        List<Integer> selectedInetModulesToUpload = SormUtils.getSelectedInetModulesToUpload(config);
        if (logger.isDebugEnabled()) {
            logger.debug("\u0412\u0441\u0435\u0433\u043e \u043c\u043e\u0434\u0443\u043b\u0435\u0439 inet \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + selectedInetModulesToUpload.size());
            logger.debug("\u041a\u043e\u043b-\u0432\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: " + contracts.size());
        }
        for (Integer mid : selectedInetModulesToUpload) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u041f\u0440\u043e\u0446\u0435\u0441\u0441 \u043f\u043e\u0438\u0441\u043a\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u043f\u043e \u043c\u043e\u0434\u0443\u043b\u044e \u0418\u043d\u0435\u0442 ID=" + mid);
            }
            InetServService inetServService = (InetServService)serverContext.getService(InetServService.class, mid.intValue());
            for (Integer cid : contracts) {
                ArrayList<InetServ> abonentServices = new ArrayList<InetServ>();
                for (InetServ serv : inetServService.inetServList(cid.intValue(), null)) {
                    if (serv.getDateFrom() != null && serv.getDateFrom().after(new Date()) || serv.getDateTo() != null && !SormUtils.checkThreeYearsAgo(serv.getDateTo()) || serv.getParentId() > 0) continue;
                    abonentServices.add(serv);
                }
                if (!Utils.notEmptyCollection(abonentServices)) continue;
                result.put(cid, abonentServices);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u0412\u0441\u0435\u0433\u043e \u043f\u0440\u0438\u0432\u044f\u0437\u043e\u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u043a \u0441\u043f\u0438\u0441\u043a\u0430\u043c \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432= " + result.size());
        }
        return result;
    }

    public static Map<Integer, List<VoiceAccount>> getPairsAbonentVoiceAccountsByContractIds(Preferences config, List<Integer> contractIds, ServerContext serverContext) throws Exception {
        HashMap<Integer, List<VoiceAccount>> result = new HashMap<Integer, List<VoiceAccount>>();
        Period period = new Period(new Date(), null);
        for (Integer voiceMid : SormUtils.getTelephoneModulesIds(config).get(UploadModulesTitle.VOICE.getTitleModule())) {
            VoiceAccountService accountService = (VoiceAccountService)serverContext.getService(VoiceAccountService.class, voiceMid.intValue());
            for (Integer contractId : contractIds) {
                List accounts = result.getOrDefault(contractId, new ArrayList());
                accounts.addAll(accountService.voiceAccountList(contractId.intValue(), 0, period));
                result.put(contractId, accounts);
            }
        }
        return result;
    }

    public static Map<Integer, List<InetServ>> getPairsAbonentInetServices(Preferences config, List<SormContract> contracts, ServerContext serverContext) throws Exception {
        return SormUtils.getPairsAbonentInetServicesByContractIds(config, contracts.stream().mapToInt(SormContract::getContractId).boxed().collect(Collectors.toList()), serverContext);
    }

    public static List<InetServ> getInetServices(Preferences preferences, ServerContext serverContext, List<SormContract> contractIds) throws Exception {
        ArrayList<InetServ> result = new ArrayList<InetServ>();
        if (logger.isDebugEnabled()) {
            logger.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u0435\u0439 inet'a");
        }
        for (Integer inetMid : SormUtils.getSelectedInetModulesToUpload(preferences)) {
            InetServService inetServService = (InetServService)serverContext.getService(InetServService.class, inetMid.intValue());
            for (SormContract contract : contractIds) {
                result.addAll(inetServService.inetServList(contract.getContractId(), null));
            }
        }
        return result;
    }

    public static List<Integer> getSelectedInetModulesToUpload(Preferences config) {
        List selectedUserModules = Utils.toIntegerList((String)config.get("sorm.upload.modules"));
        List<Integer> inetMids = new SormServiceImpl().getIdsInetModules();
        selectedUserModules.removeIf(m -> !inetMids.contains(m));
        return selectedUserModules;
    }

    public static List<Integer> getSelectedVoiceModulesToUpload(Preferences config) {
        List selectedUserModules = Utils.toIntegerList((String)config.get("sorm.upload.modules"));
        List<Integer> voiceMids = new SormServiceImpl().getIdsVoiceModules();
        selectedUserModules.removeIf(m -> !voiceMids.contains(m));
        return selectedUserModules;
    }

    public static List<Integer> getListIntegerFromConfigByKey(Preferences config, String key) {
        return Utils.toList((String)config.get(key)).stream().mapToInt(Integer::parseInt).boxed().collect(Collectors.toList());
    }

    public static List<Integer> getIdsServices(Preferences config) throws BGException {
        return SormUtils.getSelectedServicesForUpload(config).stream().mapToInt(ServiceSorm::getId).boxed().collect(Collectors.toList());
    }

    public static List<ServiceSorm> getSelectedServicesForUpload(Preferences config) {
        String services = config.get("sorm.upload.services", "");
        if (Utils.isBlankString((String)services)) {
            return Collections.emptyList();
        }
        return new ArrayList<ServiceSorm>(JSONSerializationUtils.convertJsonToList((String)services, ServiceSorm.class));
    }

    public static void sendErrorToEmail(Setup setup, Exception ex, String subject) {
        SormUtils.sendErrorToEmail(setup, ex, subject, null);
    }

    public static void sendErrorToEmail(Setup setup, Exception ex, String subject, String email) {
        if (Utils.isBlankString((String)email)) {
            email = setup.get("alarm.mail", null);
        }
        if (Utils.notBlankString((String)email)) {
            String exceptionAsString = BGException.printStackTraceToString((Throwable)ex);
            String msg = "\u041e\u0448\u0438\u0431\u043a\u0430: " + ex.getMessage() + "\n\u0421\u0442\u0435\u043a\u0442\u0440\u0435\u0439\u0441: \n" + exceptionAsString;
            try {
                MailSendError mailData = new MailSendError();
                mailData.setModuleId(-1);
                mailData.setRecipients(email);
                mailData.setSubject("\u041c\u043e\u0434\u0443\u043b\u044c \u0421\u041e\u0420\u041c. " + subject);
                mailData.addTextPart("text", msg);
                new MailMsg((Preferences)setup).sendMessage((MailData)mailData);
            }
            catch (Exception ex1) {
                logger.error((Object)ex1);
            }
        }
        logger.error(ex.getMessage(), (Throwable)ex);
    }

    public static String trimField(String value, int length) {
        if (Utils.notBlankString((String)value) && length > 0 && value.length() >= length) {
            value = value.substring(0, length);
        }
        return Utils.maskBlank((String)value, (String)"");
    }

    public static Path getUploadFile(String fileUploadPath, String filePrefix, String datePattern) {
        Path uploadFilePath = null;
        if (!((String)fileUploadPath).startsWith(File.separator)) {
            fileUploadPath = File.separator + (String)fileUploadPath;
        }
        if (((String)fileUploadPath).endsWith(File.separator)) {
            fileUploadPath = ((String)fileUploadPath).substring(0, ((String)fileUploadPath).length() - 1);
        }
        fileUploadPath = ((String)fileUploadPath).replaceAll(File.separator + File.separator, File.separator);
        try {
            String fileName = Utils.isBlankString((String)datePattern) ? filePrefix : SormUtils.getFileName(filePrefix, datePattern, datePattern.startsWith("%s"));
            String path = (String)fileUploadPath + File.separator + TimeUtils.format((Date)new Date(), (String)"dd.MM.yyyy") + File.separator + fileName;
            uploadFilePath = Paths.get(path, new String[0]);
            Files.deleteIfExists(uploadFilePath);
            Files.createDirectories(uploadFilePath.getParent(), new FileAttribute[0]);
            Files.createFile(uploadFilePath, new FileAttribute[0]);
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
        return uploadFilePath;
    }

    private static String getFileName(String prefix, String datePattern, boolean prefixIsInStartLine) {
        if (prefixIsInStartLine) {
            return String.format(datePattern, prefix, new Date(), new Date(), new Date(), new Date(), new Date(), new Date());
        }
        return String.format(datePattern, new Date(), new Date(), new Date(), new Date(), new Date(), new Date(), prefix);
    }

    public static String getAdminEmail(Preferences config) {
        return config.get("sorm.report.email", "");
    }

    public static SormCSVWriter getCSVFile(Path file) throws IOException {
        return SormUtils.getCSVFile(file, "UTF-8");
    }

    public static SormCSVWriter getCSVFile(Path file, String encoding) throws IOException {
        Charset charset = Charset.forName(encoding);
        return SormUtils.getCSVFile(file, charset, '\"');
    }

    public static SormCSVWriter getCSVFile(Path file, char quoteCharacter) throws IOException {
        return SormUtils.getCSVFile(file, StandardCharsets.UTF_8, quoteCharacter);
    }

    public static SormCSVWriter getCSVFile(Path path, Charset encoding, char quoteCharacter) throws IOException {
        return SormUtils.getCSVFile(path, encoding, quoteCharacter, ';');
    }

    public static SormCSVWriter getCSVFile(Path path, Charset charset, char quoteCharacter, char separator) throws IOException {
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(path.toFile()), charset);
        return new SormCSVWriter(fileWriter, separator == ' ' ? (char)';' : (char)separator, quoteCharacter);
    }

    public static List<Integer> getIdsModulesFromConfig(Preferences config, String subKey) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        SormUtils.getPairsMidsListIds(config, subKey).forEach((key, value) -> result.add((Integer)key));
        return result;
    }

    public static Map<Integer, List<Integer>> getPairsMidsListIds(Preferences preferences, String subKey) {
        Map map = preferences.subKeyed(subKey);
        HashMap<Integer, List<Integer>> result = new HashMap<Integer, List<Integer>>();
        if (map != null) {
            map.forEach((key, value) -> value.entrySet().forEach(parameter -> {
                int mid = Utils.parseInt((String)((String)parameter.getKey()));
                if (mid > 0) {
                    result.put(mid, Utils.toIntegerList((String)((String)parameter.getValue())));
                }
            }));
        }
        return result;
    }

    public static List<Device> getInetDevices(Preferences config, ServerContext serverContext) {
        Map<Integer, List<Integer>> idsDeviceForUpload = SormUtils.getPairsMidsListIds(config, "sorm.upload.switches");
        ArrayList<Device> listDevices = new ArrayList<Device>();
        SormUtils.getSelectedInetModulesToUpload(config).forEach(mid -> {
            List selectedIds = idsDeviceForUpload.getOrDefault(mid, Collections.emptyList());
            try {
                ArrayList<InetDevice> devices = new ArrayList<InetDevice>();
                InetDeviceService inetDeviceService = (InetDeviceService)serverContext.getService(InetDeviceService.class, mid.intValue());
                List typeList = inetDeviceService.deviceTypeList();
                for (InetDeviceType type : typeList) {
                    devices.addAll(inetDeviceService.inetDeviceList(type.getId()));
                }
                devices.removeIf(device -> !selectedIds.contains(device.getId()));
                listDevices.addAll(devices);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        });
        return listDevices;
    }

    public static List<DialUpNAS> getDialUpNasList(ServerContext serverContext, Preferences config, boolean isSwitches) throws BGException {
        Connection connection = serverContext.getConnection();
        SormService sormService = (SormService)serverContext.getService(SormService.class, serverContext.getModuleId());
        ArrayList<DialUpNAS> result = new ArrayList<DialUpNAS>();
        SormUtils.getSelectedDialUpNats(sormService, config, isSwitches).forEach((dialUpMid, selectedNases) -> {
            String query = "SELECT id, identifier, ipaddr, comment, date1, date2 FROM nas_" + dialUpMid + " WHERE id IN (" + Utils.toString((Iterable)selectedNases) + ")";
            try (Statement statement = connection.createStatement();
                 ResultSet rs = statement.executeQuery(query);){
                while (rs.next()) {
                    DialUpNAS nas = new DialUpNAS();
                    nas.setId(rs.getInt("id"));
                    nas.setTitle(rs.getString("identifier"));
                    nas.setComment(rs.getString("comment"));
                    nas.setIp(IPUtils.convertLongIpToString((long)rs.getLong("ipaddr")));
                    nas.setDateFrom(TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("date1")));
                    nas.setDateTo(TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("date2")));
                    result.add(nas);
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex);
            }
        });
        return result;
    }

    public static List<DialUpLogin> getDialUpLogins(ServerContext serverContext, Preferences config, List<SormContract> contracts) throws BGException {
        SormService sormService = (SormService)serverContext.getService(SormService.class, serverContext.getModuleId());
        Connection connection = serverContext.getConnection();
        ArrayList<DialUpLogin> logins = new ArrayList<DialUpLogin>();
        List cids = contracts.stream().mapToInt(SormContract::getContractId).boxed().collect(Collectors.toList());
        Map<Integer, List<Integer>> selected = SormUtils.getSelectedDialUpNats(sormService, config, true);
        selected.forEach((dialUpMid, nasList) -> {
            String query = "SELECT login.login, login.cid, login.date1, radius.ip, login.date2 FROM user_login_" + dialUpMid + " AS login LEFT JOIN radius_pair_ip_" + dialUpMid + " AS radius ON login.id=radius.id WHERE login.cid IN(" + Utils.toString((Iterable)cids) + ")";
            try (Statement statement = connection.createStatement();
                 ResultSet rs = statement.executeQuery(query);){
                while (rs.next()) {
                    DialUpLogin login = new DialUpLogin();
                    login.setCid(rs.getInt("login.cid"));
                    login.setDateFrom(TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("login.date1")));
                    login.setDateTo(TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("login.date2")));
                    login.setLogin(rs.getString("login.login"));
                    login.setIpv4(IPUtils.convertLongIpToString((long)rs.getLong("radius.ip")));
                    logins.add(login);
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex);
            }
        });
        return logins;
    }

    private static Map<Integer, List<Integer>> getSelectedDialUpNats(SormService sormService, Preferences config, boolean isSwitches) {
        List dialUpMids = sormService.getInstalledEthernetModules().stream().filter(module -> module.getTitleModule().equals(UploadModulesTitle.DIAL_UP.getTitleModule())).mapToInt(InstalledInstanceModule::getModuleId).boxed().collect(Collectors.toList());
        if (Utils.isEmptyCollection(dialUpMids)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<Integer>> selectedModules = new HashMap<Integer, List<Integer>>();
        if (isSwitches) {
            Map<Integer, List<Integer>> switches = SormUtils.getPairsMidsListIds(config, "sorm.upload.switches");
            switches.forEach((key, value) -> {
                if (dialUpMids.contains(key)) {
                    selectedModules.put((Integer)key, (List<Integer>)value);
                }
            });
        } else {
            Map<Integer, List<Integer>> gateways = SormUtils.getPairsMidsListIds(config, "sorm.upload.gateways");
            gateways.forEach((key, value) -> {
                if (dialUpMids.contains(key)) {
                    selectedModules.put((Integer)key, (List<Integer>)value);
                }
            });
        }
        return selectedModules;
    }

    public static Map<IpCategory, List<IpResource>> getIPResources(Preferences config, ServerContext serverContext) {
        HashMap<IpCategory, List<IpResource>> categoryWithResources = new HashMap<IpCategory, List<IpResource>>();
        Map<Integer, List<Integer>> idsCategoriesOfModule = SormUtils.getPairsMidsListIds(config, "sorm.upload.ipnumbering");
        List<Integer> inetMids = SormUtils.getSelectedInetModulesToUpload(config);
        inetMids.forEach(midInet -> {
            try {
                ResourceService resourceService = (ResourceService)serverContext.getService(ResourceService.class, midInet.intValue());
                List categories = resourceService.ipCategoryList();
                Map categoryIdsMap = categories.stream().collect(Collectors.toMap(Id::getId, Function.identity()));
                List categoryIds = categories.stream().map(Id::getId).collect(Collectors.toList());
                List selectedResourcesCategoriesInModule = (List)idsCategoriesOfModule.get(midInet);
                if (Utils.notEmptyCollection((Collection)selectedResourcesCategoriesInModule)) {
                    boolean uploadOnlySelectedCategories = config.get("sorm.upload.ipnumbering.inversion", "0").equals("1");
                    if (uploadOnlySelectedCategories) {
                        categoryIds.removeIf(category -> !selectedResourcesCategoriesInModule.contains(category));
                    } else {
                        categoryIds.removeAll(selectedResourcesCategoriesInModule);
                    }
                }
                categories.removeIf(c -> !categoryIds.contains(c.getId()));
                HashMap<Integer, List> idCategoryWithResources = new HashMap<Integer, List>();
                resourceService.ipResourceList(categoryIds).forEach(res -> {
                    ArrayList<IpResource> ipResourceList = (ArrayList<IpResource>)idCategoryWithResources.get(res.getCategoryId());
                    if (ipResourceList == null) {
                        ipResourceList = new ArrayList<IpResource>();
                    }
                    ipResourceList.add((IpResource)res);
                    idCategoryWithResources.put(res.getCategoryId(), ipResourceList);
                });
                idCategoryWithResources.forEach((idCategory, resourcesList) -> categoryWithResources.put((IpCategory)categoryIdsMap.get(idCategory), (List<IpResource>)resourcesList));
            }
            catch (Exception e) {
                logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u043f\u0438\u0441\u043a\u0430 ip-\u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: " + e.getMessage());
            }
        });
        return categoryWithResources;
    }

    public static List<Device> getVoiceDevices(Preferences config, ServerContext serverContext) {
        ArrayList<Device> voiceDevices = new ArrayList<Device>();
        List<InstalledInstanceModule> telephoneModules = new SormServiceImpl().getInstalledPhoneModules();
        SormUtils.getPairsMidsListIds(config, "sorm.upload.commutators").forEach((mid, listIds) -> {
            for (InstalledInstanceModule telephoneModule : telephoneModules) {
                if (!telephoneModule.getTitleModule().equals(UploadModulesTitle.VOICE.getTitleModule())) continue;
                try {
                    ArrayList<VoiceDevice> allVoiceDevices = new ArrayList<VoiceDevice>();
                    VoiceDeviceService voiceDeviceService = (VoiceDeviceService)serverContext.getService(VoiceDeviceService.class, mid.intValue());
                    List types = voiceDeviceService.deviceTypeList();
                    for (VoiceDeviceType type : types) {
                        allVoiceDevices.addAll(voiceDeviceService.deviceList(type.getId()));
                    }
                    allVoiceDevices.removeIf(d -> !listIds.contains(d.getId()));
                    voiceDevices.addAll(allVoiceDevices);
                }
                catch (Exception e) {
                    logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0441\u043f\u0438\u0441\u043a\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432 \u043c\u043e\u0434\u0443\u043b\u044f Voice: " + e.getMessage());
                }
            }
        });
        return voiceDevices;
    }

    public static List<Source> getPhoneSources(Preferences config, ServerContext context) {
        ArrayList<Source> result = new ArrayList<Source>();
        Map<Integer, List<Integer>> midsWithSelectedSources = SormUtils.getPairsMidsListIds(config, "sorm.upload.commutators");
        SourceManager sourceManager = new SourceManager(context.getConnection());
        List<InstalledInstanceModule> telephoneModules = new SormServiceImpl().getInstalledPhoneModules();
        SormUtils.getIdsModulesFromConfig(config, "sorm.upload.commutators").forEach(mid -> {
            for (InstalledInstanceModule phoneModule : telephoneModules) {
                if (!phoneModule.getTitleModule().equals(UploadModulesTitle.PHONE.getTitleModule())) continue;
                List sourceList = sourceManager.getSourceList(mid.intValue());
                List selectedSourceToUpload = (List)midsWithSelectedSources.get(mid);
                if (!Utils.notEmptyCollection((Collection)selectedSourceToUpload)) continue;
                sourceList.removeIf(source -> !selectedSourceToUpload.contains(source.getId()));
                result.addAll(sourceList);
            }
        });
        return result;
    }

    public static List<Device> getSelectedGateways(Preferences config, ServerContext serverContext) {
        ArrayList idsDevices = new ArrayList();
        SormUtils.getPairsMidsListIds(config, "sorm.upload.gateways").forEach((key, value) -> idsDevices.addAll(value));
        List<Integer> selectedInetModulesToUpload = SormUtils.getSelectedInetModulesToUpload(config);
        ArrayList<Device> devices = new ArrayList<Device>();
        SormUtils.getIdsModulesFromConfig(config, "sorm.upload.gateways").forEach(mid -> {
            if (selectedInetModulesToUpload.contains(mid)) {
                try {
                    InetDeviceService deviceService = (InetDeviceService)serverContext.getService(InetDeviceService.class, mid.intValue());
                    for (Integer idDevice : idsDevices) {
                        InetDevice device = deviceService.inetDeviceGet(idDevice.intValue());
                        if (device == null) continue;
                        devices.add((Device)device);
                    }
                }
                catch (Exception e) {
                    logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0441\u043f\u0438\u0441\u043a\u0430 \u0448\u043b\u044e\u0437\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: " + e.getMessage());
                }
            }
        });
        return devices;
    }

    public static List<Bunch> getBunches(Preferences config) {
        ArrayList<Bunch> result = new ArrayList<Bunch>();
        String bunches = config.get("sorm.upload.bunches");
        if (Utils.notBlankString((String)bunches)) {
            result.addAll(JSONSerializationUtils.convertJsonToList((String)bunches, Bunch.class));
        }
        return result;
    }

    public static List<NumberRange> getUploadVoiceNumberingResources(Preferences config, ServerContext serverContext) {
        ArrayList allResources = new ArrayList();
        List<Integer> selectedCategories = SormUtils.getVoiceNumberingCategoryNonUpload(config);
        boolean uploadOnlySelectedCategories = config.get("sorm.upload.phonenumbering.inversion", "0").equals("1");
        SormUtils.getTelephoneModulesIds(config).get(UploadModulesTitle.VOICE.getTitleModule()).forEach(voiceMid -> {
            try {
                PhoneResourceService resourceService = (PhoneResourceService)serverContext.getService(PhoneResourceService.class, voiceMid.intValue());
                List resources = resourceService.phoneResourceList(-1);
                if (uploadOnlySelectedCategories) {
                    resources.removeIf(category -> !selectedCategories.contains(category.getCategoryId()));
                } else {
                    resources.removeIf(category -> selectedCategories.contains(category.getCategoryId()));
                }
                allResources.addAll(resources);
            }
            catch (Exception e) {
                logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 Voice: " + e.getMessage());
            }
        });
        ArrayList<NumberRange> result = new ArrayList<NumberRange>();
        for (PhoneResource resource : allResources) {
            NumberRange numberRange = new NumberRange();
            numberRange.setDateFrom(resource.getDateFrom());
            numberRange.setDateTo(resource.getDateTo());
            numberRange.setFromNumber(resource.getPhoneFrom());
            numberRange.setToNumber(resource.getPhoneTo());
            numberRange.setComment(resource.getComment());
            result.add(numberRange);
        }
        return result;
    }

    public static List<NumberRange> getUploadPhoneNumberingResources(Preferences config, Connection connection) {
        ArrayList<Object> resourceList = new ArrayList();
        Map<Integer, List<Integer>> selectedCategories = SormUtils.getPairsMidsListIds(config, "sorm.upload.phonenumbering");
        boolean uploadOnlySelectedCategories = config.get("sorm.upload.phonenumbering.inversion", "0").equals("1");
        List<Integer> phoneMids = SormUtils.getIdsModulesFromConfig(config, "sorm.upload.phonenumbering");
        for (Integer phoneModule : phoneMids) {
            String tableName = ServerUtils.getModuleTableName((String)"number_resource", (int)phoneModule);
            if (!ServerUtils.tableExists((Connection)connection, (String)tableName)) continue;
            List<Integer> list = selectedCategories.get(phoneModule);
            Object sqlFilter = "";
            if (Utils.notEmptyCollection(list)) {
                sqlFilter = uploadOnlySelectedCategories ? " WHERE category_id IN(" + Utils.toString(list) + ")" : " WHERE category_id NOT IN(" + Utils.toString(list) + ")";
            }
            String query = "select id, date1, date2, number from " + (String)tableName + (String)sqlFilter + " order by id";
            try {
                Statement st = connection.createStatement();
                try {
                    ResultSet resultSet = st.executeQuery(query);
                    try {
                        while (resultSet.next()) {
                            NumberResource resource = new NumberResource();
                            resource.setId(resultSet.getInt("id"));
                            resource.setNumber(resultSet.getString("number"));
                            resource.setDateFrom((Date)resultSet.getDate("date1"));
                            resource.setDateTo((Date)resultSet.getDate("date2"));
                            resourceList.add(resource);
                        }
                    }
                    finally {
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                }
                finally {
                    if (st == null) continue;
                    st.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex);
            }
        }
        ArrayList<NumberRange> result = new ArrayList<NumberRange>();
        HashMap<String, NumberResource> uniqueNumbers = new HashMap<String, NumberResource>();
        for (NumberResource numberResource : resourceList) {
            NumberResource res = (NumberResource)uniqueNumbers.get(numberResource.getNumber());
            if (res == null) {
                uniqueNumbers.put(numberResource.getNumber(), numberResource);
                continue;
            }
            if (res.getDateFrom().compareTo(numberResource.getDateFrom()) <= 0) continue;
            uniqueNumbers.replace(numberResource.getNumber(), numberResource);
        }
        resourceList = new ArrayList(uniqueNumbers.values());
        resourceList.sort(Comparator.comparing(NumberResource::getNumber));
        Calendar minDateFrom = Calendar.getInstance();
        minDateFrom.add(1, 50);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -50);
        Date minDate = minDateFrom.getTime();
        Date maxDate = calendar.getTime();
        for (NumberResource numberResource : resourceList) {
            NumberResource secondNumber;
            Long num1;
            if (SormUtils.isInRange(result, numberResource.getNumber())) continue;
            Long num2 = num1 = Long.valueOf(Long.parseLong(numberResource.getNumber()));
            do {
                Long l = num2;
                num2 = num2 + 1L;
            } while ((secondNumber = (NumberResource)uniqueNumbers.get(String.valueOf(num2))) != null);
            if (numberResource.getDateFrom() != null && numberResource.getDateFrom().compareTo(minDate) < 0) {
                minDate = numberResource.getDateFrom();
            }
            if (numberResource.getDateTo() != null && numberResource.getDateTo().compareTo(maxDate) > 0) {
                maxDate = numberResource.getDateTo();
            }
            NumberRange range = new NumberRange();
            range.setFromNumber(num1);
            range.setToNumber(num2 - 1L);
            range.setDateFrom(minDate);
            range.setDateTo(maxDate);
            result.add(range);
        }
        return result;
    }

    private static boolean isInRange(List<NumberRange> numberRangeList, String number) {
        boolean result = false;
        try {
            Long n = Long.valueOf(number);
            for (NumberRange range : numberRangeList) {
                if (n < range.getFromNumber() || n > range.getToNumber()) continue;
                result = true;
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private static List<Integer> getVoiceNumberingCategoryNonUpload(Preferences config) {
        return SormUtils.getNumberingCategoryNonUpload(config, UploadModulesTitle.VOICE);
    }

    private static List<Integer> getPhoneNumberingCategoryNonUpload(Preferences config) {
        return SormUtils.getNumberingCategoryNonUpload(config, UploadModulesTitle.PHONE);
    }

    private static List<Integer> getNumberingCategoryNonUpload(Preferences config, UploadModulesTitle module) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<InstalledInstanceModule> installedModules = new SormServiceImpl().getInstalledPhoneModules();
        installedModules.removeIf(m -> !module.getTitleModule().equals(m.getTitleModule()));
        SormUtils.getPairsMidsListIds(config, "sorm.upload.phonenumbering").forEach((mid, listIds) -> {
            for (InstalledInstanceModule voiceModule : installedModules) {
                if (mid.intValue() != voiceModule.getModuleId()) continue;
                result.addAll((Collection<Integer>)listIds);
            }
        });
        return result;
    }

    public static Map<String, List<Integer>> getTelephoneModulesIds(Preferences config) {
        List selectedUserModules = Utils.toIntegerList((String)config.get("sorm.upload.modules"));
        List<InstalledInstanceModule> telephoneModules = new SormServiceImpl().getInstalledPhoneModules();
        telephoneModules.removeIf(module -> !selectedUserModules.contains(module.getModuleId()));
        HashMap<String, List<Integer>> result = new HashMap<String, List<Integer>>();
        List phoneMids = telephoneModules.stream().filter(module -> module.getTitleModule().equals(UploadModulesTitle.PHONE.getTitleModule())).mapToInt(InstalledInstanceModule::getModuleId).boxed().collect(Collectors.toList());
        List voiceMids = telephoneModules.stream().filter(module -> module.getTitleModule().equals(UploadModulesTitle.VOICE.getTitleModule())).mapToInt(InstalledInstanceModule::getModuleId).boxed().collect(Collectors.toList());
        List voiceIpMids = telephoneModules.stream().filter(module -> module.getTitleModule().equals(UploadModulesTitle.VOICE_IP.getTitleModule())).mapToInt(InstalledInstanceModule::getModuleId).boxed().collect(Collectors.toList());
        result.put(UploadModulesTitle.PHONE.getTitleModule(), phoneMids);
        result.put(UploadModulesTitle.VOICE.getTitleModule(), voiceMids);
        result.put(UploadModulesTitle.VOICE_IP.getTitleModule(), voiceIpMids);
        return result;
    }

    public static Map<Integer, List<PhoneResourceSubscription>> getVoiceModuleSubscriptionList(List<Integer> voiceModules, ServerContext context, Preferences config) {
        HashMap<Integer, List<PhoneResourceSubscription>> subscription = new HashMap<Integer, List<PhoneResourceSubscription>>();
        try {
            for (Integer voiceModule : voiceModules) {
                PhoneResourceService resourceService = (PhoneResourceService)context.getService(PhoneResourceService.class, voiceModule.intValue());
                List phoneResources = resourceService.phoneResourceList(-1);
                ArrayList subscriptionList = new ArrayList();
                LocalDate finalThreeYearsAgoDate = LocalDate.now().minusYears(3L);
                LocalDate futureDate = LocalDate.now().plusYears(100L);
                phoneResources.forEach(n -> {
                    try {
                        Date dateFrom = Date.from(finalThreeYearsAgoDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                        Date dateTo = Date.from(futureDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                        Result resourceSubscriptionResult = resourceService.phoneSubscriptionList(n.getId(), dateFrom, dateTo, new Page());
                        List list = resourceSubscriptionResult.getList();
                        subscriptionList.addAll(list);
                        subscription.put(voiceModule, subscriptionList);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043e\u0432 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432", SormUtils.getAdminEmail(config));
        }
        return subscription;
    }

    public static boolean checkThreeYearsAgo(Date dateTo) {
        if (dateTo == null) {
            return true;
        }
        Calendar threeYearAgo = Calendar.getInstance();
        threeYearAgo.add(1, -3);
        Date date = threeYearAgo.getTime();
        return dateTo.after(date);
    }

    public static List<Pair<Integer, List<Pair<String, Integer>>>> getAddressList(Preferences config, List<SormContract> contracts) {
        ArrayList<Pair<Integer, List<Pair<String, Integer>>>> result = new ArrayList<Pair<Integer, List<Pair<String, Integer>>>>();
        for (SormContract contract : contracts) {
            ArrayList<Pair> typeWithPidAddressOfContract = new ArrayList<Pair>();
            if (contract.isFiz()) {
                int addressCommutatorUnstruct;
                int addressCommutator;
                address = config.getInt("sorm.upload.fiz.address", -1);
                if (address > 0) {
                    typeWithPidAddressOfContract.add(new Pair((Object)"sorm.upload.fiz.address", (Object)address));
                }
                if ((addressUnstruct = config.getInt("sorm.upload.fiz.unstructaddress", -1)) > 0) {
                    typeWithPidAddressOfContract.add(new Pair((Object)"sorm.upload.fiz.unstructaddress", (Object)addressUnstruct));
                }
                if ((addressCommutator = config.getInt("sorm.upload.fiz.addressinstallcommutator", -1)) > 0) {
                    typeWithPidAddressOfContract.add(new Pair((Object)"sorm.upload.fiz.addressinstallcommutator", (Object)addressCommutator));
                }
                if ((addressCommutatorUnstruct = config.getInt("sorm.upload.fiz.unstructaddressinstallcommutator", -1)) > 0) {
                    typeWithPidAddressOfContract.add(new Pair((Object)"sorm.upload.fiz.unstructaddressinstallcommutator", (Object)addressCommutatorUnstruct));
                }
            } else {
                int addressMailUnstruct;
                int addressMail;
                int addressBillsUnstruct;
                int addressBills;
                int addressCommutatorsUnstruct;
                int addressCommutators;
                address = config.getInt("sorm.upload.org.address", -1);
                if (address > 0) {
                    typeWithPidAddressOfContract.add(new Pair((Object)"sorm.upload.org.address", (Object)address));
                }
                if ((addressUnstruct = config.getInt("sorm.upload.org.unstructaddress", -1)) > 0) {
                    typeWithPidAddressOfContract.add(new Pair((Object)"sorm.upload.org.unstructaddress", (Object)addressUnstruct));
                }
                if ((addressCommutators = config.getInt("sorm.upload.org.addresscommutators", -1)) > 0) {
                    typeWithPidAddressOfContract.add(new Pair((Object)"sorm.upload.org.addresscommutators", (Object)addressCommutators));
                }
                if ((addressCommutatorsUnstruct = config.getInt("sorm.upload.org.addresscommutatorsunstruct", -1)) > 0) {
                    typeWithPidAddressOfContract.add(new Pair((Object)"sorm.upload.org.addresscommutatorsunstruct", (Object)addressCommutatorsUnstruct));
                }
                if ((addressBills = config.getInt("sorm.upload.org.addressbills", -1)) > 0) {
                    typeWithPidAddressOfContract.add(new Pair((Object)"sorm.upload.org.addressbills", (Object)addressBills));
                }
                if ((addressBillsUnstruct = config.getInt("sorm.upload.org.addressbillsunstruct", -1)) > 0) {
                    typeWithPidAddressOfContract.add(new Pair((Object)"sorm.upload.org.addressbillsunstruct", (Object)addressBillsUnstruct));
                }
                if ((addressMail = config.getInt("sorm.upload.org.addressmail", -1)) > 0) {
                    typeWithPidAddressOfContract.add(new Pair((Object)"sorm.upload.org.addressmail", (Object)addressMail));
                }
                if ((addressMailUnstruct = config.getInt("sorm.upload.org.unstructaddressmail", -1)) > 0) {
                    typeWithPidAddressOfContract.add(new Pair((Object)"sorm.upload.org.unstructaddressmail", (Object)addressMailUnstruct));
                }
            }
            if (!Utils.notEmptyCollection(typeWithPidAddressOfContract)) continue;
            result.add((Pair<Integer, List<Pair<String, Integer>>>)new Pair((Object)contract.getContractId(), typeWithPidAddressOfContract));
        }
        return result;
    }

    public static String getAddressType(String configAddressKey) {
        return switch (configAddressKey) {
            case "sorm.upload.org.addressmail", "sorm.upload.org.unstructaddressmail" -> String.valueOf(1);
            case "sorm.upload.org.addressbills", "sorm.upload.org.addressbillsunstruct" -> String.valueOf(2);
            case "sorm.upload.fiz.addressinstallcommutator", "sorm.upload.fiz.unstructaddressinstallcommutator", "sorm.upload.org.addresscommutators", "sorm.upload.org.addresscommutatorsunstruct" -> String.valueOf(3);
            default -> String.valueOf(0);
        };
    }

    public static String ip2Hex(String ip) {
        Object hex = "";
        String[] part = ip.split("[\\.,]");
        if (part.length < 4) {
            return "00000000";
        }
        for (int i = 0; i < 4; ++i) {
            int decimal = Integer.parseInt(part[i]);
            hex = decimal < 16 ? (String)hex + "0" + String.format("%01X", decimal) : (String)hex + String.format("%01X", decimal);
        }
        return hex;
    }

    public static List<IdTitle> getDocumentsTypes(Preferences config, ContractParameterManager cpm) throws BGException {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        int pidDocumentType = config.getInt("sorm.upload.documenttype", -1);
        if (pidDocumentType > 0) {
            result.addAll(cpm.getListValues(pidDocumentType));
        }
        if (result.size() == 0) {
            result.add(new IdTitle(1, "\u041f\u0430\u0441\u043f\u043e\u0440\u0442 \u0433\u0440\u0430\u0436\u0434\u0430\u043d\u0438\u043d\u0430 \u0420\u0424"));
        }
        return result;
    }

    public static int getDocumentTypeIdOfContract(Preferences config, ContractDao contractDao, int contractId, List<IdTitle> documentTypes) throws BGException {
        int pid = config.getInt("sorm.upload.documenttype", -1);
        String value = contractDao.getContractParameterListAsString(contractId, pid).orElse(null);
        for (IdTitle docType : documentTypes) {
            if (!docType.getTitle().equals(value)) continue;
            return docType.getId();
        }
        return 1;
    }

    public static String getConnectionStandard(Preferences config) {
        int standart = config.getInt("sorm.upload.standart.inetconnection", -1);
        if (standart < 0) {
            standart = config.getInt("sorm.upload.standart.voiceconnection", -1);
        }
        if (standart < 0) {
            return "0";
        }
        return String.valueOf(ConnectionStandard.getStandard((int)standart).getId());
    }

    public static String getParameterOfCity(Upload uploadImpl, AddressStruct addressStruct, String parameterKey) throws Exception {
        if (addressStruct == null) {
            return "";
        }
        return SormUtils.getParameterOfCity(uploadImpl, addressStruct.getHouseId(), parameterKey);
    }

    public static String getParameterOfCity(Upload uploadImpl, int houseId, String parameterKey) throws Exception {
        String value = "";
        AddressService addressService = (AddressService)uploadImpl.getServerContext().getService(AddressService.class, 0);
        House house = addressService.houseGet(houseId);
        if (house != null) {
            value = uploadImpl.getParameterDao().getAddressParam("address_city", house.getCity().getId(), parameterKey);
        }
        return Utils.maskBlank((String)value, (String)"");
    }

    public static boolean checkValidAddress(AddressStruct address) {
        if (address == null) {
            return false;
        }
        return Utils.notBlankString((String)address.getCity()) && Utils.notBlankString((String)address.getStreet()) && Utils.notBlankString((String)address.getCountry()) && Utils.notBlankString((String)address.getHouse());
    }

    public static String[] getIPGatewayItem(Device inetDevice, String regionId) {
        try {
            List hosts = inetDevice.getHosts();
            InetSocketAddress inetSocketAddress = null;
            if (hosts != null && hosts.size() > 0) {
                inetSocketAddress = (InetSocketAddress)hosts.get(0);
            }
            String[] item = new String[6];
            item[0] = String.valueOf(inetDevice.getId());
            item[1] = inetSocketAddress != null ? "0" : "";
            InetAddress inetAddress = null;
            if (inetSocketAddress != null) {
                inetAddress = inetSocketAddress.getAddress();
            }
            item[2] = inetAddress != null ? SormUtils.ip2Hex(IpAddress.toString((byte[])inetAddress.getAddress())) : "";
            item[3] = "";
            item[4] = inetSocketAddress != null ? String.valueOf(inetSocketAddress.getPort() != 0 ? Integer.valueOf(inetSocketAddress.getPort()) : "") : "";
            item[5] = regionId;
            return item;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    public static String getFullOperatorAddress(Preferences config) {
        return config.get("sorm.upload.operator.address.index") + ", " + config.get("sorm.upload.operator.address.city") + ", " + config.get("sorm.upload.operator.address.street") + ", " + config.get("sorm.upload.operator.address.house");
    }

    public static List<InternalUser> getInternalUsers(ContractObjectDao contractObjectDao, SormUploadHelper uploadHelper, Preferences config) throws Exception {
        ArrayList<InternalUser> users = new ArrayList<InternalUser>();
        users.addAll(SormUtils.internalUsersFromContractObjects(contractObjectDao, uploadHelper, config));
        users.addAll(SormUtils.internalUsersFromCustomerEmployee(uploadHelper.getCustomerValueByQuery("/customer/employee"), uploadHelper));
        return users;
    }

    private static List<InternalUser> internalUsersFromContractObjects(ContractObjectDao contractObjectDao, SormUploadHelper uploadHelper, Preferences config) throws Exception {
        SormContract sormContract = uploadHelper.getCurrentContract();
        int contractId = sormContract.getContractId();
        String contractTitle = sormContract.getContractTitle();
        boolean checkSuperContract = config.getInt("sorm.upload.staff.getfromsuper", 0) == 1;
        List contractObjects = contractObjectDao.list(sormContract.getContractId());
        if (Utils.isEmptyCollection((Collection)contractObjects) && checkSuperContract && sormContract.isSub()) {
            contractObjects = contractObjectDao.list(sormContract.getScid());
        }
        ArrayList<InternalUser> users = new ArrayList<InternalUser>();
        for (ContractObject object : contractObjects) {
            int typeObject;
            if (object.getDateFrom() == null || (typeObject = config.getInt("sorm.upload.staff.typeobject", -1)) <= 0 || object.getTypeId() != typeObject) continue;
            int objectId = object.getId();
            InternalUser internalUser = new InternalUser();
            internalUser.setId(contractId + "_" + object.getId());
            internalUser.setBgObjectId(objectId);
            internalUser.setFirstName(SormUtils.getTextParamValue(contractObjectDao, objectId, config.getInt("sorm.upload.staff.firstname", -1)));
            internalUser.setLastName(SormUtils.getTextParamValue(contractObjectDao, objectId, config.getInt("sorm.upload.staff.lastname", -1)));
            internalUser.setMiddleName(SormUtils.getTextParamValue(contractObjectDao, objectId, config.getInt("sorm.upload.staff.middlename", -1)));
            internalUser.setBirthday(SormUtils.getDateParamValue(contractObjectDao, objectId, config.getInt("sorm.upload.staff.birthday", -1)));
            internalUser.setDocumentSerial(SormUtils.getTextParamValue(contractObjectDao, objectId, config.getInt("sorm.upload.staff.documentserial", -1)));
            internalUser.setDocumentNumber(SormUtils.getTextParamValue(contractObjectDao, objectId, config.getInt("sorm.upload.staff.documentnumber", -1)));
            internalUser.setDocumentWhoGive(SormUtils.getTextParamValue(contractObjectDao, objectId, config.getInt("sorm.upload.staff.documentwhogive", -1)));
            internalUser.setDocumentWhenGive(SormUtils.getDateParamValue(contractObjectDao, objectId, config.getInt("sorm.upload.staff.docemuntwhengive", -1)));
            internalUser.setPhoneNumber(SormUtils.getTextParamValue(contractObjectDao, objectId, config.getInt("sorm.upload.staff.phonenumber", -1)));
            internalUser.setAddress(SormUtils.getTextParamValue(contractObjectDao, objectId, config.getInt("sorm.upload.staff.addressunstruct", -1)));
            internalUser.setAddressStruct(contractObjectDao.optObjectParameterAddress(objectId, config.getInt("sorm.upload.staff.addressstruct", -1)).orElse(null));
            internalUser.setDateFrom(object.getDateFrom());
            internalUser.setDateTo(object.getDateTo());
            internalUser.setContractId(contractId);
            internalUser.setContractTitle(contractTitle);
            internalUser.setDocumentType(SormUtils.getListParamValue(contractObjectDao, objectId, config.getInt("sorm.upload.staff.documenttype", -1)));
            users.add(internalUser);
        }
        return users;
    }

    private static List<InternalUser> internalUsersFromCustomerEmployee(String employeeData, SormUploadHelper helper) {
        if (Utils.isBlankString((String)employeeData)) {
            return Collections.emptyList();
        }
        ArrayList<InternalUser> users = new ArrayList<InternalUser>();
        JSONArray array = new JSONArray(employeeData);
        for (int i = 0; i < array.length(); ++i) {
            CustomerEmployee employee = CustomerEmployee.fromJSON((JSONObject)array.getJSONObject(i));
            InternalUser user = new InternalUser();
            user.setId(helper.getCurrentContract().getContractId() + "_" + employee.getUuid());
            user.setDateFrom(employee.getDateFrom() != null ? TimeUtils.convertLocalDateToDate((LocalDate)employee.getDateFrom()) : null);
            user.setDateTo(employee.getDateTo() != null ? TimeUtils.convertLocalDateToDate((LocalDate)employee.getDateTo()) : null);
            user.setBgObjectId(employee.getCustomerId());
            user.setAddress(employee.getAddress());
            user.setBirthday(employee.getBirthday() != null ? TimeUtils.convertLocalDateToDate((LocalDate)employee.getBirthday()) : null);
            user.setDocumentNumber(employee.getDocumentNumber());
            user.setDocumentSerial(employee.getDocumentSerial());
            user.setDocumentWhoGive(employee.getDocumentWhoGive());
            user.setDocumentWhenGive(employee.getDocumentWhenGive() != null ? TimeUtils.convertLocalDateToDate((LocalDate)employee.getDocumentWhenGive()) : null);
            user.setContractId(helper.getCurrentContract().getContractId());
            user.setContractTitle(helper.getCurrentContract().getContractTitle());
            String phone = Utils.maskBlank((String)employee.getPhone(), (String)employee.getMobile());
            user.setPhoneNumber(Utils.maskBlank((String)phone, (String)""));
            if (Utils.notBlankString((String)employee.getFio())) {
                String[] fio = employee.getFio().trim().split(" ");
                user.setLastName(fio.length > 0 ? fio[0] : "");
                user.setFirstName(fio.length > 1 ? fio[1] : "");
                user.setMiddleName(fio.length > 2 ? fio[2] : "");
            }
            users.add(user);
        }
        return users;
    }

    private static String getTextParamValue(ContractObjectDao contractObjectDao, int objectId, int paramId) throws Exception {
        return contractObjectDao.optObjectParameterTextAsString(objectId, paramId).orElse("");
    }

    private static Date getDateParamValue(ContractObjectDao contractObjectDao, int objectId, int paramId) throws Exception {
        return contractObjectDao.optObjectParameterDateAsDate(objectId, paramId).orElse(null);
    }

    private static String getListParamValue(ContractObjectDao contractObjectDao, int objectId, int paramId) throws Exception {
        return contractObjectDao.optObjectParameterListAsString(objectId, paramId).orElse("");
    }

    public static EntityAttrAddress getAddressFromDeviceAttributes(Device<?, ?> device) {
        EntityAttrAddress address = null;
        Map entityAttributes = device.getEntityAttributes();
        if (entityAttributes != null && !entityAttributes.isEmpty()) {
            for (EntityAttr attr : entityAttributes.values()) {
                if (!(attr instanceof EntityAttrAddress)) continue;
                address = (EntityAttrAddress)attr;
                break;
            }
        }
        return address;
    }

    public static String getAlias(Connection connection, int voiceIpMid, int loginId) {
        String alias = "";
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery("select login_alias from " + ServerUtils.getModuleTableName((String)"user_alias", (int)voiceIpMid) + " where login_id=" + loginId);){
            if (rs.next()) {
                alias = rs.getString("login_alias");
            }
        }
        catch (SQLException ex) {
            logger.error(ex.getMessage());
        }
        return alias;
    }

    public static boolean contractHasModule(Connection connection, int moduleId, int contractId) {
        boolean isHas = false;
        String query = "SELECT COUNT(*) AS count FROM contract_module WHERE mid=? AND cid=?";
        try (PreparedStatement ps = connection.prepareStatement(query);){
            ps.setInt(1, moduleId);
            ps.setInt(2, contractId);
            ResultSet rs = ps.executeQuery();
            if (rs.next() && rs.getInt("count") > 0) {
                isHas = true;
            }
            rs.close();
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
        }
        return isHas;
    }

    public static String formatDateToUTC(Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setTimeZone(TimeZone.getTimeZone(ZoneId.of("UTC")));
        return dateFormat.format(date);
    }

    public static String formatDateToUTC(Calendar date, String pattern) {
        return SormUtils.formatDateToUTC(date.getTime(), pattern);
    }

    public static class IpUtils {
        public static long ipToLong(byte[] ip) {
            long result = 0L;
            for (byte b : ip) {
                result = result << 8 | (long)(b & 0xFF);
            }
            return result;
        }

        public static String longToIp(long ip) {
            return String.format("%d.%d.%d.%d", ip >> 24 & 0xFFL, ip >> 16 & 0xFFL, ip >> 8 & 0xFFL, ip & 0xFFL);
        }

        public static List<String> expand(byte[] addressFrom, byte[] addressTo) throws UnknownHostException {
            long end;
            ArrayList<String> result = new ArrayList<String>();
            if (addressFrom == null) {
                return result;
            }
            if (addressTo == null) {
                IpNet ipNet = IpNet.newInstance((byte[])addressFrom, null);
                String cidr = ipNet.toString();
                if (cidr.contains("/")) {
                    SubnetUtils utils = new SubnetUtils(cidr);
                    utils.setInclusiveHostCount(true);
                    result.addAll(Arrays.asList(utils.getInfo().getAllAddresses()));
                } else {
                    result.add(InetAddress.getByAddress(addressFrom).getHostAddress());
                }
                return result;
            }
            long start = IpUtils.ipToLong(addressFrom);
            if (start > (end = IpUtils.ipToLong(addressTo))) {
                long tmp = start;
                start = end;
                end = tmp;
            }
            for (long ip = start; ip <= end; ++ip) {
                result.add(IpUtils.longToIp(ip));
            }
            return result;
        }
    }
}

