/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class ServersManager {
    private ParameterMap setup;
    private List<Integer> serverCodes = null;
    private Map<Integer, String> serverTitleMap = new HashMap<Integer, String>(4);

    public ServersManager(ParameterMap setup) {
        this.setup = setup;
    }

    public List<Integer> getServerCodes() {
        if (this.serverCodes == null) {
            this.serverCodes = new ArrayList<Integer>();
            for (int id = 0; id <= 100; ++id) {
                if (this.setup.sub("server." + id + ".").entrySet().size() <= 0) continue;
                this.serverCodes.add(id);
            }
        }
        return this.serverCodes;
    }

    public String getTitle(int id) {
        Object result = this.serverTitleMap.get(id);
        if (result == null) {
            result = this.setup.get("server." + id + ".title", null);
            if (Utils.isBlankString((String)result)) {
                result = String.valueOf(id);
                if (!this.getServerCodes().contains(id)) {
                    result = "?" + (String)result;
                }
            }
            this.serverTitleMap.put(id, (String)result);
        }
        return result;
    }

    public List<IdTitle> getServers() {
        ArrayList<IdTitle> list = new ArrayList<IdTitle>();
        for (Integer i : this.getServerCodes()) {
            list.add(new IdTitle(i.intValue(), this.getTitle(i)));
        }
        return list;
    }
}

