package ru.bitel.bgbilling.modules.tv.dyn.smarty;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import ru.bitel.common.Utils;

public class SmartyResponse
{
    @JsonProperty( "error" )
    private int error = 0;
    @JsonProperty( "error_message" )
    @JsonDeserialize(using = SmartyErrorMessageDeserialize.class)
    private SmartyErorMessage errorMessage = new SmartyErorMessage();
    private Map<String,Object> params = new HashMap<>(); 
    
    public SmartyResponse()
    {
    }

    public int getError()
    {
        return error;
    }

    public void setError( int error )
    {
        this.error = error;
    }

    public String getErrorMessage()
    {
        return errorMessage.toString();
    }

    public void setErrorMessage( SmartyErorMessage errorMessage )
    {
        this.errorMessage = errorMessage;
    }
    
    @JsonAnySetter
    public void put( String key, Object value )
    {
        params.put( key, value );
    }
    
    public String getString( String key )
    {
        Object value = params.get( key );
        return value != null ? String.valueOf( value ) : null;
    }

    public int getInt( String key, int defaultValue )
    {
        return Utils.parseInt( String.valueOf( params.get( key ) ), defaultValue );
    }
}