/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.CitiPayTransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebServlet(name="CitiPayReport", urlPatterns={"/CitiPayReport"})
public class CitiPayReport
extends CommonExecutor {
    private static final String TIMEPATTERN = "yyyyMMddHHmmss";
    private static final Pattern slashPattern = Pattern.compile("/");
    private static final String REQUEST_PARAM_CHECK_DATE_BEGIN = "CheckDateBegin";
    private static final String REQUEST_PARAM_CHECK_DATE_END = "CheckDateEnd";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int moduleId;
        super.doPost(request, response);
        String mpsId = null;
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            String[] params = slashPattern.split(pathInfo);
            switch (params.length) {
                default: {
                    mpsId = params[2];
                }
                case 2: {
                    moduleId = Utils.parseInt((String)params[1], (int)0);
                    break;
                }
                case 0: 
                case 1: {
                    moduleId = 0;
                }
            }
            request.setAttribute("ru.bitel.bgbilling.modules.mps.server.bean.MPSTransactionManager.PATH_INFO", (Object)params);
        } else {
            moduleId = 0;
            mpsId = null;
        }
        this.setup = Setup.getSetup();
        ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(moduleId));
        if (moduleSetup == null || !moduleSetup.getBoolean("mps.citypay.report", false)) {
            response.sendError(403);
            return;
        }
        Calendar checkDateBegin = TimeUtils.parseCalendar((String)request.getParameter(REQUEST_PARAM_CHECK_DATE_BEGIN), (String)TIMEPATTERN);
        Calendar checkDateEnd = TimeUtils.parseCalendar((String)request.getParameter(REQUEST_PARAM_CHECK_DATE_END), (String)TIMEPATTERN);
        response.setContentType("text/xml; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.write("<Response>\n");
        for (Transaction mpsPayment : new CitiPayTransactionManager().getTransactionList(this.setup, this.setup.getDBConnectionFromPool(), moduleId, mpsId, checkDateBegin, checkDateEnd, true)) {
            StringBuilder buf = new StringBuilder("<Payment>").append("<TransactionId>").append(mpsPayment.getTransId()).append("</TransactionId>").append("<Account>").append(mpsPayment.getContractTitle()).append("</Account>").append("<TransactionDate>").append(TimeUtils.format((Date)mpsPayment.getTime(), (String)TIMEPATTERN)).append("</TransactionDate>").append("<Amount>").append(mpsPayment.getSum().toPlainString()).append("</Amount>").append("</Payment>\n");
            out.write(buf.toString());
        }
        out.write("</Response>\n");
        out.flush();
        out.close();
    }
}

