/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.service;

import jakarta.jws.WebService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractIdTitleComment;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.intercom.SmartHouseIntercom;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.intercom.SmartHouseIntercomFlat;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.intercom.SmartHouseIntercomType;
import ru.bitel.bgbilling.modules.smarthouse.common.service.SmartHouseIntercomService;
import ru.bitel.bgbilling.modules.smarthouse.server.api.intersvyaz.IntersvyazManager;
import ru.bitel.bgbilling.modules.smarthouse.server.api.sputnik.SputnikManager;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.intercom.SmartHouseIntercomDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.intercom.SmartHouseIntercomFlatDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.directories.address.server.bean.StreetDao;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.smarthouse.common.service.SmartHouseIntercomService")
public class SmartHouseIntercomServiceImpl
extends AbstractService
implements SmartHouseIntercomService {
    public SearchResult<SmartHouseIntercom> smartHouseIntercomSearch(String title, String[] sort, Page page) throws Exception {
        return null;
    }

    public List<SmartHouseIntercom> smartHouseIntercomList() throws Exception {
        IntersvyazManager intersvyazManager;
        ArrayList<SmartHouseIntercom> list = new ArrayList<SmartHouseIntercom>();
        SmartHouseIntercomDao smartHouseIntercomDao = new SmartHouseIntercomDao(this.getConnection(), this.moduleId);
        SputnikManager sputnikManager = new SputnikManager(this.moduleId);
        if (sputnikManager.isEnabled()) {
            JSONObject a = sputnikManager.getAccountDevicesIntercoms(1);
            JSONArray intercoms = a.optJSONArray("intercoms");
            int totalPages = a.optInt("total_pages");
            if (totalPages > 1) {
                for (int page = 2; page <= totalPages; ++page) {
                    a = sputnikManager.getAccountDevicesIntercoms(page);
                    JSONArray pageIntercoms = a.optJSONArray("intercoms");
                    for (int index = 0; index < pageIntercoms.length(); ++index) {
                        intercoms.put((Object)pageIntercoms.getJSONObject(index));
                    }
                }
            }
            block2: for (SmartHouseIntercom smartHouseIntercom : smartHouseIntercomDao.getList()) {
                if (smartHouseIntercom.getType() != SmartHouseIntercomType.SPUTNIK) {
                    list.add(smartHouseIntercom);
                    continue;
                }
                JSONObject json = new JSONObject(smartHouseIntercom.getData());
                String deviceId = json.optString("device_id");
                if (deviceId.isEmpty()) continue;
                for (int index = 0; index < intercoms.length(); ++index) {
                    JSONObject intercomJson = intercoms.getJSONObject(index);
                    if (!intercomJson.optString("device_id").contains(deviceId)) continue;
                    json.put("node_id", intercomJson.optLong("node_id"));
                    json.put("is_online", intercomJson.optBoolean("is_online"));
                    json.put("motherboard_id", intercomJson.optLong("motherboard_id"));
                    smartHouseIntercom.setData(json.toString());
                    smartHouseIntercomDao.update(smartHouseIntercom);
                    list.add(smartHouseIntercom);
                    intercoms.remove(index);
                    continue block2;
                }
            }
            for (int index = 0; index < intercoms.length(); ++index) {
                JSONObject intercomJson = intercoms.getJSONObject(index);
                JSONObject json = new JSONObject();
                json.put("device_id", (Object)intercomJson.optString("device_id"));
                json.put("is_online", intercomJson.optBoolean("is_online"));
                json.put("motherboard_id", intercomJson.optLong("motherboard_id"));
                json.put("serial_number", (Object)intercomJson.optString("serial_number"));
                SmartHouseIntercom smartHouseIntercom = new SmartHouseIntercom();
                smartHouseIntercom.setType(SmartHouseIntercomType.SPUTNIK);
                smartHouseIntercom.setData(json.toString());
                smartHouseIntercomDao.update(smartHouseIntercom);
                list.add(smartHouseIntercom);
            }
        }
        if ((intersvyazManager = new IntersvyazManager(this.moduleId)).isEnabled()) {
            // empty if block
        }
        return list;
    }

    public SmartHouseIntercom smartHouseIntercomGet(int id) throws Exception {
        return (SmartHouseIntercom)new SmartHouseIntercomDao(this.getConnection(), this.moduleId).get(id);
    }

    public int smartHouseIntercomUpdate(SmartHouseIntercom smartHouseIntercom) throws Exception {
        new SmartHouseIntercomDao(this.getConnection(), this.moduleId).update(smartHouseIntercom);
        return smartHouseIntercom.getId();
    }

    public JSONObject houseInfoData(List<Integer> houseIds) throws Exception {
        JSONObject addressInfoData = new JSONObject();
        if (houseIds != null) {
            try (HouseDao houseDao = new HouseDao(this.getConnection());
                 StreetDao streetDao = new StreetDao(this.getConnection());){
                for (Integer houseId : houseIds) {
                    House house = houseDao.get(houseId.intValue());
                    if (house == null) continue;
                    JSONObject json = new JSONObject().put("id", (Object)houseId).put("house", house.getHouse()).put("frac", (Object)house.getFrac()).put("street", house.optStreet().map(IdTitle::getTitle).orElse(null));
                    addressInfoData.put(String.valueOf(houseId), (Object)json);
                }
            }
        }
        return addressInfoData;
    }

    public void doGetIntercomFlats(int id) throws Exception {
        SmartHouseIntercomDao smartHouseIntercomDao = new SmartHouseIntercomDao(this.getConnection(), this.moduleId);
        SmartHouseIntercom intercom = (SmartHouseIntercom)smartHouseIntercomDao.get(id);
        if (intercom != null && intercom.getType() == SmartHouseIntercomType.SPUTNIK) {
            JSONObject dataJson = new JSONObject(intercom.getData());
            JSONObject propertiesBase = (JSONObject)new SputnikManager(this.moduleId).getAccountDevicesIntercomsShadow(dataJson.optString("device_id")).optQuery("/properties/base");
            int flatFrom = Utils.parseInt((String)propertiesBase.optString("flats_first"));
            int flatLast = Utils.parseInt((String)propertiesBase.optString("flats_last"));
            intercom.setFlatRange(flatFrom + "-" + flatLast);
            smartHouseIntercomDao.update(intercom);
        }
    }

    public List<SmartHouseIntercomFlat> smartHouseIntercomFlatList(int intercomId) throws Exception {
        SmartHouseIntercomDao smartHouseIntercomDao = new SmartHouseIntercomDao(this.getConnection(), this.moduleId);
        SmartHouseIntercomFlatDao smartHouseIntercomFlatDao = new SmartHouseIntercomFlatDao(this.getConnection(), this.moduleId);
        SmartHouseIntercom intercom = (SmartHouseIntercom)smartHouseIntercomDao.get(intercomId);
        List<SmartHouseIntercomFlat> flatList = smartHouseIntercomFlatDao.list(intercomId);
        String flatRange = intercom.getFlatRange();
        for (String range : flatRange.split(",")) {
            int s2;
            int pos;
            int s1;
            if (range.matches("^\\d+$")) {
                int number = Utils.parseInt((String)range);
                if (flatList.stream().anyMatch(e -> e.getFlatNumber() == number)) continue;
                SmartHouseIntercomFlat intercomFlat = new SmartHouseIntercomFlat();
                intercomFlat.setIntercomId(intercomId);
                intercomFlat.setFlatNumber(number);
                flatList.add(intercomFlat);
                continue;
            }
            if (!range.matches("^\\d+-\\d+$") || (s1 = Utils.parseInt((String)range.substring(0, pos = range.indexOf(45)))) >= (s2 = Utils.parseInt((String)range.substring(pos + 1)))) continue;
            for (int flat = s1; flat <= s2; ++flat) {
                int number = flat;
                if (flatList.stream().anyMatch(e -> e.getFlatNumber() == number)) continue;
                SmartHouseIntercomFlat intercomFlat = new SmartHouseIntercomFlat();
                intercomFlat.setIntercomId(intercomId);
                intercomFlat.setFlatNumber(number);
                flatList.add(intercomFlat);
            }
        }
        Collections.sort(flatList, new Comparator<SmartHouseIntercomFlat>(){

            @Override
            public int compare(SmartHouseIntercomFlat o1, SmartHouseIntercomFlat o2) {
                return o1.getFlatNumber() - o2.getFlatNumber();
            }
        });
        return flatList;
    }

    public void smartHouseIntercomFlatUpdate(SmartHouseIntercomFlat smartHouseIntercomFlat) throws Exception {
        new SmartHouseIntercomFlatDao(this.getConnection(), this.moduleId).update(smartHouseIntercomFlat);
    }

    public List<String> searchHouse(String text) throws Exception {
        ArrayList<String> result;
        block24: {
            String[] tokens = text.split(",| ");
            String street = null;
            String house = null;
            if (tokens.length > 2) {
                street = tokens[tokens.length - 2];
                house = tokens[tokens.length - 1];
            } else if (tokens.length > 1) {
                street = tokens[0];
                house = tokens[1];
            } else if (tokens.length == 1) {
                street = tokens[0];
            }
            Object query = "SELECT h.id, c.title, s.title, h.house, h.frac FROM `address_street` AS s LEFT JOIN `address_city` AS c ON c.id=s.cityid LEFT JOIN `address_house` AS h ON h.streetid=s.id WHERE true ";
            if (street != null) {
                query = (String)query + "AND s.title regexp ? ";
            }
            if (house != null) {
                query = (String)query + "AND h.house regexp ?";
            }
            result = new ArrayList<String>();
            try (PreparedStatement psSelect = this.getConnection().prepareStatement((String)query);){
                int index = 1;
                if (street != null) {
                    psSelect.setString(index++, "^" + street + ".*|.+ +" + street + ".*");
                }
                if (house != null) {
                    psSelect.setString(index++, "^" + house + ".*");
                }
                if (street == null) break block24;
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        JSONObject json = new JSONObject();
                        json.put("houseId", rs.getInt("h.id"));
                        json.put("houseN", rs.getInt("h.house"));
                        json.put("houseF", (Object)rs.getString("h.frac"));
                        json.put("city", (Object)rs.getString("c.title"));
                        json.put("street", (Object)rs.getString("s.title"));
                        result.add(json.toString());
                    }
                }
            }
            catch (Exception e) {
                new BGException((Throwable)e);
            }
        }
        return result;
    }

    public List<String> getContractData(List<Integer> contractIds) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (contractIds != null && !contractIds.isEmpty()) {
            try (PreparedStatement ps = this.getConnection().prepareStatement("SELECT `id`, `title`, `comment` FROM `contract` WHERE `id` IN ( " + Utils.toString(contractIds) + " )");
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    JSONObject json = new JSONObject();
                    json.put("id", rs.getInt("id"));
                    json.put("title", (Object)rs.getString("title"));
                    json.put("comment", (Object)rs.getString("comment"));
                    list.add(json.toString());
                }
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        return list;
    }

    public List<ContractIdTitleComment> searchContractByMask(String text) throws Exception {
        return null;
    }

    public List<ContractIdTitleComment> searchContractByAddress(int intercomId) throws Exception {
        return null;
    }

    public void setIntercomFlatStatus(int contractId, int intercomFlatId, boolean status) throws Exception {
        SmartHouseIntercomDao smartHouseIntercomDao = new SmartHouseIntercomDao(this.getConnection(), this.moduleId);
        SmartHouseIntercomFlatDao smartHouseIntercomFlatDao = new SmartHouseIntercomFlatDao(this.getConnection(), this.moduleId);
        SmartHouseIntercomFlat smartHouseIntercomFlat = (SmartHouseIntercomFlat)smartHouseIntercomFlatDao.get(intercomFlatId);
        if (smartHouseIntercomFlat == null) {
            throw new BGMessageException("smartHouseIntercomFlat == null [ID#" + intercomFlatId + "]");
        }
        if (smartHouseIntercomFlat.getContractId() != contractId) {
            throw new BGMessageException("smartHouseIntercomFlat.getContractId() != contractId");
        }
        if (smartHouseIntercomFlat.isStatus() == status) {
            throw new BGMessageException("\u0421\u0442\u0430\u0442\u0443\u0441 \u0443\u0436\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
        }
        SmartHouseIntercom smartHouseIntercom = (SmartHouseIntercom)smartHouseIntercomDao.get(smartHouseIntercomFlat.getIntercomId());
        if (SmartHouseIntercomType.SPUTNIK.equals((Object)smartHouseIntercom.getType())) {
            SputnikManager sputnikManager = new SputnikManager(this.moduleId);
            try {
                String uuid = new JSONObject(smartHouseIntercom.getData()).optString("device_id");
                sputnikManager.patchAccountDevicesIntercomsChangeFlatConfig(uuid, smartHouseIntercomFlat.getFlatNumber(), !status);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        smartHouseIntercomFlat.setStatus(status);
        smartHouseIntercomFlatDao.update(smartHouseIntercomFlat);
        smartHouseIntercomFlatDao.insertSmartHouseIntercomFlatStatusLog(smartHouseIntercomFlat.getId(), LocalDateTime.now(), status, this.userId);
    }

    public SmartHouseIntercomFlat getSmartHouseIntercomFlatByContractId(int contractId) throws Exception {
        SmartHouseIntercomFlat smartHouseIntercomFlat = null;
        for (SmartHouseIntercomFlat flat : new SmartHouseIntercomFlatDao(this.getConnection(), this.moduleId).listByContractId(contractId)) {
            if (!TimeUtils.dateInPeriod((LocalDate)LocalDate.now(), (Period)flat.getPeriod())) continue;
            smartHouseIntercomFlat = flat;
            break;
        }
        return smartHouseIntercomFlat;
    }

    public void addIntercomFlatForContractAddress(int contractId) throws Exception {
    }

    public SearchResult<String> searchIntercomFlatStatusLogs(int intercomFlatId, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        new SmartHouseIntercomFlatDao(this.getConnection(), this.moduleId).searchSmartHouseIntercomFlatStatusLogs((SearchResult<String>)searchResult, intercomFlatId);
        return searchResult;
    }
}

