/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.botconfigure;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElementType;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

final class ElementsListCellRenderer
implements ListCellRenderer<BotDialogElement> {
    private List<BotDialog> dialogs;

    protected ElementsListCellRenderer(List<BotDialog> dialogs) {
        this.dialogs = dialogs;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends BotDialogElement> list, BotDialogElement dialogElement, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel typeElement = new JLabel(dialogElement.getElementType().getType());
        typeElement.setFont(new Font("SansSerif", 0, 16));
        JPanel renderedPanel = new JPanel(new GridBagLayout());
        renderedPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
        renderedPanel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 3, 5), 0, 0);
        renderedPanel.add((Component)typeElement, constraints);
        JLabel elementDescription = new JLabel();
        Object text = dialogElement.getJSONConfig().optString("text");
        elementDescription.setToolTipText((String)text);
        if (Utils.notBlankString((String)text) && ((String)text).length() > 80) {
            text = ((String)text).substring(0, 80) + "...";
        }
        Font font = new Font("SansSerif", 2, 12);
        elementDescription.setText((String)text);
        elementDescription.setFont(font);
        renderedPanel.add((Component)elementDescription, constraints);
        if (dialogElement.getElementType().equals((Object)BotDialogElementType.BUTTON)) {
            int textDialogId = Utils.parseInt((String)dialogElement.getJSONConfig().optString("dialogProcessingClassPath"), (int)-1);
            if (textDialogId > 0) {
                String title = this.dialogs.stream().filter(d -> d.getId() == textDialogId).findFirst().map(IdTitle::getTitle).orElse("<\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0434\u0438\u0430\u043b\u043e\u0433>");
                JLabel dialogTitle = new JLabel("\u0412\u044b\u0437\u044b\u0432\u0430\u0435\u0442: " + title);
                dialogTitle.setFont(new Font("SansSerif", 2, 12));
                renderedPanel.add((Component)dialogTitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            }
        } else if (dialogElement.getElementType().equals((Object)BotDialogElementType.ATTACHMENT)) {
            JLabel imageLabel = new JLabel();
            imageLabel.setIcon(ClientUtils.getIcon((String)"src_nojava"));
            JLabel attachmentFileTitle = new JLabel(dialogElement.getJSONConfig().optString("attachmentFileTitle"));
            attachmentFileTitle.setFont(font);
            renderedPanel.add((Component)imageLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            renderedPanel.add((Component)attachmentFileTitle, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return renderedPanel;
    }
}

