/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client.contract;

import bitel.billing.module.services.ServicePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.xml.JAXBUtils;

public class ContractProductCopiesPanel
extends ServicePanel {
    private BGTableModel<Copy> model;
    private BGUTable tableCopies;
    private CopyEditor editor;

    public ContractProductCopiesPanel() {
        this.tableCopies = new BGUTable(this.model);
        this.editor = new CopyEditor();
        try {
            this.model = new BGTableModel<Copy>("\u041a\u043e\u043f\u0438\u0438"){

                protected void initColumns() {
                    this.addColumnId();
                    this.addColumn("\u041f\u0440\u043e\u0434\u0443\u043a\u0442", 200, 200, 200, "productTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                    this.addColumn("\u0412\u0435\u0440\u0441\u0438\u044f", 100, 100, 100, "productVersion", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                    this.addColumn("\u0414\u0430\u0442\u0430", 180, 180, 180, "date", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
                    this.addColumn("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u0430\u0442", 200, 300, 400, "licenseeName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                    this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
                }
            };
            this.tableCopies.setModel(this.model);
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void setModuleData(String module, int moduleId, int contractId) {
        if (Utils.isEmptyString((String)this.module) || this.getModuleId() == -1 || this.getContractId() == -1) {
            this.module = module;
            this.setModuleId(moduleId);
            this.setContractId(contractId);
        }
    }

    public void jbInit() {
        this.setLayout(new BorderLayout());
        this.add(BGSwingUtilites.wrapBorder((JComponent)new JScrollPane((Component)this.tableCopies), (String)"\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"), "Center");
        this.add(BGSwingUtilites.wrapBorder((JPanel)this.editor, (String)"\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"), "South");
        this.editor.setVisible(false);
        BGSwingUtilites.handleLDMouseClicked((Component)this.tableCopies, e -> this.editItem());
    }

    private void stopEdit(boolean save) {
        if (save) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setAction("UpdateCopy");
            request.setAttribute("copy_id", this.editor.currentId);
            request.setAttribute("product_id", ((IdTitle)this.editor.availableProducts.getSelectedItem()).getId());
            request.setAttribute("licensee_name", this.editor.licenseeName.getText());
            request.setAttribute("comment", this.editor.comment.getText());
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.editor.setVisible(false);
                this.setData();
            }
        } else {
            this.editor.setVisible(false);
        }
    }

    public void newItem() {
        this.editor.currentId = -1;
        this.editor.licenseeName.setText("");
        this.editor.comment.setText("");
        this.setAvailableProducts();
        this.editor.availableProducts.setEnabled(true);
        this.editor.setVisible(true);
    }

    public void editItem() {
        int row = this.tableCopies.getSelectedRow();
        if (row >= 0) {
            int copyId = ((Copy)this.model.getSelectedRow()).getId();
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("GetCopy");
            request.setAttribute("copy_id", copyId);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                try {
                    Copy copy = (Copy)JAXBUtils.unmarshal((Node)doc, (String)"/data/copy", Copy.class);
                    this.editor.currentId = copyId;
                    this.editor.licenseeName.setText(copy.getLicenseeName());
                    this.editor.comment.setText(copy.getComment());
                    this.setAvailableProducts();
                    this.editor.availableProducts.setSelectedItem((Object)copy.getProductId());
                    this.editor.availableProducts.setEnabled(false);
                    this.editor.setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setData() {
        try {
            this.model.setData(((LicenseService)this.getContext().getPort(LicenseService.class, this.getModuleId())).copyList(this.getContractId()));
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.editor.setVisible(false);
    }

    private void setAvailableProducts() {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAttribute("cid", this.getContractId());
        request.setAction("GetProducts");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            try {
                ArrayList availableProductItems = new ArrayList();
                XMLUtils.selectElements((Node)doc, (String)"data/table/data/row").iterator().forEachRemaining(a -> availableProductItems.add(new IdTitle(Integer.valueOf(XMLUtils.getAttribute((Element)a, (String)"id")).intValue(), XMLUtils.getAttribute((Element)a, (String)"title") + " " + XMLUtils.getAttribute((Element)a, (String)"version"))));
                this.editor.availableProducts.setData(availableProductItems);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class CopyEditor
    extends JPanel {
        private int currentId;
        private BGUComboBox<IdTitle> availableProducts;
        private BGTextField licenseeName;
        private BGTextField comment;
        private BGButtonPanelOkCancel okCancelPanel;

        public CopyEditor() {
            super(new GridBagLayout());
            this.availableProducts = new BGUComboBox();
            this.licenseeName = new BGTextField();
            this.comment = new BGTextField();
            this.okCancelPanel = new BGButtonPanelOkCancel();
            int index = 0;
            this.add((Component)new JLabel("\u041f\u0440\u043e\u0434\u0443\u043a\u0442: "), new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.availableProducts, new GridBagConstraints(1, index++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u0430\u0442: "), new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.licenseeName, new GridBagConstraints(1, index++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439: "), new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.comment, new GridBagConstraints(1, index++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)this.okCancelPanel, new GridBagConstraints(0, index++, 2, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
            this.okCancelPanel.addActionListener(e -> ContractProductCopiesPanel.this.stopEdit(e.getActionCommand().equals("ok")));
        }
    }
}

