/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.directory.organization;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.modules.bill.client.directory.organization.ListTransferHandler;
import ru.bitel.bgbilling.modules.bill.client.directory.organization.OrgListItem;
import ru.bitel.bgbilling.modules.bill.client.directory.organization.OrgListItemCellRenderer;
import ru.bitel.bgbilling.modules.bill.client.directory.organization.OrgListItemType;
import ru.bitel.bgbilling.modules.bill.common.bean.BankAccount;
import ru.bitel.bgbilling.modules.bill.common.bean.Organization;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class OrganizationAccountManagerPanel
extends BGPanel {
    private Organization organization = null;
    private JPanel organizationEditorPanel = null;
    private JPopupMenu organizationPopupMenu = null;
    private Map<String, Component> organizationComponentMap = new HashMap<String, Component>();
    private JTextArea organizationComment = new JTextArea();
    private JCheckBox organizationInUse = new JCheckBox();
    private BankAccount bankAccount = null;
    private JPanel bankAccountEditorPanel = null;
    private JPopupMenu bankAccountPopupMenu = null;
    private Map<String, Component> bankAccountComponentMap = new HashMap<String, Component>();
    private JCheckBox bankAccountInUse = new JCheckBox();
    private JTextArea bankAccountComment = new JTextArea();
    private BGUComboBox<PaymentType> paymentType = new BGUComboBox();
    private BillService billService = null;
    private ComponentAdapter componentAdapter = null;
    private DefaultListModel<OrgListItem> listModel = new DefaultListModel();
    private JList<OrgListItem> list = new JList<OrgListItem>(this.listModel);
    private OrgListItemCellRenderer listItemCellRenderer = new OrgListItemCellRenderer();
    private String[][] organizationFields = new String[][]{{"form", "\u041f\u0440\u0430\u0432\u043e\u0432\u0430\u044f \u0444\u043e\u0440\u043c\u0430"}, {"name", "\u041d\u0430\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"}, {"directorPost", "\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f"}, {"directorFIO", "\u0424\u0418\u041e \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f"}, {"inn", "\u0418\u041d\u041d"}, {"kpp", "\u041a\u041f\u041f"}, {"address", "\u0410\u0434\u0440\u0435\u0441"}, {"email", "E-mail"}, {"phone", "\u0422\u0435\u043b\u0435\u0444\u043e\u043d"}, {"site", "\u0421\u0430\u0439\u0442"}};

    public OrganizationAccountManagerPanel() {
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(this.listItemCellRenderer);
        this.list.setDragEnabled(true);
        this.list.setDropMode(DropMode.ON);
        this.list.setTransferHandler(new ListTransferHandler(this));
        this.componentAdapter = new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent event) {
                OrganizationAccountManagerPanel.this.list.setEnabled(true);
                OrganizationAccountManagerPanel.this.trySetData();
            }

            @Override
            public void componentShown(ComponentEvent event) {
                OrganizationAccountManagerPanel.this.list.setEnabled(false);
                super.componentShown(event);
            }
        };
        this.jbInit();
    }

    protected JList<OrgListItem> getList() {
        return this.list;
    }

    protected DefaultListModel<OrgListItem> getListModel() {
        return this.listModel;
    }

    private BillService getBillService() {
        if (this.billService == null) {
            this.billService = (BillService)this.getContext().getPort(BillService.class, this.getModuleId());
        }
        return this.billService;
    }

    protected void updateBankAccount(BankAccount bankAccount) {
        try {
            this.getBillService().updateBankAccount(bankAccount);
            this.setData();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() {
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() == 2) {
                    OrganizationAccountManagerPanel.this.editItem();
                } else if (SwingUtilities.isRightMouseButton(event) && OrganizationAccountManagerPanel.this.list.getSelectedIndex() == OrganizationAccountManagerPanel.this.list.locationToIndex(event.getPoint())) {
                    OrgListItem orgListItem = OrganizationAccountManagerPanel.this.list.getSelectedValue();
                    if (orgListItem.getItemType().equals((Object)OrgListItemType.ORG)) {
                        if (orgListItem.getOrganization().getId() > 0 && !orgListItem.getOrganization().isDefaultOrganization()) {
                            OrganizationAccountManagerPanel.this.getOrganizationPopupMenu().show(OrganizationAccountManagerPanel.this.list, event.getX(), event.getY());
                        }
                    } else if (orgListItem.getBankAccount().getId() > 0 && !orgListItem.getBankAccount().isDefaultAccount()) {
                        OrganizationAccountManagerPanel.this.getBankAccountPopupMenu().show(OrganizationAccountManagerPanel.this.list, event.getX(), event.getY());
                    }
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane(this.list), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getBankAccountEditorPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getOrganizationEditorPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getOrganizationEditorPanel() {
        if (this.organizationEditorPanel == null) {
            this.organizationComment.setLineWrap(true);
            this.organizationComment.setWrapStyleWord(true);
            BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
            okCancelPanel.addActionListener(e -> this.stopOrganizationEdit(e.getActionCommand().equals("ok")));
            int gridx = 0;
            JPanel leftPanel = new JPanel(new GridBagLayout());
            leftPanel.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u043e\u0432 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438"));
            this.organizationComponentMap.put("title", (Component)new BGTextField());
            gridx = this.addToPanel(gridx, "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", this.organizationComponentMap.get("title"), leftPanel);
            for (String[] fieldData : this.organizationFields) {
                this.organizationComponentMap.put(fieldData[0], (Component)new BGTextField());
                gridx = this.addToPanel(gridx, fieldData[1], this.organizationComponentMap.get(fieldData[0]), leftPanel);
            }
            gridx = this.addToPanel(gridx, "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f", this.organizationInUse, leftPanel);
            this.organizationEditorPanel = new JPanel(new GridBagLayout());
            this.organizationEditorPanel.setVisible(false);
            this.organizationEditorPanel.addComponentListener(this.componentAdapter);
            this.organizationEditorPanel.add((Component)leftPanel, new GridBagConstraints(0, 0, 1, 1, 0.6, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.organizationEditorPanel.add((Component)this.getCommentPanel(this.organizationComment), new GridBagConstraints(1, 0, 1, 1, 0.4, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.organizationEditorPanel.add((Component)okCancelPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        }
        return this.organizationEditorPanel;
    }

    private JPanel getBankAccountEditorPanel() {
        if (this.bankAccountEditorPanel == null) {
            this.bankAccountComment.setLineWrap(true);
            this.bankAccountComment.setWrapStyleWord(true);
            BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
            okCancelPanel.addActionListener(e -> this.stopBankAccountEdit(e.getActionCommand().equals("ok")));
            int gridx = 0;
            JPanel leftPanel = new JPanel(new GridBagLayout());
            leftPanel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u0430\u043d\u043a. \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u043e\u0432 "));
            this.bankAccountComponentMap.put("title", (Component)new BGTextField());
            gridx = this.addToPanel(gridx, "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", this.bankAccountComponentMap.get("title"), leftPanel);
            this.bankAccountComponentMap.put("bankTitle", (Component)new BGTextField());
            gridx = this.addToPanel(gridx, "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0411\u0430\u043d\u043a\u0430", this.bankAccountComponentMap.get("bankTitle"), leftPanel);
            this.bankAccountComponentMap.put("account", (Component)new BGTextField());
            gridx = this.addToPanel(gridx, "\u0421\u0447\u0435\u0442", this.bankAccountComponentMap.get("account"), leftPanel);
            this.bankAccountComponentMap.put("bik", (Component)new BGTextField());
            gridx = this.addToPanel(gridx, "\u0411\u0418\u041a", this.bankAccountComponentMap.get("bik"), leftPanel);
            this.bankAccountComponentMap.put("corrAccount", (Component)new BGTextField());
            gridx = this.addToPanel(gridx, "\u041a\u043e\u0440. \u0441\u0447\u0435\u0442", this.bankAccountComponentMap.get("corrAccount"), leftPanel);
            gridx = this.addToPanel(gridx, "\u0422\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430", (Component)this.paymentType, leftPanel);
            gridx = this.addToPanel(gridx, "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f", this.bankAccountInUse, leftPanel);
            this.bankAccountEditorPanel = new JPanel(new GridBagLayout());
            this.bankAccountEditorPanel.setVisible(false);
            this.bankAccountEditorPanel.addComponentListener(this.componentAdapter);
            this.bankAccountEditorPanel.add((Component)leftPanel, new GridBagConstraints(0, 0, 1, 1, 0.6, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.bankAccountEditorPanel.add((Component)this.getCommentPanel(this.bankAccountComment), new GridBagConstraints(1, 0, 1, 1, 0.4, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.bankAccountEditorPanel.add((Component)okCancelPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        }
        return this.bankAccountEditorPanel;
    }

    private int addToPanel(int gridx, String title, Component component, JPanel panel) {
        panel.add((Component)new JLabel(title), new GridBagConstraints(0, gridx, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add(component, new GridBagConstraints(1, gridx, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        return ++gridx;
    }

    private JPanel getCommentPanel(Component component) {
        if (component instanceof JTextArea) {
            ((JTextArea)component).setMargin(new Insets(3, 3, 3, 3));
        }
        Dimension dimension = new Dimension(300, 100);
        JScrollPane scrollPane = new JScrollPane(component);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPopupMenu getOrganizationPopupMenu() {
        if (this.organizationPopupMenu == null) {
            this.organizationPopupMenu = new JPopupMenu();
            this.organizationPopupMenu.add("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e").addActionListener(e -> {
                OrgListItem orgListItem = this.list.getSelectedValue();
                if (orgListItem.getItemType().equals((Object)OrgListItemType.ORG)) {
                    this.tryCall(() -> {
                        this.getBillService().setDefaultOrganization(orgListItem.getOrganization().getId());
                        this.setData();
                    });
                }
            });
        }
        return this.organizationPopupMenu;
    }

    private JPopupMenu getBankAccountPopupMenu() {
        if (this.bankAccountPopupMenu == null) {
            this.bankAccountPopupMenu = new JPopupMenu();
            this.bankAccountPopupMenu.add("\u0421\u0447\u0435\u0442 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e").addActionListener(e -> {
                OrgListItem orgListItem = this.list.getSelectedValue();
                if (orgListItem.getItemType().equals((Object)OrgListItemType.ORG_ACCOUNT)) {
                    this.tryCall(() -> {
                        this.getBillService().setDefaultBankAccount(orgListItem.getBankAccount());
                        this.setData();
                    });
                }
            });
        }
        return this.bankAccountPopupMenu;
    }

    public void setData() throws Exception {
        OrgListItem orgListItem;
        List organizationList = this.getBillService().getOrganizationList();
        List bankAccountList = this.getBillService().getBankAccountList(-1, null);
        ArrayList<BankAccount> unlinkBankAccountList = new ArrayList<BankAccount>();
        this.listModel.clear();
        for (Organization organization : organizationList) {
            OrgListItem orgListItem2 = new OrgListItem();
            orgListItem2.setItemType(OrgListItemType.ORG);
            orgListItem2.setOrganization(organization);
            this.listModel.addElement(orgListItem2);
            this.listModel.addElement(this.getAddBankAccountItem(organization.getId()));
        }
        for (BankAccount bankAccount : bankAccountList) {
            boolean orgOk = false;
            int orgId = bankAccount.getOrganizationId();
            for (int index = 0; index < this.listModel.getSize(); ++index) {
                OrgListItem orgListItem3 = this.listModel.elementAt(index);
                if (orgListItem3.getItemType().equals((Object)OrgListItemType.ORG) && orgListItem3.getOrganization().getId() == orgId) {
                    orgOk = true;
                    continue;
                }
                if (!orgOk || !orgListItem3.getItemType().equals((Object)OrgListItemType.ORG_ACCOUNT) || orgListItem3.getBankAccount().getId() != -1) continue;
                OrgListItem bankOrgListItem = new OrgListItem();
                bankOrgListItem.setItemType(OrgListItemType.ORG_ACCOUNT);
                bankOrgListItem.setBankAccount(bankAccount);
                this.listModel.add(index, bankOrgListItem);
                break;
            }
            if (orgOk) continue;
            unlinkBankAccountList.add(bankAccount);
        }
        if (!unlinkBankAccountList.isEmpty()) {
            orgListItem = new OrgListItem();
            orgListItem.setItemType(OrgListItemType.ORG);
            orgListItem.setOrganization(Organization.builder().setId(0).setTitle("  < \u041d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0441\u0447\u0435\u0442\u0430, \u0434\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0438 \u043f\u0435\u0440\u0435\u0442\u0430\u0449\u0438\u0442\u0435 \u0441\u0447\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0438 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0439 ->").build());
            this.listModel.add(0, orgListItem);
            int index = 1;
            for (BankAccount bankAccount : unlinkBankAccountList) {
                orgListItem = new OrgListItem();
                orgListItem.setItemType(OrgListItemType.ORG_ACCOUNT);
                orgListItem.setBankAccount(bankAccount);
                this.listModel.add(index++, orgListItem);
            }
        }
        orgListItem = new OrgListItem();
        orgListItem.setItemType(OrgListItemType.ORG);
        orgListItem.setOrganization(Organization.builder().setId(-1).setTitle("  < \u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u0443\u044e \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044e >").build());
        this.listModel.addElement(orgListItem);
    }

    private OrgListItem getAddBankAccountItem(int organizationId) {
        OrgListItem addOrgListItem = new OrgListItem();
        addOrgListItem.setItemType(OrgListItemType.ORG_ACCOUNT);
        addOrgListItem.setBankAccount(BankAccount.builder().setId(-1).setOrganizationId(organizationId).setTitle("  < \u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0441\u0447\u0435\u0442 >").build());
        return addOrgListItem;
    }

    private void stopOrganizationEdit(boolean save) {
        if (save) {
            this.organization.setTitle(((BGTextField)this.organizationComponentMap.get("title")).getText());
            JSONObject jsonObject = new JSONObject();
            for (String[] fieldData : this.organizationFields) {
                jsonObject.put(fieldData[0], (Object)((BGTextField)this.organizationComponentMap.get(fieldData[0])).getText());
            }
            this.organization.setData(jsonObject.toString());
            this.organization.setComment(this.organizationComment.getText());
            this.organization.setInUse(this.organizationInUse.isSelected());
            try {
                this.getBillService().updateOrganization(this.organization);
                this.organizationEditorPanel.setVisible(false);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        } else {
            this.organizationEditorPanel.setVisible(false);
        }
    }

    private void stopBankAccountEdit(boolean save) {
        if (save) {
            IdTitle item = (IdTitle)this.paymentType.getSelectedItem();
            if (item == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0438\u0440\u0435\u0442\u0435 \u0442\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430! \u0415\u0441\u043b\u0438 \u0441\u043f\u0438\u0441\u043e\u043a \u043f\u0443\u0441\u0442\u043e\u0439,\n\u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0435\u0441\u0442\u044c \u043b\u0438 \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \"\u0442\u0438\u043f\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439\"\n\"\u0442\u0438\u043f\u044b\" \u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u043c \u0444\u043b\u0430\u0433\u043e\u043c \"\u043d\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0439\"");
                return;
            }
            if (Utils.isEmptyString((String)((BGTextField)this.bankAccountComponentMap.get("title")).getText().trim()) || Utils.isEmptyString((String)((BGTextField)this.bankAccountComponentMap.get("bankTitle")).getText().trim()) || Utils.isEmptyString((String)((BGTextField)this.bankAccountComponentMap.get("account")).getText().trim()) || Utils.isEmptyString((String)((BGTextField)this.bankAccountComponentMap.get("bik")).getText().trim()) || Utils.isEmptyString((String)((BGTextField)this.bankAccountComponentMap.get("corrAccount")).getText().trim())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!");
                return;
            }
            this.bankAccount.setTitle(((BGTextField)this.bankAccountComponentMap.get("title")).getText());
            this.bankAccount.setBankTitle(((BGTextField)this.bankAccountComponentMap.get("bankTitle")).getText());
            this.bankAccount.setAccount(((BGTextField)this.bankAccountComponentMap.get("account")).getText());
            this.bankAccount.setBankIdentificationCode(((BGTextField)this.bankAccountComponentMap.get("bik")).getText());
            this.bankAccount.setCorrespondentAccount(((BGTextField)this.bankAccountComponentMap.get("corrAccount")).getText());
            this.bankAccount.setGroupMask(0L);
            this.bankAccount.setComment(this.bankAccountComment.getText());
            this.bankAccount.setPaymentTypeId(item.getId());
            this.bankAccount.setInUse(this.bankAccountInUse.isSelected());
            try {
                this.getBillService().updateBankAccount(this.bankAccount);
                this.bankAccountEditorPanel.setVisible(false);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        } else {
            this.bankAccountEditorPanel.setVisible(false);
        }
    }

    public void deleteItem() {
        Organization organization = this.list.getSelectedValue().getOrganization();
        BankAccount bankAccount = this.list.getSelectedValue().getBankAccount();
        if (organization != null) {
            if (organization.isDefaultOrganization()) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044e \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c \"" + organization.getTitle() + "\"?", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0, 3) != 0) {
                return;
            }
            try {
                this.getBillService().deleteOrganization(organization.getId());
                this.stopOrganizationEdit(false);
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        } else if (bankAccount != null) {
            if (bankAccount.isDefaultAccount()) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0447\u0435\u0442 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c \"" + bankAccount.getTitle() + "\"?", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0, 3) != 0) {
                return;
            }
            try {
                this.getBillService().deleteBankAccount(bankAccount.getId());
                this.stopBankAccountEdit(false);
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    public void editItem() {
        this.bankAccount = this.list.getSelectedValue().getBankAccount();
        this.organization = this.list.getSelectedValue().getOrganization();
        if (this.bankAccount != null) {
            this.startBankAccountEdit();
        } else if (this.organization != null) {
            this.startOrganizationEdit();
        }
    }

    public void newItem() {
        this.organization = new Organization();
        this.startOrganizationEdit();
    }

    private void startOrganizationEdit() {
        ((BGTextField)this.organizationComponentMap.get("title")).setText(this.organization.getId() == -1 ? "" : this.organization.getTitle());
        JSONObject jsonObject = new JSONObject(this.organization.getData());
        for (String[] fieldData : this.organizationFields) {
            if ("title".equals(fieldData[0])) continue;
            ((BGTextField)this.organizationComponentMap.get(fieldData[0])).setText(jsonObject.optString(fieldData[0], ""));
        }
        this.organizationComment.setText(this.organization.getComment());
        this.organizationInUse.setSelected(this.organization.isInUse());
        this.organizationEditorPanel.setVisible(true);
    }

    private void startBankAccountEdit() {
        try {
            this.paymentType.setData(this.getContext().getDirectory(PaymentType.class, 0).list());
            if (this.bankAccount.getId() > 0) {
                this.bankAccount = this.getBillService().getBankAccount(this.bankAccount.getId());
            }
            ((BGTextField)this.bankAccountComponentMap.get("title")).setText(this.bankAccount.getId() == -1 ? "" : this.bankAccount.getTitle());
            ((BGTextField)this.bankAccountComponentMap.get("bankTitle")).setText(this.bankAccount.getBankTitle());
            ((BGTextField)this.bankAccountComponentMap.get("account")).setText(this.bankAccount.getAccount());
            ((BGTextField)this.bankAccountComponentMap.get("bik")).setText(this.bankAccount.getBankIdentificationCode());
            ((BGTextField)this.bankAccountComponentMap.get("corrAccount")).setText(this.bankAccount.getCorrespondentAccount());
            this.bankAccountComment.setText(this.bankAccount.getComment());
            this.paymentType.setSelectedItem((Object)this.bankAccount.getPaymentTypeId());
            this.bankAccountInUse.setSelected(this.bankAccount.isInUse());
            this.bankAccountEditorPanel.setVisible(true);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }
}

