/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cladr.server.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.plugins.cladr.common.model.CladrAddress;
import ru.bitel.bgbilling.plugins.cladr.common.model.CladrHouse;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class AddressDBFDAO
extends BGLogger {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SOCR = "socr";
    private static final String FIELD_CODE = "code";
    private static final String FIELD_INDEX = "index";
    private static final String FIELD_GNINMB = "gninmb";
    private static final String FIELD_UNO = "uno";
    private static final String FIELD_OCATO = "ocatd";
    private static final String TABLE_DOMA = "cladr_i_doma";
    private static final String TABLE_KLADR = "cladr_i_kladr";
    private static final String TABLE_STREET = "cladr_i_street";
    private Connection con = null;

    public AddressDBFDAO(Connection con) {
        this.con = con;
    }

    public void addIndex() throws SQLException {
        Statement st;
        if (ServerUtils.tableExists((Connection)this.con, (String)TABLE_KLADR)) {
            try {
                st = this.con.createStatement();
                try {
                    st.execute("DROP INDEX `ikladr` ON `cladr_i_kladr`");
                }
                finally {
                    if (st != null) {
                        st.close();
                    }
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
            st = this.con.createStatement();
            try {
                st.execute("CREATE INDEX `ikladr` ON `cladr_i_kladr` (`CODE` ASC)");
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
        if (ServerUtils.tableExists((Connection)this.con, (String)TABLE_STREET)) {
            try {
                st = this.con.createStatement();
                try {
                    st.execute("DROP INDEX `istreet` ON `cladr_i_street`");
                }
                finally {
                    if (st != null) {
                        st.close();
                    }
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
            st = this.con.createStatement();
            try {
                st.execute("CREATE INDEX `istreet` ON `cladr_i_street` (`CODE` ASC)");
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
    }

    public List<String> getCodesBySearchString(String[] words) throws SQLException {
        ArrayList<String> codes = new ArrayList<String>();
        if (ServerUtils.tableExists((Connection)this.con, (String)TABLE_KLADR)) {
            try {
                StringBuilder where = new StringBuilder();
                boolean first = true;
                for (String word : words) {
                    if (first) {
                        where.append(" name like '%" + this.wordToCononicalFormat(word) + "%' ");
                        first = false;
                        continue;
                    }
                    where.append(" OR name like '%" + this.wordToCononicalFormat(word) + "%' ");
                }
                String query = "SELECT code FROM cladr_i_kladr WHERE " + where;
                Statement st = this.con.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    String code = rs.getString(FIELD_CODE);
                    String aa = code.substring(11, 13);
                    if (!aa.equals("00")) continue;
                    codes.add(code);
                }
                rs.close();
                st.close();
            }
            catch (SQLException ex) {
                this.logError(ex);
                throw ex;
            }
        }
        return codes;
    }

    public CladrAddress getAddressByCode(String code) throws SQLException {
        CladrAddress res = null;
        if (ServerUtils.tableExists((Connection)this.con, (String)TABLE_KLADR)) {
            try {
                String query = "SELECT * FROM cladr_i_kladr WHERE code='" + code + "'";
                Statement st = this.con.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    res = new CladrAddress();
                    this.setAddressData(rs, res);
                }
                st.close();
            }
            catch (SQLException ex) {
                this.logError(ex);
                throw ex;
            }
        }
        return res;
    }

    public CladrAddress getAddressLevelByCode(String code, int level) throws SQLException {
        CladrAddress res = null;
        if (ServerUtils.tableExists((Connection)this.con, (String)TABLE_KLADR)) {
            String ss = code.substring(0, 2);
            String rrr = level > 1 ? code.substring(2, 5) : "000";
            String ggg = level > 2 ? code.substring(5, 8) : "000";
            String ppp = level > 3 ? code.substring(8, 11) : "000";
            String query = "SELECT * FROM cladr_i_kladr WHERE code='" + ss + rrr + ggg + ppp + "00'";
            try (Statement st = this.con.createStatement();
                 ResultSet rs = st.executeQuery(query);){
                while (rs.next()) {
                    res = new CladrAddress();
                    this.setAddressData(rs, res);
                }
            }
            catch (SQLException ex) {
                this.logError(ex);
                throw ex;
            }
        }
        return res;
    }

    public List<CladrAddress> getStreetByCode(String code) throws SQLException {
        ArrayList<CladrAddress> res = new ArrayList<CladrAddress>();
        if (ServerUtils.tableExists((Connection)this.con, (String)TABLE_STREET)) {
            try {
                String query = "SELECT * FROM cladr_i_street WHERE code like '" + code.substring(0, 11) + "____00'";
                Statement st = this.con.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    CladrAddress address = new CladrAddress();
                    this.setAddressData(rs, address);
                    res.add(address);
                }
                st.close();
            }
            catch (SQLException ex) {
                this.logError(ex);
                throw ex;
            }
        }
        return res;
    }

    public List<CladrAddress> getStreetByTitleWord(String code, String[] words) throws SQLException {
        ArrayList<CladrAddress> res = new ArrayList<CladrAddress>();
        if (ServerUtils.tableExists((Connection)this.con, (String)TABLE_STREET)) {
            try {
                StringBuilder where = new StringBuilder();
                boolean first = true;
                for (String word : words) {
                    if (first) {
                        where.append(" name like '%" + this.wordToCononicalFormat(word) + "%' ");
                        first = false;
                        continue;
                    }
                    where.append(" OR name like '%" + this.wordToCononicalFormat(word) + "%' ");
                }
                String query = "SELECT * FROM cladr_i_street WHERE code like '" + code.substring(0, 11) + "____00' AND (" + where.toString() + ")";
                Statement st = this.con.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    CladrAddress address = new CladrAddress();
                    this.setAddressData(rs, address);
                    res.add(address);
                }
                st.close();
            }
            catch (SQLException ex) {
                this.logError(ex);
                throw ex;
            }
        }
        return res;
    }

    private void setAddressData(ResultSet rs, CladrAddress address) throws SQLException {
        address.setCode(rs.getString(FIELD_CODE));
        address.setSocr(rs.getString(FIELD_SOCR));
        address.setName(rs.getString(FIELD_NAME));
        address.setIndex(rs.getString(FIELD_INDEX));
        address.setGNINMB(rs.getString(FIELD_GNINMB));
        address.setUNO(rs.getString(FIELD_UNO));
        address.setOCATO(rs.getString(FIELD_OCATO));
    }

    public List<CladrHouse> getHouseByCode(String code) throws SQLException {
        ArrayList<CladrHouse> res = new ArrayList<CladrHouse>();
        if (ServerUtils.tableExists((Connection)this.con, (String)TABLE_DOMA)) {
            try {
                String query = "SELECT * FROM cladr_i_doma WHERE code like '" + code.substring(0, 11) + "________'";
                Statement st = this.con.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    CladrHouse house = new CladrHouse();
                    house.setCode(rs.getString(FIELD_CODE));
                    house.setName(rs.getString(FIELD_NAME));
                    house.setIndex(rs.getString(FIELD_INDEX));
                    res.add(house);
                }
                st.close();
            }
            catch (SQLException ex) {
                this.logError(ex);
                throw ex;
            }
        }
        return res;
    }

    private String wordToCononicalFormat(String word) {
        if (word.length() <= 0) {
            return word;
        }
        StringBuilder res = new StringBuilder();
        res.append(word.toLowerCase());
        res.replace(0, 1, res.substring(0, 1).toUpperCase());
        return res.toString();
    }
}

