/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.bean.event;

import jakarta.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;

@XmlRootElement
public class TopicWasUpdatedEvent
extends QueueEvent {
    private Topic oldTopic;
    private Topic newTopic;

    public TopicWasUpdatedEvent() {
    }

    public TopicWasUpdatedEvent(Topic oldTopic, int pluginId, Topic newTopic) {
        super(NO_MODULE, pluginId, newTopic.getContractId(), -1);
        this.oldTopic = oldTopic;
        this.newTopic = newTopic;
    }

    public Topic getOldTopic() {
        return this.oldTopic;
    }

    public void setOldTopic(Topic oldTopic) {
        this.oldTopic = oldTopic;
    }

    public Topic getNewTopic() {
        return this.newTopic;
    }

    public void setNewTopic(Topic newTopic) {
        this.newTopic = newTopic;
    }

    public boolean wasCreated() {
        return this.oldTopic == null;
    }

    public boolean isSumChange() {
        return this.oldTopic != null && this.oldTopic.getCost() != null && this.newTopic.getCost() != null && this.oldTopic.getCost().compareTo(this.newTopic.getCost()) != 0;
    }

    public boolean wasClosed() {
        return this.oldTopic != null && this.newTopic.isClosed() && !this.oldTopic.isClosed();
    }

    public boolean wasOpened() {
        return this.oldTopic != null && !this.newTopic.isClosed() && this.oldTopic.isClosed();
    }
}

