/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.servlet;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebInitParam;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import ru.bitel.bgbilling.kernel.base.server.wrapper.MultipartWrapper;

@WebFilter(filterName="mobileSetCharacterEncoding", urlPatterns={"/mobapi/*"}, initParams={@WebInitParam(name="encoding", value="UTF-8")})
public class SetCharacterEncodingFilter
extends ru.bitel.bgbilling.kernel.base.server.filters.SetCharacterEncodingFilter {
    private ServletContext servletContext = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String encoding = this.selectEncoding(servletRequest);
        servletRequest.setCharacterEncoding(encoding != null ? encoding : "UTF-8");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String type = request.getHeader("Content-Type");
        if (type != null && type.startsWith("multipart/form-data")) {
            File tempdir = (File)this.servletContext.getAttribute("jakarta.servlet.context.tempdir");
            servletRequest = new MultipartWrapper(request, tempdir.getAbsolutePath());
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
        this.servletContext = null;
    }
}

