/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.mikrotik;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class AnonymousSocketFactory
extends SocketFactory {
    private static AnonymousSocketFactory fact;

    @Override
    public Socket createSocket() throws IOException {
        return this.fixSocket((SSLSocket)SSLSocketFactory.getDefault().createSocket());
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.fixSocket((SSLSocket)SSLSocketFactory.getDefault().createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.fixSocket((SSLSocket)SSLSocketFactory.getDefault().createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.fixSocket((SSLSocket)SSLSocketFactory.getDefault().createSocket(address, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.fixSocket((SSLSocket)SSLSocketFactory.getDefault().createSocket(address, port, localAddress, localPort));
    }

    private Socket fixSocket(SSLSocket ssl) {
        ArrayList<String> cs = new ArrayList<String>(4);
        for (String s : ssl.getSupportedCipherSuites()) {
            if (!s.startsWith("TLS_DH_anon")) continue;
            cs.add(s);
        }
        ssl.setEnabledCipherSuites(cs.toArray(new String[0]));
        return ssl;
    }

    public static SocketFactory getDefault() {
        if (fact == null) {
            fact = new AnonymousSocketFactory();
        }
        return fact;
    }

    private AnonymousSocketFactory() {
    }
}

