/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.mail;

import jakarta.mail.MessagingException;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;

public class MailMessageNotification
extends MailData {
    private Topic topic;

    public MailMessageNotification() {
        super("message.notification");
    }

    public Topic getTopic() {
        return this.topic;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MailMessageNotification notification = new MailMessageNotification();

        private Builder() {
        }

        public Builder setTopic(Topic topic) {
            this.notification.topic = topic;
            return this;
        }

        public Builder setRecipients(String recipients) {
            this.notification.setRecipients(recipients);
            return this;
        }

        public Builder setSubject(String subject) {
            this.notification.setSubject(subject);
            return this;
        }

        public Builder addTextPart(String key, String text) throws MessagingException {
            this.notification.addTextPart(key, text);
            return this;
        }

        public MailMessageNotification build() {
            try {
                MailMessageNotification mailMessageNotification = this.notification;
                return mailMessageNotification;
            }
            finally {
                this.notification = null;
            }
        }
    }
}

