/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server;

import bitel.billing.server.load.bean.Source;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.phone.server.LogRecord;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;

public class DBProcessIn
extends bitel.billing.server.load.DBProcessIn {
    private static Logger log = LogManager.getLogger((String)"dataloader");
    private boolean useCallCost;
    private boolean useCallOperCost;

    public DBProcessIn(Setup setup, Source source, Calendar hour, Connection con) {
        super(setup, source, hour, con);
    }

    protected String getColumns() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            this.useCallCost = ServerUtils.columnExist((Connection)con, (String)this.tableName, (String)"call_client_cost");
            this.useCallOperCost = ServerUtils.columnExist((Connection)con, (String)this.tableName, (String)"call_oper_cost");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
        Object columns = "id, session_start, session_time, from_number, from_number_164, to_number, to_number_164, from_port, to_port, cat, connect_time";
        if (this.useCallCost) {
            columns = (String)columns + ", call_client_cost";
        }
        if (this.useCallOperCost) {
            columns = (String)columns + ", call_oper_cost";
        }
        return columns;
    }

    public Object getRecord() {
        LogRecord record = null;
        try {
            if (this.rs == null || !this.rs.next()) {
                return null;
            }
            record = new LogRecord();
            record.id = this.rs.getInt(1);
            record.sessionStart = TimeUtils.convertTimestampToCalendar((Timestamp)this.rs.getTimestamp(2));
            record.sessionTime = this.rs.getInt(3);
            record.fromNumber = this.rs.getString(4).trim();
            record.fromNumber164 = this.rs.getString(5).trim();
            record.toNumber = this.rs.getString(6).trim();
            record.toNumber164 = this.rs.getString(7).trim();
            record.fromPort = this.rs.getString(8).trim();
            record.toPort = this.rs.getString(9).trim();
            record.category = this.rs.getInt(10);
            record.connectTime = this.rs.getInt(11);
            if (this.useCallCost) {
                record.callClientCost = this.rs.getBigDecimal(12);
                if (this.useCallOperCost) {
                    record.callOperCost = this.rs.getBigDecimal(13);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return record;
    }

    protected String getOrder() {
        return " ORDER BY session_start";
    }
}

