/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.flow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.reports.AbstractJRDataSource;

public class FlowAnalyzer {
    private final Map<IpAddress, FlowAnalizerEntry> entries = new HashMap<IpAddress, FlowAnalizerEntry>(256);
    private static final Comparator<FlowAnalizerEntry> COMPARATOR = new Comparator<FlowAnalizerEntry>(){

        @Override
        public int compare(FlowAnalizerEntry o1, FlowAnalizerEntry o2) {
            if (o2.input.octets > o1.input.octets) {
                return 1;
            }
            if (o2.input.octets == o1.input.octets) {
                return 0;
            }
            return -1;
        }
    };

    public Void input(IpAddress ip, Data flow) {
        FlowAnalizerEntry e = this.entries.get(ip);
        if (e == null) {
            ip = ip.clone();
            e = new FlowAnalizerEntry(ip);
            this.entries.put(ip, e);
        }
        this.add(e.input, flow.getProtocol(), flow.getSrcPort(), flow.getDstPort(), flow.getOctets());
        return null;
    }

    public Void output(IpAddress ip, Data flow) {
        FlowAnalizerEntry e = this.entries.get(ip);
        if (e == null) {
            ip = ip.clone();
            e = new FlowAnalizerEntry(ip);
            this.entries.put(ip, e);
        }
        this.add(e.output, flow.getProtocol(), flow.getDstPort(), flow.getSrcPort(), flow.getOctets());
        return null;
    }

    private void add(FlowAnalizerOctets e, int protocol, int port1, int port2, long octets) {
        e.octets += octets;
        block0 : switch (protocol) {
            case 1: {
                e.octetsIcmp += octets;
                break;
            }
            case 0: 
            case 6: {
                e.octetsTcp += octets;
                switch (port1) {
                    case 80: 
                    case 443: 
                    case 8080: 
                    case 8443: {
                        e.octetsTcpHttp += octets;
                        break block0;
                    }
                    case 25: 
                    case 465: {
                        e.octetsTcpSmtp += octets;
                        break block0;
                    }
                    case 143: 
                    case 585: 
                    case 993: {
                        e.octetsTcpImap += octets;
                        break block0;
                    }
                    case 110: 
                    case 995: {
                        e.octetsTcpPop3 += octets;
                        break block0;
                    }
                    case 20: 
                    case 21: 
                    case 990: {
                        e.octetsTcpFtp += octets;
                        break block0;
                    }
                }
                switch (port2) {
                    case 80: 
                    case 443: 
                    case 8080: 
                    case 8443: {
                        e.octetsTcpHttp += octets;
                        break block0;
                    }
                    case 25: 
                    case 465: {
                        e.octetsTcpSmtp += octets;
                    }
                    case 143: 
                    case 585: 
                    case 993: {
                        e.octetsTcpImap += octets;
                    }
                    case 110: 
                    case 995: {
                        e.octetsTcpPop3 += octets;
                        break block0;
                    }
                    case 20: 
                    case 21: 
                    case 990: {
                        e.octetsTcpFtp += octets;
                        break block0;
                    }
                }
                break;
            }
            case 17: {
                e.octetsUdp += octets;
                switch (port1) {
                    case 42: 
                    case 43: 
                    case 53: {
                        e.octetsUdpNamed += octets;
                        break block0;
                    }
                }
                switch (port2) {
                    case 42: 
                    case 43: 
                    case 53: {
                        e.octetsUdpNamed += octets;
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public Collection<FlowAnalizerEntry> get() {
        ArrayList<FlowAnalizerEntry> result = new ArrayList<FlowAnalizerEntry>(this.entries.values());
        Collections.sort(result, COMPARATOR);
        return result;
    }

    public JRRewindableDataSource getDataSource() {
        return new AbstractJRDataSource.AbstractCollectionJRDataSource<FlowAnalizerEntry>(this.get()){

            protected AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object> newField(JRField jrField) {
                String name = jrField.getName();
                if ("ip".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public IpAddress getValue(FlowAnalizerEntry val) throws JRException {
                            return val.ip;
                        }
                    };
                }
                if ("inputOctets".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.input.octets;
                        }
                    };
                }
                if ("inputOctetsIcmp".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.input.octetsIcmp;
                        }
                    };
                }
                if ("inputOctetsTcp".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.input.octetsTcp;
                        }
                    };
                }
                if ("inputOctetsTcpHttp".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.input.octetsTcpHttp;
                        }
                    };
                }
                if ("inputOctetsTcpSmtp".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.input.octetsTcpSmtp;
                        }
                    };
                }
                if ("inputOctetsTcpPop3".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.input.octetsTcpPop3;
                        }
                    };
                }
                if ("inputOctetsTcpImap".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.input.octetsTcpImap;
                        }
                    };
                }
                if ("inputOctetsTcpFtp".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.input.octetsTcpFtp;
                        }
                    };
                }
                if ("inputOctetsTcpOther".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.input.octetsTcp - val.input.octetsTcpHttp - val.input.octetsTcpSmtp - val.input.octetsTcpPop3 - val.input.octetsTcpImap - val.input.octetsTcpFtp;
                        }
                    };
                }
                if ("inputOctetsUdp".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.input.octetsUdp;
                        }
                    };
                }
                if ("inputOctetsUdpNamed".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.input.octetsUdpNamed;
                        }
                    };
                }
                if ("inputOctetsOther".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.input.octets - val.input.octetsIcmp - val.input.octetsTcp - val.input.octetsUdp;
                        }
                    };
                }
                if ("outputOctets".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.output.octets;
                        }
                    };
                }
                if ("outputOctetsIcmp".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.output.octetsIcmp;
                        }
                    };
                }
                if ("outputOctetsTcp".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.output.octetsTcp;
                        }
                    };
                }
                if ("outputOctetsTcpHttp".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.output.octetsTcpHttp;
                        }
                    };
                }
                if ("outputOctetsTcpSmtp".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.output.octetsTcpSmtp;
                        }
                    };
                }
                if ("outputOctetsTcpPop3".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.output.octetsTcpPop3;
                        }
                    };
                }
                if ("outputOctetsTcpImap".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.output.octetsTcpImap;
                        }
                    };
                }
                if ("outputOctetsTcpFtp".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.output.octetsTcpFtp;
                        }
                    };
                }
                if ("outputOctetsTcpOther".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.output.octetsTcp - val.output.octetsTcpHttp - val.output.octetsTcpSmtp - val.output.octetsTcpPop3 - val.output.octetsTcpImap - val.output.octetsTcpFtp;
                        }
                    };
                }
                if ("outputOctetsUdp".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.output.octetsUdp;
                        }
                    };
                }
                if ("outputOctetsUdpNamed".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.output.octetsUdpNamed;
                        }
                    };
                }
                if ("outputOctetsOther".equals(name)) {
                    return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                        public Long getValue(FlowAnalizerEntry val) throws JRException {
                            return val.output.octets - val.output.octetsIcmp - val.output.octetsTcp - val.output.octetsUdp;
                        }
                    };
                }
                return new AbstractJRDataSource.JRDataSourceField<FlowAnalizerEntry, Object>(){

                    public Object getValue(FlowAnalizerEntry val) throws JRException {
                        return null;
                    }
                };
            }
        };
    }

    public void clear() {
        this.entries.clear();
    }

    public int size() {
        return this.entries.size();
    }

    public class FlowAnalizerEntry {
        public final IpAddress ip;
        public final FlowAnalizerOctets input;
        public final FlowAnalizerOctets output;

        protected FlowAnalizerEntry(IpAddress ip) {
            this.input = new FlowAnalizerOctets();
            this.output = new FlowAnalizerOctets();
            this.ip = ip;
        }
    }

    public class FlowAnalizerOctets {
        private long octets;
        private long octetsTcp;
        private long octetsTcpHttp;
        private long octetsTcpSmtp;
        private long octetsTcpPop3;
        private long octetsTcpImap;
        private long octetsTcpFtp;
        private long octetsUdp;
        private long octetsUdpNamed;
        private long octetsIcmp;

        public long getOctets() {
            return this.octets;
        }

        public long getOctetsTcp() {
            return this.octetsTcp;
        }

        public long getOctetsTcpHttp() {
            return this.octetsTcpHttp;
        }

        public long getOctetsTcpSmtp() {
            return this.octetsTcpSmtp;
        }

        public long getOctetsTcpPop3() {
            return this.octetsTcpPop3;
        }

        public long getOctetsTcpImap() {
            return this.octetsTcpImap;
        }

        public long getOctetsTcpFtp() {
            return this.octetsTcpFtp;
        }

        public long getOctetsUdp() {
            return this.octetsUdp;
        }

        public long getOctetsUdpNamed() {
            return this.octetsUdpNamed;
        }

        public long getOctetsIcmp() {
            return this.octetsIcmp;
        }
    }
}

