/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.server.action.web;

import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionMessage;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeTypeDao;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOptionData;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusBalance;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusCharge;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusContractProgram;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPayment;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgramDynamicBase;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgramSpecification;
import ru.bitel.bgbilling.plugins.bonus.common.service.BonusService;
import ru.bitel.bgbilling.plugins.bonus.server.dao.BonusDao;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

@WebAction(title="\u0411\u043e\u043d\u0443\u0441\u044b")
public class ActionBonus
extends AbstractAction {
    @Resource
    private BonusService service;
    @Resource
    private TariffOptionService tariffOptionService;

    public ActionBonus() {
        super("bonus");
    }

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws Exception {
        this.bonusBalance(new BonusDao(this.con));
        super.execute();
    }

    @WebOperation(title="\u041e\u043f\u043b\u0430\u0442\u0430 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438")
    public void payTariffOption() throws BGException {
        this.bonusBalance(new BonusDao(this.con));
        try {
            int optionId = Utils.parseInt((String)this.req.get("optionId", "0"));
            int modeId = Utils.parseInt((String)this.req.get("modeId", "0"));
            boolean payOnlyBonus = this.isPayOnlyBonus(modeId, optionId);
            TariffOption tariffOption = this.tariffOptionService.tariffOptionGet(optionId);
            TariffOptionActivateMode mode = this.tariffOptionService.tariffOptionActivateModeGet(optionId, modeId);
            this.setResultParam("tariffOptionTitle", tariffOption.getTitle());
            this.setResultParam("titleMode", mode.toString());
            this.setResultParam("sumMode", mode.getChargeSumma());
            this.setResultParam("maxPercent", payOnlyBonus ? 100 : this.service.percentOfBonus(mode.getChargeTypeId()));
            this.setResultParam("comment", tariffOption.getComment());
            BigDecimal sumBonusMax = payOnlyBonus ? mode.getChargeSumma() : this.service.bonusSummaMax(this.contractId, mode.getChargeTypeId(), mode.getChargeSumma(), false);
            this.setResultParam("maxBonusSumMayBePay", Utils.formatCost((BigDecimal)sumBonusMax));
            this.context.getRequest().getSession().setAttribute("optionId", (Object)this.req.get("optionId", "0"));
            this.context.getRequest().getSession().setAttribute("modeId", (Object)this.req.get("modeId", "0"));
        }
        catch (Exception ex) {
            this.logError(ex);
            this.setResultParam("error", "\u041e\u0448\u0438\u0431\u043a\u0430:" + ex.getMessage());
        }
        this.requestDispatcher(this.moduleName, "bonus_tariif_option_popup");
    }

    @WebOperation(title="\u0411\u0430\u043b\u0430\u043d\u0441")
    public void balance() throws BGException {
        this.dinProgramItems(new BonusDao(this.con));
        List balanceList = this.service.balanceList(this.contractId, new Date());
        int number = 1;
        for (BonusBalance elem : balanceList) {
            elem.setId(number++);
        }
        this.setResultParam("bonusBalanceList", balanceList);
        this.requestDispatcher(this.moduleName, "bonus_balance");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u0438")
    public void payments() throws BGException {
        BonusDao bonusDao = new BonusDao(this.con);
        this.dinProgramItems(bonusDao);
        List<BonusPayment> list = bonusDao.getPaymentsAll(this.contractId);
        int number = 1;
        for (BonusPayment elem : list) {
            elem.setId(number++);
        }
        this.setResultParam("bonusPaymentList", list);
        this.requestDispatcher(this.moduleName, "bonus_payments");
    }

    @WebOperation(title="\u0420\u0430\u0441\u0445\u043e\u0434\u044b")
    public void charges() throws BGException {
        BonusDao bonusDao = new BonusDao(this.con);
        this.dinProgramItems(bonusDao);
        List<BonusCharge> list = bonusDao.getChargesAll(this.contractId);
        this.setResultParam("bonusChargeList", list);
        int number = 1;
        try (ChargeTypeDao chargeTypeDao = new ChargeTypeDao(this.con);){
            HashMap<Integer, ChargeType> map = new HashMap<Integer, ChargeType>();
            for (BonusCharge elem : list) {
                elem.setId(number++);
                ChargeType chargeType = (ChargeType)map.get(elem.getTypeId());
                if (chargeType == null) {
                    chargeType = (ChargeType)chargeTypeDao.get(elem.getTypeId());
                    map.put(elem.getTypeId(), chargeType);
                }
                if (chargeType == null) continue;
                elem.setTypeTitle(chargeType.getTitle());
            }
        }
        this.requestDispatcher(this.moduleName, "bonus_charges");
    }

    private void bonusBalance(BonusDao bonusDao) throws BGException {
        this.setResultParam("balance", bonusDao.getBalance(this.contractId, new Date()));
        this.setResultParam("futureBalance", bonusDao.getNotActiveBalanceStill(this.contractId, new Date()));
    }

    private void dinProgramItems(BonusDao bonusDao) throws BGException {
        List<String> programItems = this.getContractParamString(bonusDao);
        if (programItems != null && programItems.size() > 0) {
            this.setResultParam("dinProgramItems", programItems);
        }
    }

    private List<String> getContractParamString(BonusDao bonusDao) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List<BonusContractProgram> bonusPrograms = bonusDao.getProgramCotractList(this.contractId, 2, new Date());
            for (BonusContractProgram program : bonusPrograms) {
                BonusProgramDynamicBase dynamicSpecification;
                List l;
                BonusProgramSpecification specification = bonusDao.getProgramAction(program.getProgram());
                if (specification == null || !(specification instanceof BonusProgramDynamicBase) || (l = (dynamicSpecification = (BonusProgramDynamicBase)specification).getWebBonusStrings(this.con, program)) == null) continue;
                result.addAll(l);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws BGException {
        ActionMessage message = new ActionMessage("tariffOptionRoot", "list", "tariffOptionQuery", "\u041e\u043f\u0446\u0438\u044f \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430");
        try {
            int optionId = Utils.parseInt((String)((String)this.context.getRequest().getSession().getAttribute("optionId")), (int)0);
            int modeId = Utils.parseInt((String)((String)this.context.getRequest().getSession().getAttribute("modeId")), (int)0);
            boolean payOnlyBonus = this.isPayOnlyBonus(modeId, optionId);
            TariffOptionActivateMode mode = this.tariffOptionService.tariffOptionActivateModeGet(optionId, modeId);
            BigDecimal maxBonusRealSumMayBePay = payOnlyBonus ? mode.getChargeSumma() : this.service.bonusSummaMaxAdvanced(this.contractId, mode.getChargeTypeId(), mode.getChargeSumma(), false, null);
            ContractTariffOptionData optionActivate = new ContractTariffOptionData();
            optionActivate.setContractId(this.contractId);
            optionActivate.setOptionId(optionId);
            optionActivate.setModeId(modeId);
            optionActivate.setChargeSum(mode.getChargeSumma().subtract(maxBonusRealSumMayBePay));
            optionActivate.setWeb(true);
            int chargeContrId = this.tariffOptionService.contractTariffOptionActivateWhithSum(optionActivate);
            BonusCharge charge = new BonusCharge(0, new Date(), maxBonusRealSumMayBePay.multiply(new BigDecimal(this.service.rate())), chargeContrId);
            if (!this.service.chargeUpdate(this.contractId, charge)) {
                message.setError("\u041e\u043f\u0446\u0438\u044f \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430.<br>\u041d\u0435 \u0445\u0432\u0430\u0442\u0438\u043b\u043e \u0431\u043e\u043d\u0443\u0441\u043e\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438");
                message.setOperation("available");
            }
        }
        catch (Exception ex) {
            message.setError("\u041e\u043f\u0446\u0438\u044f \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430 <br>[" + ex.getLocalizedMessage() + "]");
            message.setOperation("available");
        }
        finally {
            this.context.getRequest().getSession().removeAttribute("optionId");
            this.context.getRequest().getSession().removeAttribute("modeId");
        }
        this.setResultParam("message", message);
        this.requestDispatcher("include", "popup_message");
    }

    private boolean isPayOnlyBonus(int modeId, int optionId) throws BGException {
        Preferences setup = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.bonus").getSetup();
        List list = Utils.toList((String)setup.get("tariffOptionsPaymentOnlyWithBonuses"));
        for (String str : list) {
            if (Utils.parseInt((String)str, (int)-1) != optionId) continue;
            return true;
        }
        return false;
    }
}

