/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.sender.smsassistent;

import jakarta.activation.DataSource;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.network.sms.smsassistent.SmsAssistent;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.Sender;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class SmsAssistentSender
extends BGLogger
implements Sender {
    private SmsAssistent smsAssistent = null;

    public SmsAssistentSender() throws BGException {
        Preferences pluginPreferences = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.dispatch").getSetup();
        String url = pluginPreferences.get("sender.sms.smsassistent.url");
        String login = pluginPreferences.get("sender.sms.smsassistent.login");
        String password = pluginPreferences.get("sender.sms.smsassistent.password");
        String sign = pluginPreferences.get("sender.sms.smsassistent.sender");
        if (Utils.isBlankString((String)login) && Utils.isBlankString((String)password)) {
            throw new BGException("\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043b\u043e\u0433\u0438\u043d \u0438/\u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c.");
        }
        this.smsAssistent = new SmsAssistent(url, login, password, sign);
    }

    @Override
    public void send(Contact contact, String title, String messageBody, List<DataSource> messageFiles) throws BGException {
        if (contact != null) {
            int result = this.smsAssistent.send(contact.getValueForSend(), messageBody);
            if (result < 0) {
                throw new BGException("\u041f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0441\u043c\u0441 c\u0435\u0440\u0432\u0438\u0441 \u0432\u0435\u0440\u043d\u0443\u043b \u043a\u043e\u0434 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430: " + result + ". \u0420\u0430\u0441\u0448\u0438\u0444\u0440\u043e\u0432\u043a\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0432 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0438 API \u043d\u0430 \u0441\u0430\u0439\u0442\u0435 http://sms-assistent.by/");
            }
        } else {
            this.getLogger().warn("\t\t\t\u0412 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u043d\u0442\u0430\u043a\u0442! \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043c\u0441-\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
        }
    }
}

