/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.ModTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;

public class CheckTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private JCheckBox check;
    private Renderer label;
    private boolean mark;
    private String searchText;
    private boolean conteintSearch;
    private boolean allBold;
    private static final Color colorMarkWinRollover = new Color(33, 161, 33);
    private static final Color colorMarkWin = new Color(116, 194, 116);
    private static final Color colorMarkPgs = new Color(60, 127, 177);

    public CheckTreeCellRenderer() {
        this.setLayout(new GridBagLayout());
        this.check = new JCheckBox();
        this.add((Component)this.check, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.label = new Renderer();
        this.add((Component)this.label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.prepare();
        this.setOpaque(false);
        this.label.setOpenIcon(ClientUtils.getIcon("node.png"));
        this.label.setClosedIcon(ClientUtils.getIcon("node.png"));
        this.label.setLeafIcon(ClientUtils.getIcon("leaf.png"));
    }

    public final DefaultTreeCellRenderer getTreeCellRenderer() {
        return this.label;
    }

    private void prepare() {
        Color bColor = UIManager.getColor("Tree.textBackground");
        this.setBackground(bColor);
        this.check.setBackground(bColor);
        this.label.setBackgroundNonSelectionColor(bColor);
        this.label.setBackgroundSelectionColor(bColor);
        this.label.setBackground(bColor);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.prepare();
        this.label.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        this.mark = false;
        if (value instanceof ModTreeNode) {
            ModTreeNode node = (ModTreeNode)value;
            this.setEnabled(tree.isEnabled());
            if (node.getIcon() != null) {
                ImageIcon icon = ClientUtils.getIcon(node.getIcon());
                this.label.setIcon(icon);
                this.label.setDisabledIcon(icon);
            }
            this.check.setEnabled(node.isEn());
            this.check.setSelected(node.isSel());
            this.mark = node.isMark() && !this.check.isSelected();
        }
        this.invalidate();
        return this;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.mark) {
            g.setColor(this.getMarkColor());
            g.fillRect(this.check.getX() + 5, this.check.getY() + 5, 3, 3);
        }
    }

    public void setSearchText(String searchText, boolean conteintSearch, boolean allBold) {
        this.searchText = null;
        if (searchText != null) {
            this.searchText = searchText.trim();
            this.conteintSearch = conteintSearch;
            this.allBold = allBold;
        }
    }

    private Color getMarkColor() {
        ButtonModel buttonmodel = this.check.getModel();
        String name = UIManager.getLookAndFeel().getClass().getName();
        if (!name.endsWith("MotifLookAndFeel")) {
            if (!buttonmodel.isEnabled()) {
                return UIManager.getColor("CheckBox.shadow");
            }
            if (!name.endsWith("WindowsLookAndFeel")) {
                if (name.endsWith("PgsLookAndFeel")) {
                    return colorMarkPgs;
                }
                return UIManager.getColor("CheckBox.darkShadow");
            }
            if (buttonmodel.isRollover() || !this.check.isRolloverEnabled()) {
                return colorMarkWinRollover;
            }
            return colorMarkWin;
        }
        return UIManager.getColor("CheckBox.foreground");
    }

    private class Renderer
    extends DefaultTreeCellRenderer {
        private Renderer() {
        }

        @Override
        public String getText() {
            if (Utils.notBlankString(CheckTreeCellRenderer.this.searchText) && CheckTreeCellRenderer.this.searchText.length() > 1 && Utils.notBlankString(super.getText())) {
                String str = super.getText().toLowerCase();
                String original = super.getText();
                int li = str.lastIndexOf(CheckTreeCellRenderer.this.searchText.toLowerCase());
                if (!CheckTreeCellRenderer.this.conteintSearch && str.startsWith(CheckTreeCellRenderer.this.searchText.toLowerCase()) || CheckTreeCellRenderer.this.conteintSearch && li != -1) {
                    if (CheckTreeCellRenderer.this.allBold) {
                        return "<html><b>" + original + "</b><html>";
                    }
                    return "<html>" + original.substring(0, li) + "<b>" + original.substring(li, li + CheckTreeCellRenderer.this.searchText.length()) + "</b>" + original.substring(li + CheckTreeCellRenderer.this.searchText.length()) + "<html>";
                }
            }
            return super.getText();
        }
    }
}

