/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterExecutor;
import ru.bitel.bgbilling.plugins.crm.server.bean.ExecuterItem;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class RegisterExecutorManager {
    private static final String TABLE_REGISTER_EXECUTOR = "register_executor";
    private static final String TABLE_REGISTER_EXECUTOR_GROUP = "register_executor_group";
    private Connection con;

    public RegisterExecutorManager(Connection con) {
        this.con = con;
    }

    public ExecuterItem getExecuterItem(int id) throws SQLException {
        ExecuterItem item = null;
        String query = "SELECT title, params FROM register_executor WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            item = new ExecuterItem();
            item.setId(id);
            item.setTitle(rs.getString(1));
            item.setParams(rs.getString(2));
        }
        rs.next();
        ps.close();
        return item;
    }

    public List<Integer> getExecuterGroupIds(int executerId) throws SQLException {
        ArrayList<Integer> groups = new ArrayList<Integer>();
        String query = "SELECT gid FROM register_executor_group WHERE eid=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, executerId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            groups.add(rs.getInt(1));
        }
        rs.close();
        ps.close();
        return groups;
    }

    public void updateExecuterItem(ExecuterItem executerItem) throws SQLException {
        PreparedStatement ps = null;
        if (executerItem.getId() < 0) {
            String query = "INSERT INTO register_executor SET title=?, params=?";
            ps = this.con.prepareStatement(query, 1);
        } else {
            String query = "UPDATE register_executor SET title=?, params=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(3, executerItem.getId());
        }
        ps.setString(1, executerItem.getTitle());
        ps.setString(2, executerItem.getParams());
        ps.executeUpdate();
        if (executerItem.getId() < 0) {
            executerItem.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }

    public void updateExecuterGroupIds(int executerId, List<Integer> groupIds) throws SQLException {
        if (executerId > 0) {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM register_executor_group WHERE eid=?");
            ps.setInt(1, executerId);
            ps.executeUpdate();
            ps.close();
            if (groupIds.size() > 0) {
                ps = this.con.prepareStatement("INSERT INTO register_executor_group SET eid=?, gid=?");
                ps.setInt(1, executerId);
                for (int groupId : groupIds) {
                    ps.setInt(2, groupId);
                    ps.executeUpdate();
                }
                ps.close();
            }
        }
    }

    @Deprecated
    public List<RegisterExecutor> getRegisterExecutorList(String groups, List<Integer> executorList) throws SQLException {
        try {
            return this.getRegisterExecutorList(Utils.toIntegerList((String)groups), executorList);
        }
        catch (BGException ex) {
            throw new SQLException(ex);
        }
    }

    public List<RegisterExecutor> getRegisterExecutorList(List<Integer> groupList) throws BGException {
        return this.getRegisterExecutorList(groupList, null);
    }

    public List<RegisterExecutor> getRegisterExecutorList(List<Integer> groupList, List<Integer> executorList) throws BGException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT DISTINCT executor.id, executor.title, executor.params FROM ");
        query.append(TABLE_REGISTER_EXECUTOR);
        query.append(" AS executor LEFT JOIN ");
        query.append(TABLE_REGISTER_EXECUTOR_GROUP);
        query.append(" AS ex_group ON ex_group.eid=executor.id ");
        query.append("WHERE 1=1");
        if (groupList != null && groupList.size() > 0) {
            query.append(" AND ex_group.gid IN ( ");
            query.append(Utils.toString(groupList));
            query.append(" )");
        }
        if (executorList != null && executorList.size() > 0) {
            query.append(" AND executor.id IN ( ");
            query.append(Utils.toString(executorList));
            query.append(" )");
        }
        query.append(" ORDER BY executor.title");
        ArrayList<RegisterExecutor> list = new ArrayList<RegisterExecutor>();
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                RegisterExecutor registerExecutor = RegisterExecutor.builder().setId(rs.getInt(1)).setTitle(rs.getString(2)).setParams(rs.getString(3)).build();
                list.add(registerExecutor);
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return list;
    }
}

