/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payonline.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.modules.payonline.common.bean.Rebill;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;

public class RebillManager
extends AbstractDao<Rebill> {
    public RebillManager(Connection con, int moduleId) {
        super(con, moduleId, "payonline_rebill");
    }

    protected Rebill getFromRS(ResultSet rs) throws SQLException, BGException {
        Rebill rebill = new Rebill();
        rebill.setContractId(rs.getInt("cid"));
        rebill.setRebillAnchor(rs.getString("rebill_anchor"));
        rebill.setSumma(rs.getBigDecimal("summa"));
        rebill.setOrderId(rs.getString("order_id"));
        rebill.setActivateDate(TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("activation_date")));
        rebill.setDay(rs.getInt("day"));
        rebill.setPeriodicity(rs.getInt("periodicity"));
        rebill.setId(rs.getInt("id"));
        return rebill;
    }

    protected void updateImpl(Rebill rebill) throws BGException, SQLException {
        PreparedStatement ps;
        int index = 1;
        if (rebill.getId() < 0) {
            String sql = "INSERT INTO " + this.tableName + " SET cid=?, summa=?, order_id=?, activation_date=?, day=?, periodicity=?";
            ps = this.con.prepareStatement(sql, 1);
            ps.setInt(index++, rebill.getContractId());
            ps.setBigDecimal(index++, rebill.getSumma());
            ps.setString(index++, rebill.getOrderId());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)rebill.getActivateDate()));
            ps.setInt(index++, rebill.getDay());
            ps.setInt(index++, rebill.getPeriodicity());
            ps.executeUpdate();
            rebill.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        } else {
            String sql = "UPDATE " + this.tableName + " SET rebill_anchor=?, order_id=? WHERE id=?";
            ps = this.con.prepareStatement(sql, 1);
            ps.setString(index++, rebill.getRebillAnchor());
            ps.setString(index++, rebill.getOrderId());
            ps.setInt(index++, rebill.getId());
            ps.executeUpdate();
        }
        ps.close();
    }

    public List<Rebill> getList(int day, int periodicity) {
        ArrayList<Rebill> list = new ArrayList<Rebill>();
        try {
            String query = "SELECT *, c.status FROM " + this.tableName + " LEFT JOIN contract c ON c.id=" + this.tableName + ".cid WHERE c.date2 IS NULL AND day=? AND periodicity=? AND rebill_anchor<>'' ORDER BY cid";
            PreparedStatement ps = this.con.prepareStatement(query);
            int index = 1;
            ps.setInt(index++, day);
            ps.setInt(index++, periodicity);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int contractStatus = rs.getInt("c.status");
                Set activeStatuses = StatusCache.getInstance().getModuleActiveStatusSet(this.moduleId);
                if (!activeStatuses.contains(contractStatus)) continue;
                list.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public Rebill getTransactionById(int id) {
        Rebill rt = null;
        try {
            rt = (Rebill)this.getById(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rt;
    }

    public Rebill getTransactionByCid(int contractId) {
        Rebill rt = null;
        try {
            rt = (Rebill)this.get("cid=?", new Object[]{contractId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rt;
    }

    public void delete(int id) throws Exception {
        this.deleteImpl(id);
    }
}

