/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action.base;

import bitel.billing.server.load.bean.Source;
import bitel.billing.server.load.bean.SourceManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.bgbilling.modules.ipn.server.bean.AddressRangeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTask;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTaskManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateType;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateTypeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.Iface;
import ru.bitel.bgbilling.modules.ipn.server.bean.IfaceManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.RangeIface;
import ru.bitel.bgbilling.modules.ipn.server.bean.RangeIfaceManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.ServiceLink;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public abstract class ActionBase
extends bitel.billing.server.ActionBase {
    protected String diapazonIP(long addr1, long addr2) {
        String ip1 = IPUtils.convertLongIpToString((long)addr1);
        String ip2 = IPUtils.convertLongIpToString((long)addr2);
        StringBuffer sb = new StringBuffer();
        if (ip1.equals(ip2)) {
            sb.append(ip1);
        } else {
            sb.append(ip1);
            sb.append("-");
            sb.append(ip2);
        }
        return sb.toString();
    }

    protected List<RangeIface> getIfaces(String id, AddressRange ar, String ifaces) throws BGMessageException, BGException {
        AddressRangeManager manager = new AddressRangeManager(this.con, this.mid);
        IfaceManager ifaceManager = new IfaceManager(this.con, this.mid);
        SourceManager sourceManager = new SourceManager(this.con);
        ArrayList<RangeIface> ifaceList = new ArrayList<RangeIface>();
        HashSet<Integer> checkedZones = new HashSet<Integer>();
        StringTokenizer st = new StringTokenizer(ifaces, ",");
        while (st.hasMoreTokens()) {
            String[] source_iface = st.nextToken().trim().split("_");
            RangeIface rangeIface = new RangeIface();
            rangeIface.setRangeId(ar.getId());
            rangeIface.setSourceId(Utils.parseInt((String)source_iface[0], (int)0));
            rangeIface.setIfaceId(Utils.parseInt((String)source_iface[1], (int)0));
            ifaceList.add(rangeIface);
            Iface iface = ifaceManager.getIface(rangeIface.getSourceId(), rangeIface.getIfaceId());
            rangeIface.setIface(iface);
            int zoneId = iface.getZoneId();
            if (zoneId == -1 || checkedZones.contains(zoneId)) continue;
            String checkResult = manager.checkAddress(id, ar, zoneId, rangeIface.getSourceId(), rangeIface.getIfaceId());
            if (checkResult.length() != 0) {
                String msg = "\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c\u0438: " + checkResult;
                Source source = sourceManager.getSource(rangeIface.getSourceId());
                if (source != null) {
                    msg = msg + " \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a " + source.getTitle() + " \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 " + iface.getTitle();
                }
                throw new BGMessageException(msg);
            }
            checkedZones.add(zoneId);
        }
        return ifaceList;
    }

    protected void buildIfaceList(int gateId, Set<String> usedIfaces) {
        GateType gateType;
        StringBuffer fullConfig = new StringBuffer(1000);
        Gate gate = new GateManager(this.con, this.mid).getGateById(gateId);
        if (gate != null && (gateType = new GateTypeManager(this.con, this.mid).getType(gate.getTypeId())) != null) {
            fullConfig.append(gateType.getConfig());
            fullConfig.append("\n");
            fullConfig.append(gate.getConfig());
        }
        Element list = this.createElement(this.rootNode, "list");
        StringTokenizer st = new StringTokenizer(fullConfig.toString(), "\n");
        while (st.hasMoreTokens()) {
            int pos;
            String[] key_value = st.nextToken().split("\\s*=\\s*");
            if (key_value.length != 2 || !key_value[0].startsWith("iface") || (pos = key_value[0].indexOf(46)) <= 0) continue;
            key_value[0] = key_value[0].substring(pos + 1);
            if (usedIfaces.contains(key_value[0])) continue;
            this.addListItem(list, key_value[0], key_value[1]);
        }
    }

    protected void createServiceLinkTable(Element data, List<ServiceLink> serviceLinks) {
        HashMap<Integer, String> serviceByID = new HashMap<Integer, String>();
        for (Service service : ModuleCache.getInstance().getModuleServicesList(this.mid)) {
            serviceByID.put(service.getId(), service.getTitle());
        }
        for (ServiceLink sl : serviceLinks) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(sl.getId()));
            row.setAttribute("pos", String.valueOf(sl.getPos()));
            row.setAttribute("period", TimeUtils.formatPeriod((Calendar)sl.getDate1(), (Calendar)sl.getDate2()));
            String serviceTitle = (String)serviceByID.get(sl.getServiceId());
            row.setAttribute("service", serviceTitle == null ? "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430" : serviceTitle);
            row.setAttribute("comment", sl.getComment());
            row.setAttribute("data", sl.serializeToString());
        }
    }

    protected boolean createDetail() throws BGException {
        int addressId = this.getIntParameter("address_id", -1);
        Calendar day = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date"));
        if (day == null) {
            GregorianCalendar nowDate = new GregorianCalendar();
            int dd = this.getIntParameter("day", 0);
            int mm = this.getIntParameter("month", nowDate.get(2) + 1);
            int yy = this.getIntParameter("year", nowDate.get(1));
            nowDate.set(1, yy);
            nowDate.set(2, mm - 1);
            nowDate.set(5, dd);
            day = nowDate;
        }
        int hour = this.getIntParameter("hour", -1);
        String mail = this.getParameter("mail");
        if (addressId <= 0 || this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (hour < 0) {
            throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0447\u0430\u0441");
        }
        if (Utils.isBlankString((String)mail) || !Utils.checkEmail((String)mail)) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 E-Mail!");
        }
        AddressRangeManager manager = new AddressRangeManager(this.con, this.mid);
        AddressRange range = manager.getAddressRange(addressId);
        if (range == null) {
            throw new BGMessageException("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        if (!TimeUtils.dateInRange((Calendar)day, (Calendar)range.getDate1(), (Calendar)range.getDate2())) {
            throw new BGMessageException("\u0412 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443 \u0430\u0434\u0440\u0435\u0441\u0430 \u043d\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0430\u043b\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
        }
        day.set(11, hour);
        HashMap<Integer, HashSet<Integer>> sourceIfaces = new HashMap<Integer, HashSet<Integer>>();
        for (RangeIface rangeIface : new RangeIfaceManager(this.con, this.mid).getAdressRangeIfaces(addressId)) {
            HashSet<Integer> ifaceSet = (HashSet<Integer>)sourceIfaces.get(rangeIface.getSourceId());
            if (ifaceSet == null) {
                ifaceSet = new HashSet<Integer>();
                sourceIfaces.put(rangeIface.getSourceId(), ifaceSet);
            }
            ifaceSet.add(rangeIface.getIfaceId());
        }
        DetailCreateTaskManager taskManager = new DetailCreateTaskManager(this.con, this.mid);
        for (Map.Entry me : sourceIfaces.entrySet()) {
            int sourceId = (Integer)me.getKey();
            Set ifaces = (Set)me.getValue();
            DetailCreateTask task = new DetailCreateTask();
            task.setModule(2);
            task.setSourceId(sourceId);
            task.setEmail(mail);
            task.setIpnHour(day);
            task.setIpnFromAddr(range.getAddr1());
            task.setIpnToAddr(range.getAddr2());
            task.setIpnIfaceSet(ifaces);
            taskManager.addTask(task);
        }
        return true;
    }
}

