/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.util.Date;
import org.json.JSONObject;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.util.DebugUtils;

public class ContractStatus
extends Id {
    private int contractId;
    private int objectId = 0;
    private int status;
    private Date dateFrom;
    private Date dateTo;
    private String comment = "";

    public String getComment() {
        return this.comment;
    }

    public ContractStatus setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @XmlAttribute
    public int getContractId() {
        return this.contractId;
    }

    public ContractStatus setContractId(int contractId) {
        this.contractId = contractId;
        return this;
    }

    @XmlAttribute
    public int getObjectId() {
        return this.objectId;
    }

    public ContractStatus setObjectId(int objectId) {
        this.objectId = objectId;
        return this;
    }

    @XmlAttribute
    public Date getDateFrom() {
        return this.dateFrom;
    }

    public ContractStatus setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
        return this;
    }

    @XmlAttribute
    public Date getDateTo() {
        return this.dateTo;
    }

    public ContractStatus setDateTo(Date dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    @XmlAttribute
    public int getStatus() {
        return this.status;
    }

    public ContractStatus setStatus(int status) {
        this.status = status;
        return this;
    }

    public ContractStatus clone() {
        return ContractStatus.builder().setContractId(this.contractId).setObjectId(this.objectId).setStatus(this.status).setDateFrom(this.dateFrom).setDateTo(this.dateTo).setComment(this.comment).setId(0).build();
    }

    @Override
    public String toString() {
        return DebugUtils.dumpObject(this);
    }

    public JSONObject toJson() {
        return new JSONObject().put("id", this.id).put("contractId", this.contractId).put("objectId", this.objectId).put("status", this.status).put("dateFrom", (Object)TimeUtils.format(this.dateFrom, "dd.MM.yyyy")).put("dateTo", (Object)TimeUtils.format(this.dateTo, "dd.MM.yyyy")).put("comment", (Object)this.comment);
    }

    public static ContractStatus fromJson(JSONObject json) {
        return ContractStatus.builder().setId(json.optInt("id")).setContractId(json.optInt("contractId")).setObjectId(json.optInt("objectId")).setStatus(json.optInt("status")).setDateFrom(TimeUtils.parseDate(json.optString("dateFrom"), "dd.MM.yyyy")).setDateTo(TimeUtils.parseDate(json.optString("dateTo"), "dd.MM.yyyy")).setComment(json.optString("comment")).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ContractStatus contractStatus = new ContractStatus();

        private Builder() {
        }

        public Builder setId(int id) {
            this.contractStatus.id = id;
            return this;
        }

        public Builder setContractId(int contractId) {
            this.contractStatus.contractId = contractId;
            return this;
        }

        public Builder setObjectId(int objectId) {
            this.contractStatus.objectId = objectId;
            return this;
        }

        public Builder setComment(String comment) {
            this.contractStatus.comment = comment;
            return this;
        }

        public Builder setDateFrom(Date dateFrom) {
            this.contractStatus.dateFrom = dateFrom;
            return this;
        }

        public Builder setDateTo(Date dateTo) {
            this.contractStatus.dateTo = dateTo;
            return this;
        }

        public Builder setStatus(int status) {
            this.contractStatus.status = status;
            return this;
        }

        public ContractStatus build() {
            return this.contractStatus;
        }
    }
}

