/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rcmts.server.bean;

import bitel.billing.server.admin.bean.AddressManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDate;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.rcmts.server.bean.RCConfigConstants;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;

public class ContractDataHelper
implements AutoCloseable {
    private final Contract contract;
    private final int contractId;
    private final Connection connection;
    private final ContractDao contractDao;
    private final ModuleSetup moduleSetup;
    private BalanceUtils balanceUtils;
    private String[] fio;

    public ContractDataHelper(Contract contract, Connection connection, int moduleId) {
        this.contract = contract;
        this.contractId = contract == null ? -1 : contract.getId();
        this.connection = connection;
        this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.contractDao = new ContractDao(connection, 0);
    }

    public String getAddress() throws BGException {
        AddressStruct addressStruct = new AddressManager(this.connection).getAddress(this.contractId, Utils.parseInt((String)this.moduleSetup.get(RCConfigConstants.ADDRESS_PID.getKey()), (int)-1));
        String address = addressStruct != null ? addressStruct.getFullAddress() : null;
        address = Utils.isBlankString((String)address) ? this.contractDao.optContractParameterTextAsString(this.contractId, Utils.parseInt((String)this.moduleSetup.get(RCConfigConstants.ADDRESS_STRING_PID.getKey()), (int)-1)).orElse("") : this.mtsStructureAddress(addressStruct);
        return Utils.maskBlank((String)address, (String)"");
    }

    private String mtsStructureAddress(AddressStruct addressStruct) {
        return Utils.maskBlank((String)addressStruct.getCountry(), (String)"") + "," + ",," + Utils.maskBlank((String)addressStruct.getCity(), (String)"") + "," + "," + Utils.maskBlank((String)addressStruct.getStreet(), (String)"") + "," + Utils.maskBlank((String)addressStruct.getHouse(), (String)"") + "," + Utils.maskBlank((String)addressStruct.getFlat(), (String)"") + ",";
    }

    public String getFio() throws BGException {
        Object fio = this.contractDao.optContractParameterTextAsString(this.contractId, Utils.parseInt((String)this.moduleSetup.get(RCConfigConstants.FIO.getKey()), (int)-1)).orElse("");
        if (Utils.notBlankString((String)fio)) {
            this.fio = ((String)fio).trim().split(" ");
            return fio;
        }
        String firstName = this.contractDao.optContractParameterTextAsString(this.contractId, Utils.parseInt((String)this.moduleSetup.get(RCConfigConstants.FIRST_NAME.getKey()), (int)-1)).orElse("");
        String lastName = this.contractDao.optContractParameterTextAsString(this.contractId, Utils.parseInt((String)this.moduleSetup.get(RCConfigConstants.LAST_NAME.getKey()), (int)-1)).orElse("");
        String middleName = this.contractDao.optContractParameterTextAsString(this.contractId, Utils.parseInt((String)this.moduleSetup.get(RCConfigConstants.MIDDLE_NAME.getKey()), (int)-1)).orElse("");
        if (Utils.notBlankString((String)firstName) && Utils.notBlankString((String)lastName)) {
            fio = lastName.trim() + " " + firstName.trim() + " " + Utils.maskBlank((String)middleName, (String)"").trim();
            this.fio = ((String)fio).split(" ");
            return fio;
        }
        throw new BGException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0424\u0418\u041e \u0434\u043b\u044f \u043e\u0442\u0432\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 contractId = " + this.contractId);
    }

    public String getFirstName() {
        if (this.fio != null && this.fio.length >= 2) {
            return this.fio[1];
        }
        return "";
    }

    public String getLastName() {
        if (this.fio != null && this.fio.length > 0) {
            return this.fio[0];
        }
        return "";
    }

    public String getMiddleName() {
        if (this.fio != null && this.fio.length >= 3) {
            return this.fio[2];
        }
        return "";
    }

    public BigDecimal getBalance() {
        if (this.balanceUtils == null) {
            this.balanceUtils = new BalanceUtils(this.connection);
        }
        return this.balanceUtils.getBalance(LocalDate.now(), this.contractId);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Contract getContract() {
        return this.contract;
    }

    public int getContractId() {
        return this.contractId;
    }

    public ModuleSetup getModuleSetup() {
        return this.moduleSetup;
    }

    public boolean contractIsActive() {
        String activeStatus = this.getModuleSetup().get(RCConfigConstants.ACTIVE_STATUS.getKey());
        return Utils.parseInt((String)activeStatus, (int)-1) == this.contract.getStatus();
    }

    @Override
    public void close() throws Exception {
        if (this.balanceUtils != null) {
            this.balanceUtils.close();
        }
        this.contractDao.close();
    }
}

