/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateType;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleType;
import ru.bitel.bgbilling.modules.ipn.server.bean.command.LoopPattern;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class GateCommandUtil {
    private static StringBuffer processBlock(String ruleText, LoopPattern loopPattern) {
        StringBuffer result = new StringBuffer();
        ArrayList<PatternItem> items = new ArrayList<PatternItem>(10);
        HashMap<String, Integer> letterMaxNumbers = new HashMap<String, Integer>();
        Pattern pattern = Pattern.compile("\\{([A-Z]+)(\\d+)\\}");
        Matcher m = pattern.matcher(ruleText);
        while (m.find()) {
            String letter = m.group(1);
            int number = Utils.parseInt((String)m.group(2), (int)0);
            PatternItem item = new PatternItem();
            item.number = number;
            item.letter = letter;
            items.add(item);
            Integer maxNumber = (Integer)letterMaxNumbers.get(letter);
            if (maxNumber != null && maxNumber >= number) continue;
            letterMaxNumbers.put(letter, number);
        }
        int size = loopPattern.getObjects().size();
        for (int i = 0; i < size; ++i) {
            String addressRule = new String(ruleText);
            for (PatternItem item : items) {
                int number = i * ((Integer)letterMaxNumbers.get(item.letter) + 1) + item.number;
                addressRule = addressRule.replaceAll("\\{" + item.letter + item.number + "\\}", "{" + item.letter + number + "}");
            }
            String str = addressRule;
            for (int j = 0; j < loopPattern.getReplacements().size(); ++j) {
                String key = loopPattern.getReplacements().get(j);
                String value = loopPattern.getObjects().get(i).get(j);
                str = str.replaceAll(key, value);
            }
            result.append(str);
        }
        return result;
    }

    public static final String generateRule(String ruleText, String addressList, Map<String, String> replacements, RuleType ruleType) {
        List<LoopPattern> loops = GateCommandUtil.getAddresLoops(addressList);
        return GateCommandUtil.generateRule(ruleText, replacements, ruleType, loops);
    }

    public static List<LoopPattern> getAddresLoops(String addressList) {
        String[] nets;
        String[] addrs;
        String[] parts = addressList.split(";");
        ArrayList<String> replacements = new ArrayList<String>();
        replacements.add("\\{A\\}");
        ArrayList<List<String>> objects = new ArrayList<List<String>>();
        if (parts.length > 0 && !Utils.isEmptyString((String)parts[0]) && (addrs = parts[0].split("\\s*,\\s*")).length > 0) {
            for (int i = 0; i < addrs.length; ++i) {
                String address = IPUtils.convertLongIpToString((long)Utils.parseLong((String)addrs[i], (long)0L));
                ArrayList<String> list = new ArrayList<String>();
                list.add(address);
                objects.add(list);
            }
        }
        ArrayList<LoopPattern> loops = new ArrayList<LoopPattern>();
        LoopPattern p = new LoopPattern();
        p.setLoopPatern("LOOP");
        p.setReplacements(replacements);
        p.setObjects(objects);
        loops.add(p);
        replacements = new ArrayList();
        replacements.add("\\{IP\\}");
        replacements.add("\\{MASK\\}");
        replacements.add("\\{MASK_WILD\\}");
        replacements.add("\\{MASK_BIT\\}");
        objects = new ArrayList();
        if (parts.length > 1 && !Utils.isEmptyString((String)parts[1]) && (nets = parts[1].split("\\s*,\\s*")).length > 0) {
            for (int i = 0; i < nets.length; ++i) {
                String[] parts2 = nets[i].split("/");
                if (parts2.length != 2) continue;
                String address = IPUtils.convertLongIpToString((long)Utils.parseLong((String)parts2[0], (long)0L));
                String maskBit = parts2[1];
                long mask = 0xFFFFFFFFL << 32 - Utils.parseInt((String)maskBit, (int)0) & 0xFFFFFFFFL;
                long maskWild = mask ^ 0xFFFFFFFFL;
                ArrayList<String> list = new ArrayList<String>();
                list.add(address);
                list.add(IPUtils.convertLongIpToString((long)mask));
                list.add(IPUtils.convertLongIpToString((long)maskWild));
                list.add(maskBit);
                objects.add(list);
            }
        }
        p = new LoopPattern();
        p.setLoopPatern("LOOP_NET");
        p.setReplacements(replacements);
        p.setObjects(objects);
        loops.add(p);
        return loops;
    }

    public static final String generateRule(String ruleText, Map<String, String> replacements, RuleType ruleType, List<LoopPattern> loops) {
        StringBuffer resultBuf = null;
        for (LoopPattern loop : loops) {
            resultBuf = new StringBuffer();
            String loopPattern = "(<LOOP>.*?</LOOP>)?(.*?)<LOOP>(.*?)</LOOP>";
            loopPattern = loopPattern.replaceAll("LOOP", loop.getLoopPatern());
            Pattern pattern = Pattern.compile(loopPattern, 32);
            Matcher matcher = pattern.matcher(ruleText);
            boolean find = false;
            while (matcher.find()) {
                find = true;
                String block = matcher.group(3);
                block = GateCommandUtil.processBlock(block, loop).toString();
                resultBuf.append(matcher.group(2));
                resultBuf.append(block);
            }
            if (find) {
                loopPattern = "(?:<LOOP>(?:.*)</LOOP>)(.*)\\z";
                pattern = Pattern.compile(loopPattern = loopPattern.replaceAll("LOOP", loop.getLoopPatern()), 32);
                Matcher matcher2 = pattern.matcher(ruleText);
                if (matcher2.find()) {
                    resultBuf.append(matcher2.group(1));
                }
            } else {
                resultBuf = new StringBuffer(ruleText);
            }
            ruleText = resultBuf.toString();
        }
        String result = resultBuf.toString();
        result = result.replaceAll("<ver 2\\.0/>", "");
        result = result.replaceAll("\r", "");
        result = result.replaceAll("\n\\s*\n", "\n");
        result = result.replaceAll("(\n){2,}", "\n");
        result = result.trim();
        String ruleData = ruleType.getData();
        ruleData.replaceAll("\r", "\n");
        ruleData = ruleData.trim();
        Preferences setup = new Preferences(ruleData, "\n");
        if (replacements == null) {
            replacements = new HashMap<String, String>();
        }
        for (Map.Entry entry : setup.sub("").entrySet()) {
            String key = "\\$\\{" + (String)entry.getKey() + "\\}";
            replacements.put(key, (String)entry.getValue());
        }
        if (replacements != null) {
            for (Map.Entry entry : replacements.entrySet()) {
                result = result.replaceAll((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return result.toString();
    }

    public static String getRule(GateType gateType, RuleType ruleType) {
        String result = "";
        String template = "\\[RULE ID=\"((?:\\d+,*)+)\"\\](.*?)\\[/RULE\\]";
        Pattern pattern = Pattern.compile(template, 32);
        Matcher m = pattern.matcher(gateType.getRule());
        while (m.find()) {
            String idsStr = m.group(1);
            String rule = m.group(2);
            int[] ids = GateCommandUtil.parseIds(idsStr);
            for (int i = 0; i < ids.length; ++i) {
                if (ruleType.getId() != ids[i]) continue;
                return rule;
            }
        }
        template = "\\[DEFAULT\\](.*)\\[/DEFAULT\\]";
        pattern = Pattern.compile(template, 32);
        m = pattern.matcher(gateType.getRule());
        if (m.find()) {
            String rule = m.group(1);
            return rule;
        }
        return result;
    }

    private static int[] parseIds(String idsStr) {
        String[] strs = idsStr.split(",");
        int[] result = new int[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            result[i] = Integer.parseInt(strs[i]);
        }
        return result;
    }

    private static class PatternItem {
        public String letter;
        public int number;

        private PatternItem() {
        }
    }
}

