/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime.device;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import ru.bitel.bgbilling.apps.voice.access.om.OrderManagerSet;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ContainerContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.resource.ResourceManager;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDeviceType;
import ru.bitel.bgbilling.modules.voice.common.mediation.Mediator;
import ru.bitel.bgbilling.modules.voice.common.mediation.RuntimeMediator;
import ru.bitel.bgbilling.modules.voice.common.om.OrderManager;
import ru.bitel.bgbilling.modules.voice.common.om.OrderManagerAdapter;
import ru.bitel.bgbilling.modules.voice.common.om.ProtocolHandler;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class VoiceDeviceRuntime
extends BGLogger {
    public final Integer voiceDeviceId;
    private final VoiceDevice voiceDevice;
    private final VoiceDeviceType voiceDeviceType;
    private final ParameterMap config;
    private final boolean loadSaInstances;
    private OrderManagerSet omInstances;
    private ProtocolHandler protocolHandler;
    private Mediator mediatorInstance;
    private RuntimeMediator mediatorRuntimeInstance;
    private final VoiceDeviceRuntime parent;
    public final Set<Integer> descendantIds;

    VoiceDeviceRuntime(Setup setup, int moduleId, VoiceDevice voiceDevice, VoiceDeviceType voiceDeviceType, VoiceDeviceRuntime parent, ParameterMap config, Set<Integer> descendantIds, boolean loadSaInstances) throws BGException {
        this.voiceDeviceId = voiceDevice.getId();
        this.voiceDevice = voiceDevice;
        this.voiceDeviceType = voiceDeviceType;
        this.loadSaInstances = loadSaInstances;
        this.descendantIds = descendantIds;
        this.parent = parent;
        this.config = config;
        this.reloadScripts(setup, moduleId, voiceDevice, voiceDeviceType);
    }

    private void reloadScripts(Setup setup, int moduleId, VoiceDevice voiceDevice, VoiceDeviceType voiceDeviceType) {
        this.getLogger().info("Reload protocolHandler class for device: " + voiceDevice);
        this.setProtocolHandler(setup, moduleId, voiceDevice, voiceDeviceType);
        this.setMediator(setup, moduleId, voiceDevice, voiceDeviceType);
        this.setMediatorRuntime(setup, moduleId, voiceDevice, voiceDeviceType);
        this.loadSaInstances(setup, moduleId, voiceDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSaInstances(Setup setup, int moduleId, VoiceDevice voiceDevice) {
        if (this.loadSaInstances) {
            this.getLogger().info("Reload SA classes for device: " + voiceDevice);
            ArrayList<OrderManagerSet.OrderManagerHolder> saInstanceList = new ArrayList<OrderManagerSet.OrderManagerHolder>();
            ServerContext ctx = new ServerContext(setup, moduleId, 0);
            ctx.init();
            try (ResourceManager rm = new ResourceManager();){
                DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
                for (VoiceDeviceRuntime deviceRuntime = this; deviceRuntime != null; deviceRuntime = deviceRuntime.getParent()) {
                    try {
                        String saHandlerClass;
                        if (deviceRuntime.getDeviceType() == null || !Utils.notBlankString((String)(saHandlerClass = deviceRuntime.getDeviceType().getOmHandlerClass())) || saHandlerClass.trim().equals("---")) continue;
                        OrderManager omInstance = (OrderManager)dynamicClassManager.newInstance(OrderManager.class, saHandlerClass);
                        rm.inject((ContainerContext)ctx, (Object)omInstance, moduleId);
                        omInstance.init(setup, moduleId, deviceRuntime.voiceDevice, deviceRuntime.voiceDeviceType, deviceRuntime.config);
                        saInstanceList.add(new OrderManagerSet.OrderManagerHolder(deviceRuntime.voiceDeviceId, omInstance, 0L, 0L, true));
                        continue;
                    }
                    catch (Throwable t) {
                        this.getLogger().error(t.getMessage(), t);
                    }
                }
                ctx.commit();
            }
            catch (Exception ex) {
                saInstanceList.clear();
                saInstanceList.add(new OrderManagerSet.OrderManagerHolder(0, (OrderManager)new OrderManagerAdapter(){

                    public Object connect() {
                        return false;
                    }
                }, 0L, 0L, true));
                this.logError(ex);
            }
            finally {
                ctx.destroy();
            }
            Collections.reverse(saInstanceList);
            this.setOmInstances(new OrderManagerSet(saInstanceList.toArray(new OrderManagerSet.OrderManagerHolder[saInstanceList.size()])));
        } else {
            this.setOmInstances(new OrderManagerSet(new OrderManagerSet.OrderManagerHolder[0]));
        }
    }

    private void setMediatorRuntime(Setup setup, int moduleId, VoiceDevice voiceDevice, VoiceDeviceType voiceDeviceType) {
        if (voiceDeviceType == null) {
            return;
        }
        RuntimeMediator mediatorRuntimeInstance = null;
        try {
            String mediatorRuntimeClass = this.getDeviceType().getMediationRuntimeHandlerClass();
            if (Utils.notBlankString((String)mediatorRuntimeClass) && !mediatorRuntimeClass.trim().equals("---")) {
                DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
                mediatorRuntimeInstance = (RuntimeMediator)dynamicClassManager.newInstance(RuntimeMediator.class, mediatorRuntimeClass);
                mediatorRuntimeInstance.init(setup, moduleId, voiceDevice, voiceDeviceType, (ParameterMap)setup);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            mediatorRuntimeInstance = null;
        }
        this.mediatorRuntimeInstance = mediatorRuntimeInstance;
    }

    private void setMediator(Setup setup, int moduleId, VoiceDevice voiceDevice, VoiceDeviceType voiceDeviceType) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("setMediator( ... ) voiceDeviceType: {}", (Object)voiceDeviceType);
        }
        if (voiceDeviceType == null) {
            return;
        }
        Mediator mediatorInstance = null;
        try {
            String mediatorClass = this.getDeviceType().getMediationHandlerClass();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("setMediator( ... ) mediatorClass: {}", (Object)mediatorClass);
            }
            if (Utils.notBlankString((String)mediatorClass) && !mediatorClass.trim().equals("---")) {
                DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
                mediatorInstance = (Mediator)dynamicClassManager.newInstance(Mediator.class, mediatorClass);
                mediatorInstance.init(setup, moduleId, voiceDevice, voiceDeviceType, (ParameterMap)new Preferences(voiceDevice.getConfig(), "\n"));
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("setMediator: mediatorInstance = " + mediatorInstance);
                    this.getLogger().debug("setMediator: moduleId = " + moduleId);
                    this.getLogger().debug("setMediator: voiceDevice = " + voiceDevice);
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            mediatorInstance = null;
        }
        this.mediatorInstance = mediatorInstance;
    }

    private void setProtocolHandler(Setup setup, int moduleId, VoiceDevice voiceDevice, VoiceDeviceType voiceDeviceType) {
        ProtocolHandler protocolHandler = null;
        if (voiceDeviceType == null) {
            return;
        }
        try {
            String protocolHandlerClass = voiceDeviceType.getProtocolHandlerClass();
            if (Utils.notBlankString((String)protocolHandlerClass) && !protocolHandlerClass.trim().equals("---")) {
                DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
                protocolHandler = (ProtocolHandler)dynamicClassManager.newInstance(ProtocolHandler.class, protocolHandlerClass);
                protocolHandler.init(setup, moduleId, voiceDevice, voiceDeviceType, this.getConfig());
            }
        }
        catch (Exception ex) {
            protocolHandler = null;
            this.logError(ex);
        }
        this.setProtocolHandler(protocolHandler);
    }

    public VoiceDevice getDevice() {
        return this.voiceDevice;
    }

    public VoiceDeviceType getDeviceType() {
        return this.voiceDeviceType;
    }

    public ParameterMap getConfig() {
        return this.config;
    }

    public OrderManagerSet getOmInstances() {
        return this.omInstances;
    }

    private void setOmInstances(OrderManagerSet omInstances) {
        this.omInstances = omInstances;
    }

    public VoiceDeviceRuntime getParent() {
        return this.parent;
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    private void setProtocolHandler(ProtocolHandler protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    public Mediator getMediatorInstance() {
        return this.mediatorInstance;
    }

    public RuntimeMediator getMediatorRuntimeInstance() {
        return this.mediatorRuntimeInstance;
    }
}

