/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.uniteller.server.event.worker;

import java.math.BigDecimal;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.uniteller.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.uniteller.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.uniteller.server.event.UnitellerAutopaymentEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class UnitellerAutopaymentEventWorker
extends EventWorker {
    private final int moduleId;
    private TransactionManager transactionManager;
    private AutopaymentManager autopaymentManager;
    private ContractDao contractDao;

    public UnitellerAutopaymentEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), UnitellerAutopaymentEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 60000L;
        this.getLogger().info("Starting UnitellerAutopaymentEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "uniteller-autopayment-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.autopaymentManager = new AutopaymentManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.contractDao = new ContractDao(((EventListenerContext)this.context).getConnection(), 0);
        try {
            boolean bl = this.doTasks();
            return bl;
        }
        finally {
            this.contractDao.close();
            this.contractDao = null;
        }
    }

    public Object doTask(Object task) throws BGException {
        try {
            UnitellerAutopaymentEvent event = (UnitellerAutopaymentEvent)((Object)task);
            int contractId = event.getContractId();
            Autopayment autopayment = this.autopaymentManager.getCurrentAutopayment(contractId);
            BigDecimal sum = event.getSum();
            if (sum == null) {
                sum = autopayment.getSum();
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("sum = " + sum);
                this.getLogger().debug("contractId = " + contractId);
                this.getLogger().debug("autopayment = " + autopayment);
            }
            if (autopayment != null && autopayment.getMode().getCode() == event.getMode()) {
                this.transactionManager.doRecurrentRequest(contractId, sum, autopayment.getAccessToken());
            }
            return null;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

