/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.oper.komstar;

import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.modules.phone.server.bean.oper.Operator;
import ru.bitel.bgbilling.modules.phone.server.oper.komstar.KomstarDbf42;
import ru.bitel.bgbilling.modules.phone.server.oper.komstar.KomstarDbfForm;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class KomstarDbf41
implements KomstarDbfForm {
    private List<Dbf41Record> record41List = new ArrayList<Dbf41Record>();

    @Override
    public void prepare(Connection con, Operator oper, Calendar month) throws SQLException {
        int billMid = oper.getOperatorSetup().getInt("bill.module.id", -1);
        ModuleSetup billModuleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(billMid));
        int advanceInvoiceType = billModuleSetup.getInt("advance.invoice.type", -1);
        String form41InvoiceTypes = oper.getOperatorSetup().get("form.41.invoice.types", null);
        int innPid = oper.getOperatorSetup().getInt("form.41.inn.pid", 1);
        int kppPid = oper.getOperatorSetup().getInt("form.41.kpp.pid", 1);
        int addressPid = oper.getOperatorSetup().getInt("form.41.address.pid", 19);
        int titlePid = oper.getOperatorSetup().getInt("form.41.title.pid", 1);
        String operCode = oper.getOperatorSetup().get("oper.code", "OPER");
        int yy = month.get(1);
        int mm = month.get(2);
        StringBuilder query = new StringBuilder(100);
        query.append("SELECT contract.title, contract.comment, invoice.format_number, invoice.create_dt, titleParam.val, ");
        query.append("invoice.summ, invoice.type, innParam.val, kppParam.val, addressParam.address");
        query.append(" FROM bill_invoice_data_");
        query.append(billMid);
        query.append(" as invoice LEFT JOIN contract ON contract.id=invoice.cid ");
        query.append(" LEFT JOIN contract_parameter_type_1 as titleParam ON IF(contract.scid>0,contract.scid,contract.id)=titleParam.cid AND titleParam.pid=");
        query.append(titlePid);
        query.append(" LEFT JOIN contract_parameter_type_1 as innParam ON IF(contract.scid>0,contract.scid,contract.id)=innParam.cid AND innParam.pid=");
        query.append(innPid);
        query.append(" LEFT JOIN contract_parameter_type_1 as kppParam ON IF(contract.scid>0,contract.scid,contract.id)=kppParam.cid AND kppParam.pid=");
        query.append(kppPid);
        query.append(" LEFT JOIN contract_parameter_type_2 as addressParam ON addressParam.cid=IF(contract.scid>0,contract.scid,contract.id) AND addressParam.pid=");
        query.append(addressPid);
        query.append(" WHERE 1 = 1 ");
        if (Utils.notBlankString((String)form41InvoiceTypes)) {
            query.append(" AND invoice.type IN ( ");
            query.append(form41InvoiceTypes);
            query.append(" ) ");
        }
        query.append(" AND yy = ");
        query.append(yy);
        query.append(" AND mm = ");
        query.append(mm);
        String reportPeriod = String.valueOf(mm) + String.valueOf(yy);
        PreparedStatement ps = con.prepareStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Dbf41Record record = new Dbf41Record();
            record.reportPeriod = reportPeriod;
            record.operCode = operCode;
            record.subscriberId = rs.getString("contract.title");
            record.invoiceNum = rs.getString("invoice.format_number");
            record.invoiceDate = rs.getDate("invoice.create_dt");
            record.customerName = titlePid == -1 ? rs.getString("contract.comment") : rs.getString("titleParam.val");
            record.customerInn = Utils.parseLong((String)rs.getString("innParam.val"));
            record.customerKpp = Utils.parseLong((String)rs.getString("kppParam.val"));
            record.customerAddress = rs.getString("addressParam.address");
            BigDecimal total = rs.getBigDecimal("invoice.summ");
            BigDecimal noNds = total.divide(new BigDecimal(1.2), 2, RoundingMode.HALF_UP);
            record.total = total.doubleValue();
            record.costNoNds = noNds.doubleValue();
            record.costNds = total.subtract(noNds).doubleValue();
            double d = record.payMode = rs.getInt("invoice.type") == advanceInvoiceType ? 1.0 : 2.0;
            if (record.payMode == 1.0) {
                record.advancePayDate = record.invoiceDate;
            }
            this.record41List.add(record);
        }
        rs.close();
        ps.close();
        int invoiceFz = oper.getOperatorSetup().getInt("form.41.fz.need.total", 0);
        if (invoiceFz <= 0) {
            return;
        }
        String fzContractTitle = oper.getOperatorSetup().get("form.41.fz.contract.title", "1000000");
        String invoiceTitle = oper.getOperatorSetup().get("form.41.fz.invoice.title", "");
        Dbf41Record totalRecord = new Dbf41Record();
        totalRecord.reportPeriod = reportPeriod;
        totalRecord.operCode = operCode;
        totalRecord.subscriberId = fzContractTitle;
        totalRecord.invoiceNum = invoiceTitle;
        totalRecord.invoiceDate = TimeUtils.getEndMonth((Date)month.getTime());
        totalRecord.customerName = "\u041d\u0430\u0441\u0435\u043b\u0435\u043d\u0438\u0435";
        totalRecord.customerInn = 0.0;
        totalRecord.customerKpp = 0.0;
        totalRecord.customerAddress = "";
        totalRecord.payMode = 2.0;
        BigDecimal total = BigDecimal.ZERO;
        KomstarDbf42 dbf42 = new KomstarDbf42();
        dbf42.prepare(con, oper, month);
        for (KomstarDbf42.Dbf42Record record : dbf42.record42List) {
            total = total.add(record.summaFull);
        }
        BigDecimal noNds = total.divide(new BigDecimal(1.2), 2, RoundingMode.HALF_UP);
        totalRecord.total = total.doubleValue();
        totalRecord.costNoNds = noNds.doubleValue();
        totalRecord.costNds = total.subtract(noNds).doubleValue();
        this.record41List.add(totalRecord);
    }

    @Override
    public void writeReport(OutputStream out) throws Exception {
        DBFReader reader = new DBFReader(this.getClass().getResourceAsStream("/ru/bitel/bgbilling/modules/phone/server/oper/komstar/templates/XXXXZZZZZ41UU.DBF"));
        DBFField[] fields = new DBFField[reader.getFieldCount()];
        for (int i = 0; i < reader.getFieldCount(); ++i) {
            fields[i] = reader.getField(i);
            System.out.println(fields[i].getName());
        }
        DBFWriter writer = new DBFWriter();
        writer.setCharactersetName("cp866");
        writer.setFields(fields);
        for (Dbf41Record record : this.record41List) {
            Object[] values = new Object[23];
            values[0] = 41.0;
            values[1] = record.reportPeriod;
            values[2] = record.operCode;
            values[3] = record.subscriberId;
            values[4] = record.invoiceNum;
            values[5] = record.invoiceDate;
            values[6] = record.customerName;
            values[7] = record.customerInn;
            values[8] = record.customerKpp;
            values[9] = record.total;
            values[10] = record.costNoNds;
            values[11] = record.costNds;
            values[18] = record.payMode;
            values[20] = record.customerAddress;
            values[21] = record.advancePayDate;
            writer.addRecord(values);
        }
        writer.write(out);
        out.flush();
    }

    @Override
    public String getTitle() {
        return "\u041a\u043e\u043c\u0441\u0442\u0430\u0440 DBF \u0444\u043e\u0440\u043c\u0430 41";
    }

    @Override
    public String getFileName(Operator oper, Date month) {
        String operator = oper.getOperatorSetup().get("oper.code", "OPER");
        return operator + TimeUtils.format((Date)month, (String)"yyyyMM") + "4101.DBF";
    }

    private static class Dbf41Record {
        static final double FORM_NUM = 41.0;
        String reportPeriod;
        String operCode;
        String subscriberId;
        String invoiceNum;
        Date invoiceDate;
        String customerName;
        double customerInn;
        double customerKpp;
        double total;
        Date advancePayDate;
        double costNoNds;
        double costNds;
        double payMode;
        String customerAddress;

        private Dbf41Record() {
        }
    }
}

