/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.omega.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.omega.common.bean.Device;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Period;

public class OmegaDao
extends AbstractIdDao<Device> {
    public OmegaDao(Connection con, int moduleId) {
        super(con, moduleId, "omega_device");
    }

    public Device getDevice(int contractId, String hash) throws SQLException {
        Device device = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE contractid=? AND hash=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setString(index++, hash);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    device = this.getFromRS(rs);
                }
            }
        }
        return device;
    }

    public List<Device> getContractDeviceList(int contractId) throws SQLException {
        return this.list("contract_id=?", "date_from", new Object[]{contractId});
    }

    public int getContractId(String hash) throws SQLException {
        int contractId = 0;
        String query = "SELECT contract_id FROM " + this.tableName + " WHERE hash=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, hash);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    contractId = rs.getInt(1);
                }
            }
        }
        return contractId;
    }

    protected Device getFromRS(ResultSet rs) throws SQLException {
        Device device = new Device();
        device.setId(rs.getInt("id"));
        device.setContractId(rs.getInt("contract_id"));
        device.setKey(rs.getString("key"));
        device.setHash(rs.getString("hash"));
        device.setPeriod(new Period((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to")));
        return device;
    }

    protected void updateImpl(Device device) throws SQLException {
        Objects.requireNonNull(device);
        boolean update = device.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET `key`='?', date_from=?, date_to=?, hash='?'" + (update ? "WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, device.getKey());
            Period period = device.getPeriod();
            if (period != null) {
                ps.setTimestamp(index++, period.getDateFrom() != null ? TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()) : null);
                ps.setTimestamp(index++, period.getDateTo() != null ? TimeUtils.convertDateToTimestamp((Date)period.getDateTo()) : null);
            } else {
                ps.setTimestamp(index++, null);
                ps.setTimestamp(index++, null);
            }
            ps.setString(index++, device.getHash());
            this.executeUpdate((Id)device, index, ps);
        }
    }
}

