/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.dhcp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionManager;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpListenerWorker;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpProcessor;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDevice;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.model.Idable;
import ru.bitel.common.util.CopyOnWriteArrayMap;

public abstract class InetAbstractDhcpProcessor
extends DhcpProcessor<InetDhcpDevice> {
    private static final Logger logger = LogManager.getLogger();
    public static final DhcpPacket.DhcpPacketOption<Object> AGENT_REMOTE_ID = new DhcpPacket.DhcpPacketOption("agentRemoteId");
    public static final DhcpPacket.DhcpPacketOption<Object> AGENT_CIRCUIT_ID = new DhcpPacket.DhcpPacketOption("agentCircuitId");
    public static final DhcpPacket.DhcpPacketOption<Object> VLAN_ID = new DhcpPacket.DhcpPacketOption("vlanId");
    public static final DhcpPacket.DhcpPacketOption<Object> INTERFACE_ID = new DhcpPacket.DhcpPacketOption("interfaceId");
    public static final DhcpPacket.DhcpPacketOption<Object> AGENT_SVLAN = new DhcpPacket.DhcpPacketOption("agentSvlan");
    protected boolean processRenew = false;
    protected final Access access;
    protected final AddressMap addressMap = new AddressMap();
    protected InetDhcpDeviceMap deviceMap;
    private static final byte ZERO_BYTE = 0;

    public InetAbstractDhcpProcessor(Access access, Setup setup, String module, int mid) {
        super(setup, module, mid);
        this.access = access;
    }

    public InetDhcpDevice getDevice(InetSocketAddress clientAddress, DhcpListenerWorker<InetDhcpDevice> req, DhcpPacket request) throws UnknownHostException {
        return this.deviceMap.getDevice((SocketAddress)clientAddress, request, true);
    }

    protected void addAccountingListeners() throws BGException {
        EventProcessor.getInstance().addListener((EventListener)new EventListener<InetConnectionManager.ConnectionAddEvent>(){

            public void notify(InetConnectionManager.ConnectionAddEvent e, EventListenerContext ctx) throws BGException {
                InetConnection connection = e.getInetConnection();
                if (connection.getParentConnectionId() > 0L) {
                    logger.debug("Skip service connection");
                    return;
                }
                int deviceId = connection.getDeviceId();
                InetDhcpDevice dhcpDevice = InetAbstractDhcpProcessor.this.deviceMap.get(deviceId);
                InetAbstractDhcpProcessor.this.onAccountingStart(e, ctx, deviceId, dhcpDevice, connection);
            }
        }, InetConnectionManager.ConnectionAddEvent.class);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<InetConnectionManager.ConnectionUpdateEvent>(){

            public void notify(InetConnectionManager.ConnectionUpdateEvent e, EventListenerContext ctx) throws BGException {
                InetConnection connection = e.getInetConnection();
                if (connection.getParentConnectionId() > 0L) {
                    logger.debug("Skip service connection");
                    return;
                }
                int deviceId = connection.getDeviceId();
                InetDhcpDevice dhcpDevice = InetAbstractDhcpProcessor.this.deviceMap.get(deviceId);
                InetAbstractDhcpProcessor.this.onAccountingUpdate(e, ctx, deviceId, dhcpDevice, connection);
            }
        }, InetConnectionManager.ConnectionUpdateEvent.class);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<InetConnectionManager.ConnectionRemoveEvent>(){

            public void notify(InetConnectionManager.ConnectionRemoveEvent e, EventListenerContext ctx) throws BGException {
                InetConnection connection = e.getInetConnection();
                if (connection.getParentConnectionId() > 0L) {
                    logger.debug("Skip service connection");
                    return;
                }
                int deviceId = connection.getDeviceId();
                InetDhcpDevice dhcpDevice = InetAbstractDhcpProcessor.this.deviceMap.get(deviceId);
                InetAbstractDhcpProcessor.this.onAccountingStop(e, ctx, deviceId, dhcpDevice, connection);
            }
        }, InetConnectionManager.ConnectionRemoveEvent.class);
    }

    protected void onAccountingStart(InetConnectionManager.ConnectionAddEvent e, EventListenerContext ctx, int deviceId, InetDhcpDevice dhcpDevice, InetConnection connection) {
    }

    protected void onAccountingUpdate(InetConnectionManager.ConnectionUpdateEvent e, EventListenerContext ctx, int deviceId, InetDhcpDevice dhcpDevice, InetConnection connection) {
    }

    protected void onAccountingStop(InetConnectionManager.ConnectionRemoveEvent e, EventListenerContext ctx, int deviceId, InetDhcpDevice dhcpDevice, InetConnection connection) {
    }

    protected static boolean isRenewRequest(DhcpPacket request) {
        return request.messageType == 3 && !InetAbstractDhcpProcessor.isNil(request.ciaddr) && request.getOption((byte)54) == null && request.getOption((byte)50) == null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, DhcpPacket request) throws UnknownHostException, BGException {
        DhcpPacket response;
        if (logger.isInfoEnabled()) {
            logger.info("REQUEST:\n" + request);
        }
        if (request.op != 1) {
            return;
        }
        logger.debug("OP_BOOT_REQUEST");
        byte messageType = request.messageType;
        InetDhcpDevice device = this.getDevice((InetSocketAddress)clientAddress, req, request);
        if (device != null && request.haveSubOptions()) {
            if (messageType != 3 && messageType != 1) {
                logger.debug("Unsupported message type: " + messageType);
                return;
            }
            response = this.processOption82Request(device, req, clientAddress, request);
        } else if (InetAbstractDhcpProcessor.isRenewRequest(request)) {
            if (!this.processRenew) {
                logger.warn("Renew request processing is disabled.");
                return;
            }
            logger.debug("Renew request");
            response = this.processRenewRequest(req, clientAddress, request);
        } else {
            if (device == null) {
                logger.warn("Device not found for address: " + IpAddress.toString((byte[])((InetSocketAddress)clientAddress).getAddress().getAddress()) + ", ignoring DHCP request.");
                return;
            }
            if (device.isOption82Required()) {
                logger.warn("DHCP request without Options.82!");
                return;
            }
            if (messageType != 3 && messageType != 1) {
                logger.debug("Unsupported message type: " + messageType);
                return;
            }
            DhcpPacket response2 = this.processOption82Request(device, req, clientAddress, request);
            return;
        }
        device = (InetDhcpDevice)req.getDevice();
        if (response != null && device != null) {
            if (device.alwaysBroadcast) {
                response.flags = (short)(response.flags | DhcpPacket.FLAG_BROADCAST);
            }
            if (device.deviceRuntime.protocolHandler != null) {
                try {
                    device.deviceRuntime.protocolHandler.postprocessDhcpRequest(request, response);
                    logger.info("RESPONSE_BEFORE_POSTPROCESS:\n" + response);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            logger.info("RESPONSE:\n" + response);
        }
        req.setResponse(response);
    }

    protected DhcpPacket processRenewRequest(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, DhcpPacket request) throws BGException, UnknownHostException {
        int ipAddress = Utils.convertBytesToInt((byte[])request.ciaddr);
        String callingStationId = Utils.bytesToString((byte[])request.chaddr, (boolean)false, null);
        DhcpPacket response = request.createResponse();
        Entry[] entries = this.addressMap.get(ipAddress);
        if (entries == null) {
            logger.error("Not found params for address: " + ipAddress);
            response.messageType = (byte)6;
            return response;
        }
        Entry entry = null;
        InetConnection connection = null;
        Entry entry2 = null;
        InetConnection connection2 = null;
        for (Entry e : entries) {
            InetConnection inetConnection = this.getConnection(e, callingStationId);
            if (inetConnection == null) continue;
            if (Utils.isBlankString((String)inetConnection.getUsername())) {
                entry = e;
                connection = inetConnection;
                break;
            }
            entry2 = e;
            connection2 = inetConnection;
        }
        if (connection == null) {
            entry = entry2;
            connection = connection2;
        }
        if (connection == null) {
            logger.error("Not found params for address: " + IPUtils.convertIpToString((int)ipAddress));
            response.messageType = (byte)6;
            return response;
        }
        Set inetOptionIds = connection.getDeviceState() == InetServState.STATE_ENABLE.getCode() ? connection.getDeviceOptions() : null;
        InetDhcpDevice device = this.deviceMap.get(connection.getDeviceId());
        if (device == null) {
            logger.error("Device not found for renew request");
            response.messageType = (byte)6;
            return response;
        }
        req.relayDeviceId = req.agentDeviceId = device.getId();
        req.setDevice((Idable)device);
        InetServRuntime servRuntime = this.access.getInetServRuntimeMap().get(connection.getServId());
        InetServRuntime parentServRuntime = servRuntime.getParentInetServRuntime(this.access);
        InetServ parentServ = parentServRuntime.getInetServ();
        req.interfaceId = parentServ.getInterfaceId();
        logger.info("Updating of existing connection: " + connection);
        this.access.connectionManager.accountingUpdate(servRuntime.getInetServ(), connection);
        return this.buildResponse(req, clientAddress, device, request, response, entry, inetOptionIds, true);
    }

    protected DhcpPacket processOption82Request(InetDhcpDevice device, DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, DhcpPacket request) throws BGException, UnknownHostException {
        req.relayDeviceId = device.getId();
        if (device.deviceSearchMode == 0 && device.deviceRuntime.protocolHandler != null) {
            try {
                device.deviceRuntime.protocolHandler.preprocessDhcpRequest(request, null);
                if (logger.isInfoEnabled()) {
                    logger.info("REQUEST_AFTER_PREPROCESS:\n" + request);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        InetDhcpDevice agentDevice = device;
        if (device.deviceSearchMode != 2) {
            Object agentRemoteId = device.deviceRuntime.getOption82AgentRemoteId(request);
            if (agentRemoteId != null && !"".equals(agentRemoteId)) {
                InetDeviceRuntime subDeviceRuntime = this.access.deviceMap.getByIdentifier(device.deviceRuntime, agentRemoteId);
                if (subDeviceRuntime != null) {
                    req.agentDeviceId = subDeviceRuntime.inetDeviceId;
                    logger.debug("Found subDevice by identifier id=" + subDeviceRuntime.inetDeviceId);
                    InetDhcpDevice dhcpDevice = this.deviceMap.get(subDeviceRuntime.inetDeviceId);
                    if (dhcpDevice != null) {
                        agentDevice = dhcpDevice;
                    }
                } else if (agentRemoteId instanceof byte[]) {
                    logger.info("Agent device not found by agentRemoteId=" + Utils.bytesToString((byte[])((byte[])agentRemoteId), (boolean)false, null));
                } else if (agentRemoteId instanceof String) {
                    logger.info("Agent device not found by agentRemoteId=" + agentRemoteId);
                } else {
                    logger.info("Agent device not found by agentRemoteId");
                }
            } else {
                logger.info("agentRemoteId is empty");
            }
        }
        if (agentDevice.deviceSearchMode != 0) {
            req.relayDeviceId = agentDevice.getId();
        }
        req.agentDeviceId = agentDevice.getId();
        req.setDevice((Idable)agentDevice);
        if ((req.relayDeviceId != req.agentDeviceId || agentDevice.deviceSearchMode != 0) && agentDevice.deviceRuntime.protocolHandler != null) {
            try {
                agentDevice.deviceRuntime.protocolHandler.preprocessDhcpRequest(request, null);
                if (logger.isInfoEnabled()) {
                    logger.info("REQUEST_AFTER_PREPROCESS:\n" + request);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.processOption82RequestImpl(req, clientAddress, agentDevice, request, InetAbstractDhcpProcessor.isRenewRequest(request));
    }

    private static final boolean isNil(byte[] b) {
        int size = b.length;
        for (int i = 0; i < size; ++i) {
            if (b[i] == 0) continue;
            return false;
        }
        return true;
    }

    protected abstract DhcpPacket processOption82RequestImpl(DhcpListenerWorker<InetDhcpDevice> var1, SocketAddress var2, InetDhcpDevice var3, DhcpPacket var4, boolean var5) throws BGException;

    protected InetConnection getConnection(Entry entry, String callingStationId) {
        List<InetConnectionRuntime> connectionRuntimeList = this.access.connectionManager.getByServId(entry.servId);
        if (connectionRuntimeList != null) {
            int size = connectionRuntimeList.size();
            for (int i = 0; i < size; ++i) {
                InetConnection connection = connectionRuntimeList.get((int)i).connection;
                if (connection.getId() != entry.connectionId || !Utils.isEmptyString((String)callingStationId) && !callingStationId.equalsIgnoreCase(connection.getCallingStationId())) continue;
                return connection;
            }
        }
        return null;
    }

    protected DhcpPacket buildResponse(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, InetDhcpDevice device, DhcpPacket request, DhcpPacket response, Entry entry, Set<Integer> inetOptionIds, boolean renew) throws BGException {
        req.connectionId = entry.connectionId;
        int address = entry.address;
        response.yiaddr = Utils.convertIntToBytes((int)address);
        if (request.messageType == 1) {
            logger.debug("DHCP_DISCOVER");
            response.messageType = (byte)2;
            device.setOptions(this.access.ipResourceManager, entry.ipResourceId, response, Utils.unsignedIntToLong((int)address), inetOptionIds, renew);
            return response;
        }
        if (request.messageType == 3) {
            logger.debug("DHCP_REQUEST");
            response.messageType = (byte)5;
            device.setOptions(this.access.ipResourceManager, entry.ipResourceId, response, Utils.unsignedIntToLong((int)address), inetOptionIds, renew);
            return response;
        }
        return null;
    }

    static final class AddressMap
    extends CopyOnWriteArrayMap<Integer, Entry> {
        public AddressMap() {
            super(64);
        }

        protected Entry[] newArray(int size) {
            return new Entry[size];
        }

        protected Entry[] newArray(Entry r) {
            return new Entry[]{r};
        }

        public Entry[] get(Integer key) {
            return (Entry[])this.arrayMap.get(key);
        }
    }

    static class Entry {
        final int ipResourceId;
        final int address;
        final int servId;
        volatile long connectionId;

        public Entry(int ipResourceId, int address, int servId, long connectionId) {
            this.ipResourceId = ipResourceId;
            this.address = address;
            this.servId = servId;
            this.connectionId = connectionId;
        }

        public int hashCode() {
            return 31 + (int)(this.connectionId ^ this.connectionId >>> 32);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return this.connectionId == ((Entry)obj).connectionId;
        }
    }
}

